/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.util.math;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.util.Mth;

public class Color {
    public float r;
    public float g;
    public float b;
    public float a;
    public static final Color WHITE = new Color(1.0f, 1.0f, 1.0f, 1.0f);
    public static final Color BLACK = new Color(0.0f, 0.0f, 0.0f, 1.0f);
    public static final Color RED = new Color(1.0f, 0.0f, 0.0f, 1.0f);
    public static final Color GREEN = new Color(0.0f, 1.0f, 0.0f, 1.0f);
    public static final Color BLUE = new Color(0.0f, 0.0f, 1.0f, 1.0f);
    public static final Color TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
    private static final Map<String, Integer> NAMED_COLORS;

    private static String normalizeName(String name) {
        return name.toLowerCase(Locale.ROOT).replaceAll("[^a-z]", "");
    }

    @Nonnull
    public static Color named(@Nonnull String name) {
        String key = Color.normalizeName(name);
        if (!NAMED_COLORS.containsKey(key)) {
            throw new IllegalArgumentException("Unknown named color: '" + name + "'");
        }
        int rgb = NAMED_COLORS.get(key);
        return new Color(rgb >> 16 & 0xFF, rgb >> 8 & 0xFF, rgb & 0xFF, 255);
    }

    @Nonnull
    public static Color parse(@Nonnull String input) {
        if (input == null) {
            throw new IllegalArgumentException("Color.parse: null string");
        }
        String s = input.trim();
        try {
            return Color.named(s);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String t = s;
            if (t.startsWith("#")) {
                t = t.substring(1);
            } else if (t.startsWith("0x") || t.startsWith("0X")) {
                t = t.substring(2);
            }
            if (t.matches("^[0-9a-fA-F]+$")) {
                int len = t.length();
                try {
                    switch (len) {
                        case 3: {
                            int r = Integer.parseInt(t.substring(0, 1) + t.substring(0, 1), 16);
                            int g = Integer.parseInt(t.substring(1, 2) + t.substring(1, 2), 16);
                            int b = Integer.parseInt(t.substring(2, 3) + t.substring(2, 3), 16);
                            return new Color(r, g, b, 255);
                        }
                        case 4: {
                            int r = Integer.parseInt(t.substring(0, 1) + t.substring(0, 1), 16);
                            int g = Integer.parseInt(t.substring(1, 2) + t.substring(1, 2), 16);
                            int b = Integer.parseInt(t.substring(2, 3) + t.substring(2, 3), 16);
                            int a = Integer.parseInt(t.substring(3, 4) + t.substring(3, 4), 16);
                            return new Color(r, g, b, a);
                        }
                        case 6: {
                            int r = Integer.parseInt(t.substring(0, 2), 16);
                            int g = Integer.parseInt(t.substring(2, 4), 16);
                            int b = Integer.parseInt(t.substring(4, 6), 16);
                            return new Color(r, g, b, 255);
                        }
                        case 8: {
                            int r = Integer.parseInt(t.substring(0, 2), 16);
                            int g = Integer.parseInt(t.substring(2, 4), 16);
                            int b = Integer.parseInt(t.substring(4, 6), 16);
                            int a = Integer.parseInt(t.substring(6, 8), 16);
                            return new Color(r, g, b, a);
                        }
                    }
                    int val = Integer.decode(s);
                    return new Color(val >> 16 & 0xFF, val >> 8 & 0xFF, val & 0xFF, 255);
                }
                catch (NumberFormatException nfe) {
                    throw new IllegalArgumentException("Invalid hex color: '" + input + "'");
                }
            }
            throw new IllegalArgumentException("Unrecognized color format: '" + input + "'");
        }
    }

    public String toHexRGBString() {
        return String.format("#%02X%02X%02X", this.getRedInt(), this.getBlueInt(), this.getGreenInt());
    }

    public Color(float r, float g, float b, float a) {
        this.r = Color.clamp01(r);
        this.g = Color.clamp01(g);
        this.b = Color.clamp01(b);
        this.a = Color.clamp01(a);
    }

    public Color(int r, int g, int b, int a) {
        this((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, (float)a / 255.0f);
    }

    public Color(float r, float g, float b) {
        this(r, g, b, 1.0f);
    }

    public Color(int r, int g, int b) {
        this(r, g, b, 255);
    }

    @Nonnull
    public static Color fromIntARGB(int argb) {
        float a = (float)(argb >> 24 & 0xFF) / 255.0f;
        float r = (float)(argb >> 16 & 0xFF) / 255.0f;
        float g = (float)(argb >> 8 & 0xFF) / 255.0f;
        float b = (float)(argb & 0xFF) / 255.0f;
        return new Color(r, g, b, a);
    }

    @Nonnull
    public static Color fromIntRGB(int rgb) {
        float r = (float)(rgb >> 16 & 0xFF) / 255.0f;
        float g = (float)(rgb >> 8 & 0xFF) / 255.0f;
        float b = (float)(rgb & 0xFF) / 255.0f;
        return new Color(r, g, b, 1.0f);
    }

    @Nonnull
    public static Color fromIntRGBA(int rgba) {
        float r = (float)(rgba >> 24 & 0xFF) / 255.0f;
        float g = (float)(rgba >> 16 & 0xFF) / 255.0f;
        float b = (float)(rgba >> 8 & 0xFF) / 255.0f;
        float a = (float)(rgba & 0xFF) / 255.0f;
        return new Color(r, g, b, a);
    }

    @Nonnull
    public static Color fromHSV(float h, float s, float v) {
        int rgb = java.awt.Color.HSBtoRGB(Color.clamp01(h), Color.clamp01(s), Color.clamp01(v));
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return new Color(r, g, b, 255);
    }

    @Nonnull
    public static Color fromHSL(float h, float s, float l) {
        return Color.fromHSL(h, s, l, 1.0f);
    }

    @Nonnull
    public static Color fromHSL(float h, float s, float l, float a) {
        h = Color.clamp01(h);
        s = Color.clamp01(s);
        l = Color.clamp01(l);
        a = Color.clamp01(a);
        if (s == 0.0f) {
            return new Color(l, l, l, a);
        }
        float q = l < 0.5f ? l * (1.0f + s) : l + s - l * s;
        float p = 2.0f * l - q;
        float hk = h;
        float[] t = new float[]{hk + 0.33333334f, hk, hk - 0.33333334f};
        for (int i = 0; i < 3; ++i) {
            if (t[i] < 0.0f) {
                int n = i;
                t[n] = t[n] + 1.0f;
            }
            if (t[i] > 1.0f) {
                int n = i;
                t[n] = t[n] - 1.0f;
            }
            t[i] = t[i] < 0.16666667f ? p + (q - p) * 6.0f * t[i] : (t[i] < 0.5f ? q : (t[i] < 0.6666667f ? p + (q - p) * (0.6666667f - t[i]) * 6.0f : p));
        }
        return new Color(t[0], t[1], t[2], a);
    }

    @Nonnull
    public static Color fromCMYK(float c, float m, float y, float k) {
        c = Color.clamp01(c);
        m = Color.clamp01(m);
        y = Color.clamp01(y);
        k = Color.clamp01(k);
        float r = 1.0f - Math.min(1.0f, c + k);
        float g = 1.0f - Math.min(1.0f, m + k);
        float b = 1.0f - Math.min(1.0f, y + k);
        return new Color(r, g, b, 1.0f);
    }

    public int toIntARGB() {
        int ai = Mth.floor((float)(this.a * 255.0f)) & 0xFF;
        int ri = Mth.floor((float)(this.r * 255.0f)) & 0xFF;
        int gi = Mth.floor((float)(this.g * 255.0f)) & 0xFF;
        int bi = Mth.floor((float)(this.b * 255.0f)) & 0xFF;
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }

    public int toIntRGB() {
        int ri = Mth.floor((float)(this.r * 255.0f)) & 0xFF;
        int gi = Mth.floor((float)(this.g * 255.0f)) & 0xFF;
        int bi = Mth.floor((float)(this.b * 255.0f)) & 0xFF;
        return ri << 16 | gi << 8 | bi;
    }

    public int toIntRGBA() {
        int ri = Mth.floor((float)(this.r * 255.0f)) & 0xFF;
        int gi = Mth.floor((float)(this.g * 255.0f)) & 0xFF;
        int bi = Mth.floor((float)(this.b * 255.0f)) & 0xFF;
        int ai = Mth.floor((float)(this.a * 255.0f)) & 0xFF;
        return ri << 24 | gi << 16 | bi << 8 | ai;
    }

    public int getRedInt() {
        return Mth.floor((float)(this.r * 255.0f)) & 0xFF;
    }

    public int getGreenInt() {
        return Mth.floor((float)(this.g * 255.0f)) & 0xFF;
    }

    public int getBlueInt() {
        return Mth.floor((float)(this.b * 255.0f)) & 0xFF;
    }

    public int getAlphaInt() {
        return Mth.floor((float)(this.a * 255.0f)) & 0xFF;
    }

    @Nonnull
    public float[] toHSV() {
        int ri = this.getRedInt();
        int gi = this.getGreenInt();
        int bi = this.getBlueInt();
        return java.awt.Color.RGBtoHSB(ri, gi, bi, null);
    }

    @Nonnull
    public float[] toHSL() {
        float s;
        float h;
        float max = Math.max(Math.max(this.r, this.g), this.b);
        float min = Math.min(Math.min(this.r, this.g), this.b);
        float l = (max + min) / 2.0f;
        float delta = max - min;
        if (delta == 0.0f) {
            h = 0.0f;
            s = 0.0f;
        } else {
            s = delta / (1.0f - Math.abs(2.0f * l - 1.0f));
            h = max == this.r ? (this.g - this.b) / delta % 6.0f : (max == this.g ? (this.b - this.r) / delta + 2.0f : (this.r - this.g) / delta + 4.0f);
            if ((h /= 6.0f) < 0.0f) {
                h += 1.0f;
            }
        }
        return new float[]{h, s, l};
    }

    @Nonnull
    public float[] toHSLA() {
        float[] hsl = this.toHSL();
        return new float[]{hsl[0], hsl[1], hsl[2], this.a};
    }

    @Nonnull
    public float[] toCMYK() {
        float rr = this.r;
        float gg = this.g;
        float bb = this.b;
        float k = 1.0f - Math.max(Math.max(rr, gg), bb);
        if (k >= 1.0f) {
            return new float[]{0.0f, 0.0f, 0.0f, 1.0f};
        }
        float c = (1.0f - rr - k) / (1.0f - k);
        float m = (1.0f - gg - k) / (1.0f - k);
        float y = (1.0f - bb - k) / (1.0f - k);
        return new float[]{c, m, y, k};
    }

    @Nonnull
    public Color lerp(@Nonnull Color other, float t) {
        t = Color.clamp01(t);
        float nr = this.r + (other.r - this.r) * t;
        float ng = this.g + (other.g - this.g) * t;
        float nb = this.b + (other.b - this.b) * t;
        float na = this.a + (other.a - this.a) * t;
        return new Color(nr, ng, nb, na);
    }

    @Nonnull
    public Color multiply(@Nonnull Color other) {
        return new Color(this.r * other.r, this.g * other.g, this.b * other.b, this.a * other.a);
    }

    @Nonnull
    public Color blend(@Nonnull Color over) {
        float ba;
        float oa = Color.clamp01(over.a);
        float outA = oa + (ba = Color.clamp01(this.a)) * (1.0f - oa);
        if (outA == 0.0f) {
            return new Color(0.0f, 0.0f, 0.0f, 0.0f);
        }
        float outR = (over.r * oa + this.r * ba * (1.0f - oa)) / outA;
        float outG = (over.g * oa + this.g * ba * (1.0f - oa)) / outA;
        float outB = (over.b * oa + this.b * ba * (1.0f - oa)) / outA;
        return new Color(outR, outG, outB, outA);
    }

    @Nonnull
    public Color invert() {
        return new Color(1.0f - this.r, 1.0f - this.g, 1.0f - this.b, this.a);
    }

    @Nonnull
    public Color grayscale() {
        float gray = 0.299f * this.r + 0.587f * this.g + 0.114f * this.b;
        return new Color(gray, gray, gray, this.a);
    }

    @Nonnull
    public Color brighter(float factor) {
        factor = Math.max(factor, 1.0f);
        return new Color(Color.clamp01(this.r * factor), Color.clamp01(this.g * factor), Color.clamp01(this.b * factor), this.a);
    }

    @Nonnull
    public Color darker(float factor) {
        factor = Math.max(factor, 1.0f);
        return new Color(Color.clamp01(this.r / factor), Color.clamp01(this.g / factor), Color.clamp01(this.b / factor), this.a);
    }

    @Nonnull
    public Color alpha(float alpha) {
        return new Color(this.r, this.g, this.b, alpha);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Color)) {
            return false;
        }
        Color other = (Color)obj;
        return Float.compare(this.r, other.r) == 0 && Float.compare(this.g, other.g) == 0 && Float.compare(this.b, other.b) == 0 && Float.compare(this.a, other.a) == 0;
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    public String toString() {
        return String.format("Color(r=%.3f,g=%.3f,b=%.3f,a=%.3f)", Float.valueOf(this.r), Float.valueOf(this.g), Float.valueOf(this.b), Float.valueOf(this.a));
    }

    private static float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    static {
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        m.put(Color.normalizeName("aliceblue"), 0xF0F8FF);
        m.put(Color.normalizeName("antiquewhite"), 16444375);
        m.put(Color.normalizeName("aqua"), 65535);
        m.put(Color.normalizeName("aquamarine"), 8388564);
        m.put(Color.normalizeName("azure"), 0xF0FFFF);
        m.put(Color.normalizeName("beige"), 16119260);
        m.put(Color.normalizeName("bisque"), 16770244);
        m.put(Color.normalizeName("black"), 0);
        m.put(Color.normalizeName("blanchedalmond"), 16772045);
        m.put(Color.normalizeName("blue"), 255);
        m.put(Color.normalizeName("blueviolet"), 9055202);
        m.put(Color.normalizeName("brown"), 0xA52A2A);
        m.put(Color.normalizeName("burlywood"), 14596231);
        m.put(Color.normalizeName("cadetblue"), 6266528);
        m.put(Color.normalizeName("chartreuse"), 0x7FFF00);
        m.put(Color.normalizeName("chocolate"), 13789470);
        m.put(Color.normalizeName("coral"), 16744272);
        m.put(Color.normalizeName("cornflowerblue"), 6591981);
        m.put(Color.normalizeName("cornsilk"), 16775388);
        m.put(Color.normalizeName("crimson"), 14423100);
        m.put(Color.normalizeName("cyan"), 65535);
        m.put(Color.normalizeName("darkblue"), 139);
        m.put(Color.normalizeName("darkcyan"), 35723);
        m.put(Color.normalizeName("darkgoldenrod"), 12092939);
        m.put(Color.normalizeName("darkgray"), 0xA9A9A9);
        m.put(Color.normalizeName("darkgreen"), 25600);
        m.put(Color.normalizeName("darkgrey"), 0xA9A9A9);
        m.put(Color.normalizeName("darkkhaki"), 12433259);
        m.put(Color.normalizeName("darkmagenta"), 0x8B008B);
        m.put(Color.normalizeName("darkolivegreen"), 5597999);
        m.put(Color.normalizeName("darkorange"), 16747520);
        m.put(Color.normalizeName("darkorchid"), 10040012);
        m.put(Color.normalizeName("darkred"), 0x8B0000);
        m.put(Color.normalizeName("darksalmon"), 15308410);
        m.put(Color.normalizeName("darkseagreen"), 9419919);
        m.put(Color.normalizeName("darkslateblue"), 4734347);
        m.put(Color.normalizeName("darkslategray"), 0x2F4F4F);
        m.put(Color.normalizeName("darkslategrey"), 0x2F4F4F);
        m.put(Color.normalizeName("darkturquoise"), 52945);
        m.put(Color.normalizeName("darkviolet"), 9699539);
        m.put(Color.normalizeName("deeppink"), 16716947);
        m.put(Color.normalizeName("deepskyblue"), 49151);
        m.put(Color.normalizeName("dimgray"), 0x696969);
        m.put(Color.normalizeName("dimgrey"), 0x696969);
        m.put(Color.normalizeName("dodgerblue"), 2003199);
        m.put(Color.normalizeName("firebrick"), 0xB22222);
        m.put(Color.normalizeName("floralwhite"), 0xFFFAF0);
        m.put(Color.normalizeName("forestgreen"), 0x228B22);
        m.put(Color.normalizeName("fuchsia"), 0xFF00FF);
        m.put(Color.normalizeName("gainsboro"), 0xDCDCDC);
        m.put(Color.normalizeName("ghostwhite"), 0xF8F8FF);
        m.put(Color.normalizeName("gold"), 16766720);
        m.put(Color.normalizeName("goldenrod"), 14329120);
        m.put(Color.normalizeName("gray"), 0x808080);
        m.put(Color.normalizeName("green"), 32768);
        m.put(Color.normalizeName("greenyellow"), 11403055);
        m.put(Color.normalizeName("grey"), 0x808080);
        m.put(Color.normalizeName("honeydew"), 0xF0FFF0);
        m.put(Color.normalizeName("hotpink"), 16738740);
        m.put(Color.normalizeName("indianred"), 0xCD5C5C);
        m.put(Color.normalizeName("indigo"), 4915330);
        m.put(Color.normalizeName("ivory"), 0xFFFFF0);
        m.put(Color.normalizeName("khaki"), 15787660);
        m.put(Color.normalizeName("lavender"), 15132410);
        m.put(Color.normalizeName("lavenderblush"), 0xFFF0F5);
        m.put(Color.normalizeName("lawngreen"), 8190976);
        m.put(Color.normalizeName("lemonchiffon"), 16775885);
        m.put(Color.normalizeName("lightblue"), 11393254);
        m.put(Color.normalizeName("lightcoral"), 0xF08080);
        m.put(Color.normalizeName("lightcyan"), 0xE0FFFF);
        m.put(Color.normalizeName("lightgoldenrodyellow"), 16448210);
        m.put(Color.normalizeName("lightgray"), 0xD3D3D3);
        m.put(Color.normalizeName("lightgreen"), 0x90EE90);
        m.put(Color.normalizeName("lightgrey"), 0xD3D3D3);
        m.put(Color.normalizeName("lightpink"), 16758465);
        m.put(Color.normalizeName("lightsalmon"), 16752762);
        m.put(Color.normalizeName("lightseagreen"), 2142890);
        m.put(Color.normalizeName("lightskyblue"), 8900346);
        m.put(Color.normalizeName("lightslategray"), 0x778899);
        m.put(Color.normalizeName("lightslategrey"), 0x778899);
        m.put(Color.normalizeName("lightsteelblue"), 11584734);
        m.put(Color.normalizeName("lightyellow"), 0xFFFFE0);
        m.put(Color.normalizeName("lime"), 65280);
        m.put(Color.normalizeName("limegreen"), 3329330);
        m.put(Color.normalizeName("linen"), 16445670);
        m.put(Color.normalizeName("magenta"), 0xFF00FF);
        m.put(Color.normalizeName("maroon"), 0x800000);
        m.put(Color.normalizeName("mediumaquamarine"), 6737322);
        m.put(Color.normalizeName("mediumblue"), 205);
        m.put(Color.normalizeName("mediumorchid"), 12211667);
        m.put(Color.normalizeName("mediumpurple"), 9662683);
        m.put(Color.normalizeName("mediumseagreen"), 3978097);
        m.put(Color.normalizeName("mediumslateblue"), 8087790);
        m.put(Color.normalizeName("mediumspringgreen"), 64154);
        m.put(Color.normalizeName("mediumturquoise"), 4772300);
        m.put(Color.normalizeName("mediumvioletred"), 13047173);
        m.put(Color.normalizeName("midnightblue"), 1644912);
        m.put(Color.normalizeName("mintcream"), 0xF5FFFA);
        m.put(Color.normalizeName("mistyrose"), 16770273);
        m.put(Color.normalizeName("moccasin"), 16770229);
        m.put(Color.normalizeName("navajowhite"), 16768685);
        m.put(Color.normalizeName("navy"), 128);
        m.put(Color.normalizeName("oldlace"), 16643558);
        m.put(Color.normalizeName("olive"), 0x808000);
        m.put(Color.normalizeName("olivedrab"), 7048739);
        m.put(Color.normalizeName("orange"), 16753920);
        m.put(Color.normalizeName("orangered"), 16729344);
        m.put(Color.normalizeName("orchid"), 14315734);
        m.put(Color.normalizeName("palegoldenrod"), 0xEEE8AA);
        m.put(Color.normalizeName("palegreen"), 10025880);
        m.put(Color.normalizeName("paleturquoise"), 0xAFEEEE);
        m.put(Color.normalizeName("palevioletred"), 14381203);
        m.put(Color.normalizeName("papayawhip"), 16773077);
        m.put(Color.normalizeName("peachpuff"), 16767673);
        m.put(Color.normalizeName("peru"), 13468991);
        m.put(Color.normalizeName("pink"), 16761035);
        m.put(Color.normalizeName("plum"), 0xDDA0DD);
        m.put(Color.normalizeName("powderblue"), 11591910);
        m.put(Color.normalizeName("purple"), 0x800080);
        m.put(Color.normalizeName("rebeccapurple"), 0x663399);
        m.put(Color.normalizeName("red"), 0xFF0000);
        m.put(Color.normalizeName("rosybrown"), 12357519);
        m.put(Color.normalizeName("royalblue"), 4286945);
        m.put(Color.normalizeName("saddlebrown"), 9127187);
        m.put(Color.normalizeName("salmon"), 16416882);
        m.put(Color.normalizeName("sandybrown"), 16032864);
        m.put(Color.normalizeName("seagreen"), 3050327);
        m.put(Color.normalizeName("seashell"), 0xFFF5EE);
        m.put(Color.normalizeName("sienna"), 10506797);
        m.put(Color.normalizeName("silver"), 0xC0C0C0);
        m.put(Color.normalizeName("skyblue"), 8900331);
        m.put(Color.normalizeName("slateblue"), 6970061);
        m.put(Color.normalizeName("slategray"), 7372944);
        m.put(Color.normalizeName("slategrey"), 7372944);
        m.put(Color.normalizeName("snow"), 0xFFFAFA);
        m.put(Color.normalizeName("springgreen"), 65407);
        m.put(Color.normalizeName("steelblue"), 4620980);
        m.put(Color.normalizeName("tan"), 13808780);
        m.put(Color.normalizeName("teal"), 32896);
        m.put(Color.normalizeName("thistle"), 14204888);
        m.put(Color.normalizeName("tomato"), 16737095);
        m.put(Color.normalizeName("turquoise"), 4251856);
        m.put(Color.normalizeName("violet"), 0xEE82EE);
        m.put(Color.normalizeName("wheat"), 16113331);
        m.put(Color.normalizeName("white"), 0xFFFFFF);
        m.put(Color.normalizeName("whitesmoke"), 0xF5F5F5);
        m.put(Color.normalizeName("yellow"), 0xFFFF00);
        m.put(Color.normalizeName("yellowgreen"), 10145074);
        NAMED_COLORS = Collections.unmodifiableMap(m);
    }
}

