/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.stereowalker.unionlib.client.gui.components.OverlayImageButton;
import com.stereowalker.unionlib.client.gui.screens.ModConfigurationScreen;
import com.stereowalker.unionlib.client.gui.screens.UnionModsScreen;
import com.stereowalker.unionlib.client.gui.screens.controls.ModControlsScreen;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.util.ScreenHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;

public class ModList
extends ContainerObjectSelectionList<Entry> {
    public ModList(Minecraft mcIn, UnionModsScreen screen) {
        super(mcIn, screen.width, screen.layout.getContentHeight(), screen.layout.getHeaderHeight(), 25);
        for (MinecraftMod mod : ModHandler.mods.values()) {
            this.addEntry((AbstractSelectionList.Entry)new ModEntry(mod.getClientSegment(), screen));
        }
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 20;
    }

    public int getRowWidth() {
        return 220;
    }

    public class ModEntry
    extends Entry {
        private final ClientSegment mod;
        private final Screen screen;
        private final Button modImage;
        private final Button configButton;
        private final boolean noConfig;

        private ModEntry(ClientSegment mod, Screen screen) {
            this.mod = mod;
            this.screen = screen;
            ArrayList keys = Lists.newArrayList();
            this.mod.setupKeymappings(keys::add);
            this.modImage = new OverlayImageButton(0, 0, 20, 20, 0, 0, 20, 20, mod.getModIcon(), 20, 20, onPress -> {}, (Component)Component.translatable((String)"menu.button.union"));
            if (this.mod.getConfigScreen(ModList.this.minecraft, this.screen) != null && keys.size() <= 0) {
                this.configButton = ScreenHelper.buttonBuilder((Component)Component.translatable((String)"union.gui.config"), onPress -> ModList.this.minecraft.setScreen(mod.getConfigScreen(ModList.this.minecraft, this.screen))).bounds(0, 0, 200, 20).build();
                this.noConfig = false;
            } else if (keys.size() > 0 && this.mod.getConfigScreen(ModList.this.minecraft, this.screen) == null) {
                this.configButton = ScreenHelper.buttonBuilder((Component)Component.translatable((String)"union.gui.controls"), onPress -> ModList.this.minecraft.setScreen((Screen)new ModControlsScreen(mod, this.screen, screen.getMinecraft().options))).bounds(0, 0, 200, 20).build();
                this.noConfig = false;
            } else if (keys.size() > 0 && this.mod.getConfigScreen(ModList.this.minecraft, this.screen) != null) {
                this.configButton = ScreenHelper.buttonBuilder((Component)Component.translatable((String)"union.gui.setup"), onPress -> ModList.this.minecraft.setScreen((Screen)new ModConfigurationScreen(mod, screen))).bounds(0, 0, 200, 20).build();
                this.noConfig = false;
            } else {
                this.configButton = ScreenHelper.buttonBuilder((Component)Component.translatable((String)"union.gui.controls"), onPress -> {}).bounds(0, 0, 200, 20).build();
                this.noConfig = true;
            }
        }

        public void render(GuiGraphics p_230432_1_, int index, int top, int left, int p_230432_5_, int p_230432_6_, int p_230432_7_, int p_230432_8_, boolean p_230432_9_, float p_230432_10_) {
            ScreenHelper.setWidgetPosition((AbstractWidget)this.modImage, left, top);
            this.modImage.render(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
            int i = ModList.this.getScrollbarPosition() - this.configButton.getWidth() - 20;
            ScreenHelper.setWidgetPosition((AbstractWidget)this.configButton, i, top);
            this.configButton.active = !this.noConfig;
            this.configButton.render(p_230432_1_, p_230432_7_, p_230432_8_, p_230432_10_);
        }

        public List<? extends GuiEventListener> children() {
            return ImmutableList.of((Object)this.modImage, (Object)this.configButton);
        }

        public List<? extends NarratableEntry> narratables() {
            return ImmutableList.of((Object)this.modImage, (Object)this.configButton);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            if (this.modImage.mouseClicked(mouseX, mouseY, button)) {
                return true;
            }
            return this.configButton.mouseClicked(mouseX, mouseY, button);
        }

        public boolean mouseReleased(double mouseX, double mouseY, int button) {
            return this.modImage.mouseReleased(mouseX, mouseY, button) || this.configButton.mouseReleased(mouseX, mouseY, button);
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
    }
}

