/*
 * Decompiled with CFR 0.152.
 */
package com.example.trackplugin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod(value="trackplugin")
public class TrackPluginMod {
    public static final String MODID = "trackplugin";
    private final Map<UUID, UUID> trackers = new HashMap<UUID, UUID>();
    private final Map<UUID, Map<ResourceKey<Level>, Vec3>> portalExit = new HashMap<UUID, Map<ResourceKey<Level>, Vec3>>();
    private final Map<UUID, Map<ResourceKey<Level>, Vec3>> portalEntry = new HashMap<UUID, Map<ResourceKey<Level>, Vec3>>();
    private final Map<UUID, Vec3> lastKnownPos = new HashMap<UUID, Vec3>();
    private boolean endBeaten = false;
    private int tickCounter = 0;

    public TrackPluginMod() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onRegisterCommands(RegisterCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"compasstracker").requires(cs -> cs.m_6761_(0))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            player.m_150109_().m_36054_(this.createTrackingCompass());
            player.m_213846_((Component)Component.m_237113_((String)"You\u2019ve got a tracking compass.").m_130940_(ChatFormatting.GREEN));
            return 1;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"track").requires(cs -> cs.m_6761_(0))).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            this.trackers.remove(player.m_20148_());
            player.m_213846_((Component)Component.m_237113_((String)"Tracking off.").m_130940_(ChatFormatting.YELLOW));
            return 1;
        })).then(Commands.m_82129_((String)"target", (ArgumentType)EntityArgument.m_91466_()).executes(ctx -> {
            ServerPlayer player = ((CommandSourceStack)ctx.getSource()).m_81375_();
            ServerPlayer target = EntityArgument.m_91474_((CommandContext)ctx, (String)"target");
            this.trackers.put(player.m_20148_(), target.m_20148_());
            player.m_213846_((Component)Component.m_237113_((String)"Now tracking ").m_7220_((Component)Component.m_237113_((String)target.m_7755_().getString()).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GREEN));
            this.updateCompassTarget(player, target);
            return 1;
        })));
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter < 20) {
            return;
        }
        this.tickCounter = 0;
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        HashMap<UUID, UUID> copy = new HashMap<UUID, UUID>(this.trackers);
        for (Map.Entry entry : copy.entrySet()) {
            UUID trackerId = (UUID)entry.getKey();
            UUID targetId = (UUID)entry.getValue();
            ServerPlayer tracker = server.m_6846_().m_11259_(trackerId);
            ServerPlayer target = server.m_6846_().m_11259_(targetId);
            if (tracker == null || target == null) {
                this.trackers.remove(trackerId);
                continue;
            }
            this.updateCompassTarget(tracker, target);
        }
        for (ServerPlayer player : server.m_6846_().m_11314_()) {
            this.lastKnownPos.put(player.m_20148_(), player.m_20182_());
        }
    }

    @SubscribeEvent
    public void onDimensionChange(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer target;
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID id = player2.m_20148_();
        ResourceKey fromDim = event.getFrom();
        ResourceKey toDim = player2.m_9236_().m_46472_();
        Vec3 exitPos = this.lastKnownPos.getOrDefault(id, player2.m_20182_());
        this.portalExit.computeIfAbsent(id, k -> new HashMap()).put(fromDim, exitPos);
        this.portalEntry.computeIfAbsent(id, k -> new HashMap()).put(toDim, player2.m_20182_());
        UUID targetId = this.trackers.get(id);
        if (targetId != null && (target = player2.f_8924_.m_6846_().m_11259_(targetId)) != null) {
            this.updateCompassTarget(player2, target);
        }
    }

    @SubscribeEvent
    public void onPlayerDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        if (!(entity instanceof Player)) {
            return;
        }
        event.getDrops().removeIf(itemEntity -> itemEntity.m_32055_().m_41720_() == Items.f_42522_);
    }

    @SubscribeEvent
    public void onEntityDeath(LivingDeathEvent event) {
        if (event.getEntity().m_6095_() == EntityType.f_20565_) {
            this.endBeaten = true;
        }
    }

    @SubscribeEvent
    public void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        UUID id = player2.m_20148_();
        if (!this.trackers.containsKey(id)) {
            return;
        }
        MinecraftServer server = player2.f_8924_;
        server.execute(() -> {
            player2.m_150109_().m_36054_(this.createTrackingCompass());
            UUID targetId = this.trackers.get(id);
            ServerPlayer target = server.m_6846_().m_11259_(targetId);
            if (target != null) {
                this.updateCompassTarget(player2, target);
            }
        });
    }

    @SubscribeEvent
    public void onCompassRightClick(PlayerInteractEvent.RightClickItem event) {
        Player player = event.getEntity();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.m_150930_(Items.f_42522_)) {
            return;
        }
        List others = player2.f_8924_.m_6846_().m_11314_().stream().filter(p -> !p.m_20148_().equals(player2.m_20148_())).sorted(Comparator.comparing(p -> p.m_7755_().getString())).collect(Collectors.toList());
        if (others.isEmpty()) {
            player2.m_213846_((Component)Component.m_237113_((String)"No other players online.").m_130940_(ChatFormatting.RED));
            return;
        }
        UUID current = this.trackers.get(player2.m_20148_());
        int idx = 0;
        if (current != null) {
            for (int i = 0; i < others.size(); ++i) {
                if (!((ServerPlayer)others.get(i)).m_20148_().equals(current)) continue;
                idx = (i + 1) % others.size();
                break;
            }
        }
        ServerPlayer target = (ServerPlayer)others.get(idx);
        this.trackers.put(player2.m_20148_(), target.m_20148_());
        player2.m_213846_((Component)Component.m_237113_((String)"Now tracking ").m_7220_((Component)Component.m_237113_((String)target.m_7755_().getString()).m_130940_(ChatFormatting.YELLOW)).m_130940_(ChatFormatting.GREEN));
        this.updateCompassTarget(player2, target);
        event.setCanceled(true);
        event.setCancellationResult(InteractionResult.SUCCESS);
    }

    private ItemStack createTrackingCompass() {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42522_);
        stack.m_41663_(Enchantments.f_44963_, 1);
        stack.m_41714_((Component)Component.m_237113_((String)"\u00a7e[\u00a7cCompass\u00a7e]"));
        CompoundTag tag = stack.m_41784_();
        int hideFlags = tag.m_128451_("HideFlags");
        tag.m_128405_("HideFlags", hideFlags |= 1);
        return stack;
    }

    private void updateCompassTarget(ServerPlayer tracker, ServerPlayer target) {
        Map exits;
        ServerLevel trackerWorld = tracker.m_9236_();
        ServerLevel targetWorld = target.m_9236_();
        ResourceKey trackerDim = trackerWorld.m_46472_();
        ResourceKey targetDim = targetWorld.m_46472_();
        Vec3 point = null;
        ResourceKey pointDim = trackerDim;
        if (targetDim == Level.f_46430_ && !this.endBeaten && (exits = this.portalExit.getOrDefault(target.m_20148_(), Collections.emptyMap())).containsKey(Level.f_46428_)) {
            point = (Vec3)exits.get(Level.f_46428_);
            pointDim = Level.f_46428_;
        }
        if (point == null) {
            if (trackerDim.equals((Object)targetDim)) {
                point = target.m_20182_();
                pointDim = targetDim;
            } else if (trackerDim == Level.f_46429_ || trackerDim == Level.f_46430_) {
                exits = this.portalExit.getOrDefault(target.m_20148_(), Collections.emptyMap());
                if (exits.containsKey(trackerDim)) {
                    point = (Vec3)exits.get(trackerDim);
                    pointDim = trackerDim;
                }
            } else if (trackerDim == Level.f_46428_ && (targetDim == Level.f_46429_ || targetDim == Level.f_46430_) && (exits = this.portalExit.getOrDefault(target.m_20148_(), Collections.emptyMap())).containsKey(Level.f_46428_)) {
                point = (Vec3)exits.get(Level.f_46428_);
                pointDim = Level.f_46428_;
            }
        }
        if (point == null) {
            BlockPos spawn = trackerWorld.m_220360_();
            point = Vec3.m_82512_((Vec3i)spawn);
            pointDim = trackerDim;
        }
        for (int i = 0; i < tracker.m_150109_().m_6643_(); ++i) {
            ItemStack item = tracker.m_150109_().m_8020_(i);
            if (item.m_41619_() || item.m_41720_() != Items.f_42522_) continue;
            CompoundTag tag = item.m_41784_();
            tag.m_128365_("LodestonePos", (Tag)NbtUtils.m_129224_((BlockPos)new BlockPos(point)));
            tag.m_128359_("LodestoneDimension", pointDim.m_135782_().toString());
            tag.m_128379_("LodestoneTracked", false);
        }
    }
}

