/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.thread;

import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventFactory;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.thread.DescriptiveProgressiveTask;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public abstract class ProgressiveTask<T> {
    private volatile boolean __isRunning = false;
    private volatile float __progress = 0.0f;
    @Nullable
    private volatile T __result = null;
    @Nullable
    private volatile Throwable __error = null;
    public final TEvent<PtPc> eProgressChanged = TEventFactory.createLoop(new PtPc[0]);
    public final TEvent<PtFinished> eFinished = TEventFactory.createLoop(new PtFinished[0]);

    public final float getProgress() {
        return this.__progress;
    }

    protected final void setProgress(float progress) {
        if (this.__progress == progress) {
            return;
        }
        this.__progress = progress = Math.max(0.0f, Math.min(1.0f, progress));
        try {
            this.eProgressChanged.invoker().invoke(progress);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final boolean isRunning() {
        return this.__isRunning;
    }

    public final boolean isFinished() {
        return !this.__isRunning && this.__progress >= 1.0f;
    }

    @Nullable
    public final T getResult() {
        return this.isFinished() ? (T)this.__result : null;
    }

    @Nullable
    public final Throwable getError() {
        return this.isFinished() ? this.__error : null;
    }

    public final void clearFlags() throws IllegalStateException {
        if (this.__isRunning) {
            throw new IllegalStateException("Cannot clear task flags while the task is running.");
        }
        this.__progress = 0.0f;
        this.__isRunning = true;
        this.__result = null;
        this.__error = null;
        ProgressiveTask progressiveTask = this;
        if (progressiveTask instanceof DescriptiveProgressiveTask) {
            DescriptiveProgressiveTask dpt = (DescriptiveProgressiveTask)progressiveTask;
            dpt.__description = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final synchronized void executeSync() {
        this.__isRunning = false;
        this.clearFlags();
        try {
            this.__isRunning = true;
            this.__result = this.onExecuteTask();
        }
        catch (Throwable e) {
            this.__error = e;
            ProgressiveTask progressiveTask = this;
            if (progressiveTask instanceof DescriptiveProgressiveTask) {
                DescriptiveProgressiveTask dpt = (DescriptiveProgressiveTask)progressiveTask;
                dpt.setProgressDescription((class_2561)TextUtils.literal("").method_10852((class_2561)TextUtils.translatable("mco.errorMessage.generic", new Object[0])).method_27693(e.getClass().getName() + ": ").method_27693(e.getLocalizedMessage()));
            }
        }
        finally {
            this.setProgress(1.0f);
            this.__isRunning = false;
        }
        try {
            this.eFinished.invoker().invoke();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Nullable
    protected abstract T onExecuteTask() throws Exception;

    public static interface PtPc {
        public void invoke(float var1);
    }

    public static interface PtFinished {
        public void invoke();
    }
}

