/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.other;

import io.github.thecsdev.tcdcommons.api.client.gui.other.TBlankElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.client.ClientEntitySandbox;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.MultiLineLabel;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="3.12.8")
@Virtual
public class TEntityRendererElement
extends TBlankElement {
    @Nullable
    protected Entity entity;
    @Nullable
    protected MultiLineLabel entityTypeName;
    protected boolean entityErrorState;
    protected int entityTextX;
    protected int entityTextY;
    protected int entityDisplaySize;
    protected double entityScale;
    protected boolean followsCursor;
    public static final Map<EntityType<?>, Supplier<Double>> EntityGuiSizeOffsets = new HashMap();

    public TEntityRendererElement(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public TEntityRendererElement(int x, int y, int width, int height, EntityType<?> entityType) {
        super(x, y, width, height);
        this.setEntityScale(0.9);
        this.setFollowsCursor(true);
        this.setEntity(entityType);
        if (entityType != EntityType.PLAYER) {
            this.entityErrorState = true;
        }
    }

    @Override
    @Virtual
    public void setSize(int width, int height, int flags) {
        super.setSize(width, height, flags);
        this.recalcCache_mobSize();
    }

    @Nullable
    public final Entity getEntity() {
        return this.entity;
    }

    @Nullable
    public final EntityType<?> getEntityType() {
        return this.entity != null ? this.entity.getType() : null;
    }

    public final void setEntity(@Nullable EntityType<?> entityType) {
        Entity entity = ClientEntitySandbox.getCachedEntityFromType(entityType);
        this.setEntity(entity);
        if (entity == null) {
            this.entityErrorState = true;
            if (entityType != null) {
                this.updateEntityTypeName(entityType);
            }
        }
    }

    public final void setEntity(@Nullable Entity entity) {
        this.entity = entity;
        this.updateEntityTypeName(this.getEntityType());
        this.entityErrorState = false;
        this.recalcCache_mobSize();
    }

    @ApiStatus.Internal
    protected final void updateEntityTypeName(EntityType<?> entityType) {
        Font textRenderer = TCDCommonsClient.MC_CLIENT.font;
        this.entityTypeName = entityType != null ? MultiLineLabel.create((Font)textRenderer, (Component)entityType.getDescription(), (int)this.width) : MultiLineLabel.create((Font)textRenderer, (Component[])new Component[]{TextUtils.literal("-")});
    }

    public final boolean getFollowsCursor() {
        return this.followsCursor;
    }

    @Virtual
    public void setFollowsCursor(boolean followsCursor) {
        this.followsCursor = followsCursor;
    }

    public final double getEntityScale() {
        return this.entityScale;
    }

    public final void setEntityScale(double entityScale) {
        this.entityScale = Mth.clamp((double)entityScale, (double)0.1, (double)5.0);
        this.recalcCache_mobSize();
    }

    protected final void recalcCache_mobSize() {
        if (this.entity == null) {
            this.entityDisplaySize = 30;
            return;
        }
        int viewportSize = Math.min(this.width, this.height);
        this.entityDisplaySize = (int)((double)TEntityRendererElement.calculateEntityGUISize(this.entity, viewportSize) * this.entityScale);
    }

    protected final void recalcCache_cXY() {
        this.entityTextX = this.x + this.width / 2;
        if (this.entityTypeName != null) {
            Objects.requireNonNull(TCDCommonsClient.MC_CLIENT.font);
            int fh = 9;
            this.entityTextY = this.getY() + this.getHeight() / 2 + fh / 2 - this.entityTypeName.getLineCount() * fh;
        } else {
            this.entityTextY = this.getEndY() - this.height / 4;
        }
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        this.recalcCache_cXY();
        if (this.entityErrorState || this.entity == null) {
            if (this.entityTypeName != null) {
                Objects.requireNonNull(TCDCommonsClient.MC_CLIENT.font);
                this.entityTypeName.render((GuiGraphics)pencil, MultiLineLabel.Align.CENTER, this.entityTextX, this.entityTextY, 9, false, -1);
            } else {
                pencil.drawTFill(-65281);
            }
            return;
        }
        try {
            pencil.drawTEntity(this.entity, this.x, this.y, this.width, this.height, this.entityDisplaySize, this.followsCursor);
        }
        catch (Exception e) {
            this.entityErrorState = true;
        }
    }

    public static double getEntityGuiSizeOffset(EntityType<?> entityType) {
        return EntityGuiSizeOffsets.getOrDefault(entityType, () -> 1.0).get();
    }

    public static int calculateEntityGUISize(Entity entity, int viewportSize) {
        float f2;
        int maxVal = (int)(50.0f * ((float)viewportSize / 80.0f));
        if (entity == null) {
            return maxVal;
        }
        int result = maxVal;
        float f1 = entity.getType().getDimensions().width();
        double d0 = Math.sqrt(f1 * f1 + (f2 = entity.getType().getDimensions().height()) * f2);
        if (d0 == 0.0) {
            d0 = 0.1;
        }
        result = (int)((double)maxVal / d0);
        result = (int)((double)result * TEntityRendererElement.getEntityGuiSizeOffset(entity.getType()));
        return result;
    }

    static {
        EntityGuiSizeOffsets.put(EntityType.ENDER_DRAGON, () -> 4.0);
    }
}

