/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TRefreshablePanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TClickableWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectFileFilterWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TTextFieldWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Virtual
@ApiStatus.Experimental
public class ActionBar
extends TRefreshablePanelElement {
    public static final int HEIGHT = 65;
    protected final ActionBarProxy proxy;
    @Nullable
    private FileNameInputField in_filename;
    @Nullable
    private TSelectFileFilterWidget in_filefilter;
    @Nullable
    private TClickableWidget btn_done;
    @Nullable
    private TClickableWidget btn_cancel;

    public ActionBar(int x, int y, int width, ActionBarProxy proxy) {
        this(x, y, width, 65, proxy);
    }

    public ActionBar(int x, int y, int width, int height, ActionBarProxy proxy) {
        super(x, y, Math.max(width, 50), Math.max(height, 65));
        this.scrollFlags = 0;
        this.scrollPadding = 0;
        this.outlineColor = 0;
        this.backgroundColor = -16777216;
        this.proxy = Objects.requireNonNull(proxy);
    }

    public final ActionBarProxy getProxy() {
        return this.proxy;
    }

    protected final boolean TRefreshablePanelElement_super_input(TInputContext inputContext) {
        return super.input(inputContext);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        return false;
    }

    @Nullable
    public final TTextFieldWidget getFileNameInput() {
        return this.in_filename;
    }

    @Nullable
    public final TSelectFileFilterWidget getFileFilterInput() {
        return this.in_filefilter;
    }

    @Nullable
    public final TClickableWidget getDoneButton() {
        return this.btn_done;
    }

    @Nullable
    public final TClickableWidget getCancelButton() {
        return this.btn_cancel;
    }

    public final void setSelectedFileName(String selectedFileName) throws IllegalStateException {
        if (this.in_filename == null) {
            throw new IllegalStateException("Not initialized yet.");
        }
        this.in_filename.setInput(selectedFileName);
    }

    public final void setSelectedFileFilter(TFileFilter fileFilter) throws IllegalStateException, NoSuchElementException {
        if (this.in_filefilter == null) {
            throw new IllegalStateException("Not initialized yet.");
        }
        this.in_filefilter.setSelected(fileFilter);
    }

    public final void focusOnFileNameInput() throws IllegalStateException {
        if (this.in_filename == null || this.getParentTScreen() == null) {
            throw new IllegalStateException("Not initialized yet.");
        }
        this.getParentTScreen().setFocusedElement(this.in_filename);
    }

    @Override
    @Virtual
    protected void init() {
        TLabelElement lbl_filename = new TLabelElement(5, 5, this.getWidth() - 10, 15);
        lbl_filename.setText((Component)TCDCT.gui_explorer_actionBar_fileName());
        this.addChild(lbl_filename, true);
        TLabelElement lbl_filetype = new TLabelElement(this.getX() + 5, lbl_filename.getEndY() + 5, lbl_filename.getWidth(), 15);
        lbl_filetype.setText((Component)TCDCT.gui_explorer_actionBar_fileType());
        this.addChild(lbl_filetype, false);
        this.in_filename = new FileNameInputField(this, 0, lbl_filename.getY(), lbl_filename.getWidth() / 10 * 7, 15);
        this.in_filename.setPosition(lbl_filename.getEndX() - this.in_filename.getWidth(), this.in_filename.getY(), false);
        this.addChild(this.in_filename, false);
        this.in_filefilter = new TSelectFileFilterWidget(this.in_filename.getX(), this.in_filename.getY() + 20, this.in_filename.getWidth(), 15, this.proxy.getFileFilters());
        this.in_filefilter.setSelected(this.in_filefilter.entryOf(this.proxy.getSelectedFileFilter()), false);
        this.in_filefilter.eSelectionChanged.register((self, sel) -> this.proxy.onSelectFileFilter(sel == null ? null : sel.getFileFilter()));
        this.addChild(this.in_filefilter, false);
        TButtonWidget btn_canc = new TButtonWidget(this.getEndX() - 65, this.getEndY() - 20, 60, 15);
        btn_canc.setText((Component)TextUtils.translatable("gui.cancel", new Object[0]));
        btn_canc.setEnabled(this.proxy.canCancel());
        btn_canc.setOnClick(__ -> this.proxy.onCancel());
        this.addChild(btn_canc, false);
        TButtonWidget btn_done = new TButtonWidget(btn_canc.getX() - 65, btn_canc.getY(), 60, 15);
        btn_done.setText(this.proxy.getSubmitButtonText());
        btn_done.setEnabled(this.proxy.canSubmit());
        btn_done.setOnClick(__ -> this.proxy.onSubmit(new ActionBarProxy.SubmitContext(){

            @Override
            public final String getSelectedFileName() {
                return ActionBar.this.in_filename.getInput();
            }

            @Override
            public final TFileFilter getSelectedFileFilter() {
                TSelectFileFilterWidget.FileFilterEntry ff = (TSelectFileFilterWidget.FileFilterEntry)ActionBar.this.in_filefilter.getSelected();
                return ff != null ? ff.getFileFilter() : TFileFilter.ALL_FILES;
            }
        }));
        this.addChild(btn_done, false);
        this.btn_done = btn_done;
        this.btn_cancel = btn_canc;
    }

    public static interface ActionBarProxy {
        public Iterable<TFileFilter> getFileFilters();

        public TFileFilter getSelectedFileFilter();

        public void onSelectFileFilter(TFileFilter var1);

        public Component getSubmitButtonText();

        default public boolean canCancel() {
            return true;
        }

        default public boolean canSubmit() {
            return true;
        }

        public void onCancel();

        public void onSubmit(SubmitContext var1);

        public static interface SubmitContext {
            public String getSelectedFileName();

            public TFileFilter getSelectedFileFilter();
        }
    }

    protected final class FileNameInputField
    extends TTextFieldWidget {
        static final int[] blacklist = new int[]{34, 60, 62, 124, 58, 42, 63, 92, 47};

        public FileNameInputField(ActionBar this$0, int x, int y, int width, int height) {
            super(x, y, width, height);
        }

        @Override
        public final boolean isCharacterAllowed(char c) {
            return Arrays.binarySearch(blacklist, (int)c) < 0;
        }
    }
}

