/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.panel.TRefreshablePanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TTextFieldWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@Virtual
@ApiStatus.Experimental
public class NavigationBar
extends TRefreshablePanelElement {
    public static final int HEIGHT = 15;
    protected final NavigationBarProxy proxy;

    public NavigationBar(int x, int y, int width, NavigationBarProxy proxy) {
        this(x, y, width, 15, proxy);
    }

    public NavigationBar(int x, int y, int width, int height, NavigationBarProxy proxy) {
        super(x, y, width, Math.max(height, 15));
        this.scrollFlags = 0;
        this.scrollPadding = 0;
        this.outlineColor = 0;
        this.backgroundColor = -16777216;
        this.proxy = Objects.requireNonNull(proxy);
    }

    public final NavigationBarProxy getProxy() {
        return this.proxy;
    }

    protected final boolean TRefreshablePanelElement_super_input(TInputContext inputContext) {
        return super.input(inputContext);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        return false;
    }

    @Override
    @Virtual
    protected void init() {
        TButtonWidget btn_back = new TButtonWidget(0, 0, 15, 15, (Component)TextUtils.literal("<"));
        btn_back.setEnabled(this.proxy.canNavigateBackward());
        btn_back.setOnClick(__ -> this.proxy.onNavigateBackward());
        this.addChild(btn_back, true);
        TButtonWidget btn_forw = new TButtonWidget(15, 0, 15, 15, (Component)TextUtils.literal(">"));
        btn_forw.setEnabled(this.proxy.canNavigateForward());
        btn_forw.setOnClick(__ -> this.proxy.onNavigateForward());
        this.addChild(btn_forw, true);
        TButtonWidget btn_refr = new TButtonWidget(30, 0, 15, 15, (Component)TextUtils.literal("O"));
        btn_refr.setEnabled(this.proxy.canRefresh());
        btn_refr.setOnClick(__ -> this.proxy.onRefresh());
        this.addChild(btn_refr, true);
        TTextFieldWidget txt_path = new TTextFieldWidget(45, 0, this.getWidth() - 45 - 1, 15);
        txt_path.setEnabled(false);
        txt_path.setInput(this.proxy.getCurrentPath().toAbsolutePath().toString());
        this.addChild(txt_path, true);
    }

    public static interface NavigationBarProxy {
        public Path getCurrentPath();

        default public boolean canNavigateForward() {
            return false;
        }

        default public boolean canNavigateBackward() {
            return false;
        }

        default public boolean canRefresh() {
            return false;
        }

        default public void onNavigateForward() {
        }

        default public void onNavigateBackward() {
        }

        default public void onRefresh() {
        }
    }
}

