/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.AbstractFileListPanel;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.io.File;
import java.nio.file.Path;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@Virtual
@ApiStatus.Experimental
public class SidebarPanel
extends AbstractFileListPanel<AbstractFileListPanel.FileListPanelProxy> {
    public SidebarPanel(int x, int y, int width, int height, AbstractFileListPanel.FileListPanelProxy proxy) {
        super(x, y, width, height, proxy);
    }

    @Override
    @Virtual
    protected void init() {
        try {
            this.addSectionLabel((Component)TextUtils.literal("*"));
            this.addFileListItem(new File(System.getProperty("user.home")));
            switch (Util.getPlatform()) {
                case WINDOWS: {
                    this.addFileListItem(new File(System.getProperty("user.home") + "\\Desktop"));
                    break;
                }
                case LINUX: 
                case OSX: {
                    this.addFileListItem(new File(System.getProperty("user.home") + "/Desktop"));
                    break;
                }
                case SOLARIS: {
                    break;
                }
            }
            this.addSectionLabel((Component)TextUtils.literal("*"));
            Path userDir = Path.of(System.getProperty("user.dir"), new String[0]);
            this.addFileListItem(userDir.toFile());
            this.addFileListItem(userDir.resolve("config").toFile());
            this.addFileListItem(userDir.resolve("saves").toFile());
            this.addSectionLabel((Component)TextUtils.literal("*"));
            for (File rootFile : File.listRoots()) {
                this.addFileListItem(rootFile);
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

