/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTextureElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TRefreshablePanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Virtual
@ApiStatus.Experimental
public class TitleBar
extends TRefreshablePanelElement {
    public static final int HEIGHT = 15;
    protected final TitleBarProxy proxy;

    public TitleBar(int x, int y, int width, TitleBarProxy proxy) {
        this(x, y, width, 15, proxy);
    }

    public TitleBar(int x, int y, int width, int height, TitleBarProxy proxy) {
        super(x, y, Math.max(width, 65), Math.max(height, 15));
        this.scrollFlags = 0;
        this.scrollPadding = 0;
        this.outlineColor = 0;
        this.backgroundColor = -16777216;
        this.proxy = Objects.requireNonNull(proxy);
    }

    protected final boolean TRefreshablePanelElement_super_input(TInputContext inputContext) {
        return super.input(inputContext);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        return false;
    }

    @Override
    @Virtual
    protected void init() {
        TTextureElement ico = new TTextureElement(0, 0, 15, 15);
        ico.setTexture(this.proxy.getIcon());
        this.addChild(ico, true);
        TLabelElement lbl_title = new TLabelElement(15, 1, this.getWidth() - 15, 15);
        lbl_title.setText(this.proxy.getTitle());
        this.addChild(lbl_title, true);
        this.init_squareButtons();
    }

    @Virtual
    protected void init_squareButtons() {
        if (this.proxy.canMinimize()) {
            this.addSquareButton((Component)TextUtils.literal("-"), __ -> this.proxy.onMinimize());
        }
        if (this.proxy.canRestore()) {
            this.addSquareButton((Component)TextUtils.literal("\u25a1"), __ -> this.proxy.onRestore());
        }
        if (this.proxy.canClose()) {
            this.addSquareButton((Component)TextUtils.literal("X"), __ -> this.proxy.onClose());
        }
    }

    protected final TButtonWidget addSquareButton(Component text, Consumer<TButtonWidget> onClick) {
        for (TElement c : this.getChildren()) {
            if (!(c instanceof TitleBarSquareButton)) continue;
            c.setPosition(c.getX() - 15, c.getY(), false);
        }
        TitleBarSquareButton btn = new TitleBarSquareButton(this.getWidth() - 15, 0, 15, 15, text, onClick);
        this.addChild(btn, true);
        return btn;
    }

    public static interface TitleBarProxy {
        @Nullable
        public Component getTitle();

        @Nullable
        default public UITexture getIcon() {
            return null;
        }

        default public boolean canMinimize() {
            return false;
        }

        default public boolean canRestore() {
            return false;
        }

        default public boolean canClose() {
            return false;
        }

        default public void onMinimize() {
        }

        default public void onRestore() {
        }

        default public void onClose() {
        }
    }

    protected static final class TitleBarSquareButton
    extends TButtonWidget {
        public TitleBarSquareButton(int x, int y, int width, int height, Component text, Consumer<TButtonWidget> onClick) {
            super(x, y, width, height, text, onClick);
        }

        public TitleBarSquareButton(int x, int y, int width, int height, Component text) {
            super(x, y, width, height, text);
        }

        public TitleBarSquareButton(int x, int y, int width, int height) {
            super(x, y, width, height);
        }
    }
}

