/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.ActionBar;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.TFileExplorerPanel;
import io.github.thecsdev.tcdcommons.api.util.enumerations.FileChooserDialogType;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import io.github.thecsdev.tcdcommons.api.util.io.TExtensionFileFilter;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
final class ActionBarProxyImpl
implements ActionBar.ActionBarProxy {
    protected final TFileExplorerPanel explorer;
    protected final TFileExplorerPanel.FileExplorerPanelProxy proxy;

    protected ActionBarProxyImpl(TFileExplorerPanel explorer) {
        this.explorer = Objects.requireNonNull(explorer);
        this.proxy = Objects.requireNonNull(explorer.proxy);
    }

    @Override
    public final Iterable<TFileFilter> getFileFilters() {
        return this.proxy.getFileFilters();
    }

    @Override
    public final TFileFilter getSelectedFileFilter() {
        return this.proxy.getSelectedFileFilter();
    }

    @Override
    public final void onSelectFileFilter(TFileFilter selectedFileFilter) {
        this.proxy.setSelectedFileFilter(selectedFileFilter);
        this.explorer.fileListPanel.refresh();
    }

    @Override
    public final Component getSubmitButtonText() {
        return this.explorer.type == FileChooserDialogType.SAVE_FILE ? TFileExplorerPanel.TXT_ACTION_SAVE : TFileExplorerPanel.TXT_ACTION_OPEN;
    }

    @Override
    public final void onCancel() {
        this.explorer.completeAsCancelled();
    }

    @Override
    public final void onSubmit(ActionBar.ActionBarProxy.SubmitContext submitContext) {
        switch (this.explorer.type) {
            case SELECT_DIRECTORY: {
                this.onSubmit_selDir(submitContext);
                break;
            }
            case OPEN_FILE: {
                this.onSubmit_openFile(submitContext);
                break;
            }
            case SAVE_FILE: {
                this.onSubmit_saveFile(submitContext);
                break;
            }
            default: {
                this.explorer.completeAsError();
            }
        }
    }

    private final void onSubmit_selDir(ActionBar.ActionBarProxy.SubmitContext submitContext) {
        Path currentDirectory = this.explorer.getProxy().getCurrentDirectory();
        String selFileName = submitContext.getSelectedFileName();
        if (selFileName.length() == 0) {
            this.explorer.completeAsApprove(currentDirectory.toFile());
        } else {
            try {
                Path nextDir = currentDirectory.resolve(selFileName);
                if (Files.exists(nextDir, new LinkOption[0])) {
                    this.explorer.proxy.setCurrentDirectory(nextDir);
                    this.explorer.refresh();
                } else {
                    this.explorer.actionBar.focusOnFileNameInput();
                }
            }
            catch (SecurityException se) {
                this.onSubmit_securityError(se);
            }
        }
    }

    private final void onSubmit_openFile(ActionBar.ActionBarProxy.SubmitContext submitContext) {
        Path currentDirectory = this.explorer.getProxy().getCurrentDirectory();
        if (submitContext.getSelectedFileName().length() == 0) {
            this.explorer.actionBar.focusOnFileNameInput();
        } else {
            try {
                Object selFileName = submitContext.getSelectedFileName();
                String targetExtension = this.explorer.proxy.getTargetFileExtension();
                if (targetExtension != null && !((String)selFileName).endsWith(targetExtension = TExtensionFileFilter.sanitizeExtension(targetExtension))) {
                    selFileName = (String)selFileName + targetExtension;
                }
                File nextFile = currentDirectory.resolve((String)selFileName).toFile();
                TFileFilter ff = submitContext.getSelectedFileFilter();
                if (ff != null && ff.accept(nextFile) && nextFile.exists() && nextFile.isFile()) {
                    this.explorer.completeAsApprove(nextFile);
                } else {
                    this.explorer.actionBar.focusOnFileNameInput();
                }
            }
            catch (SecurityException se) {
                this.onSubmit_securityError(se);
            }
        }
    }

    private final void onSubmit_saveFile(ActionBar.ActionBarProxy.SubmitContext submitContext) {
        Path currentDirectory = this.explorer.getProxy().getCurrentDirectory();
        if (submitContext.getSelectedFileName().length() == 0) {
            this.explorer.actionBar.focusOnFileNameInput();
        } else {
            Object selFileName = submitContext.getSelectedFileName();
            String targetExtension = this.explorer.proxy.getTargetFileExtension();
            if (targetExtension != null && !((String)selFileName).endsWith(targetExtension = TExtensionFileFilter.sanitizeExtension(targetExtension))) {
                selFileName = (String)selFileName + targetExtension;
            }
            File nextFile = currentDirectory.resolve((String)selFileName).toFile();
            this.explorer.completeAsApprove(nextFile);
        }
    }

    private final void onSubmit_securityError(SecurityException se) {
        TCDCommons.LOGGER.error(ActionBarProxyImpl.class.getSimpleName() + " encountered a " + SecurityException.class.getSimpleName());
        se.printStackTrace();
        this.explorer.completeAsError();
    }
}

