/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Direction2D;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public abstract class TScreenPlus
extends TScreen {
    private static final Predicate<TElement> DEFAULT_FCSE_PREDICATE = e -> e.isFocusable() && e.isEnabledAndVisible();

    public TScreenPlus(Component title) {
        super(title);
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        if (super.input(inputContext)) {
            return true;
        }
        switch (inputContext.getInputType()) {
            case KEY_PRESS: {
                int keyCode = inputContext.getKeyboardKey().keyCode;
                Direction2D direction = null;
                switch (keyCode) {
                    case 265: {
                        direction = Direction2D.UP;
                        break;
                    }
                    case 264: {
                        direction = Direction2D.DOWN;
                        break;
                    }
                    case 263: {
                        direction = Direction2D.LEFT;
                        break;
                    }
                    case 262: {
                        direction = Direction2D.RIGHT;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                TElement closest = this.findClosestSideElement(this.__focused, direction);
                if (closest == null) {
                    return false;
                }
                this.setFocusedElement(closest, false);
                this.__postTabNavigation();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public TElement findClosestSideElement(TElement target, Direction2D direction) {
        return this.findClosestSideElement(target, direction, DEFAULT_FCSE_PREDICATE);
    }

    @Nullable
    public TElement findClosestSideElement(TElement target, Direction2D direction, Predicate<TElement> predicate) {
        if (target == null || direction == null || target.getParent() == null) {
            return null;
        }
        int x = target.getX() + target.getWidth() / 2;
        int y = target.getY() + target.getHeight() / 2;
        AtomicReference<Object> closest = new AtomicReference<Object>(null);
        AtomicInteger dX = new AtomicInteger(0);
        AtomicInteger dY = new AtomicInteger(0);
        Predicate<TElement> finalPredicate = child -> {
            if (child == target || !predicate.test((TElement)child)) {
                return false;
            }
            int cX = child.getX() + child.getWidth() / 2;
            int cY = child.getY() + child.getHeight() / 2;
            switch (direction) {
                case UP: {
                    if (cY <= y - 1) break;
                    return false;
                }
                case DOWN: {
                    if (cY >= y + 1) break;
                    return false;
                }
                case LEFT: {
                    if (cX <= x - 1) break;
                    return false;
                }
                case RIGHT: {
                    if (cX >= x + 1) break;
                    return false;
                }
                default: {
                    return false;
                }
            }
            if (closest.get() == null) {
                closest.set(child);
                dX.set(Math.abs(cX - x));
                dY.set(Math.abs(cY - y));
                return false;
            }
            if (Math.abs(cX - x) < dX.get() || Math.abs(cY - y) < dY.get()) {
                closest.set(child);
                dX.set(Math.abs(cX - x));
                dY.set(Math.abs(cY - y));
                return false;
            }
            return false;
        };
        target.getParent().findChild(finalPredicate, true);
        if (closest.get() == null) {
            this.findChild(finalPredicate, true);
        }
        return closest.get();
    }
}

