/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import io.github.thecsdev.tcdcommons.api.client.gui.layout.UIListLayout;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TFillColorElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TStackTracePanel;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Axis2D;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.enumerations.VerticalAlignment;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public final class TStackTraceScreen
extends TScreen
implements IParentScreenProvider {
    private final Screen parent;
    private final Throwable throwable;

    public TStackTraceScreen(@Nullable Screen parent, Throwable throwable) throws NullPointerException {
        super((Component)TextUtils.literal(throwable.getClass().getName()));
        this.parent = parent;
        this.throwable = Objects.requireNonNull(throwable);
    }

    @Override
    public final Screen getParentScreen() {
        return this.parent;
    }

    public final Throwable getThrowable() {
        return this.throwable;
    }

    @Override
    public final void close() {
        TCDCommonsClient.MC_CLIENT.setScreen(this.parent);
    }

    @Override
    protected final void init() {
        TFillColorElement contentPane = new TFillColorElement(0, 0, this.getWidth(), this.getHeight());
        contentPane.setColor(0x22FFFFFF);
        contentPane.setZOffset(250.0f);
        this.addChild(contentPane, false);
        int w = (int)((float)this.getWidth() * 0.6f);
        if (w < 300) {
            w = 300;
        }
        if (w > this.getWidth()) {
            w = this.getWidth();
        }
        TStackTracePanel panel_st = new TStackTracePanel(0, 0, w, this.getHeight() - 50, this.throwable);
        panel_st.setCloseAction(() -> this.close());
        contentPane.addChild(panel_st, false);
        new UIListLayout(Axis2D.Y, VerticalAlignment.CENTER, HorizontalAlignment.CENTER).apply(contentPane);
    }
}

