/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserResult;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserScreen;
import io.github.thecsdev.tcdcommons.api.util.enumerations.FileChooserDialogType;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;

public final class TFileChooserBuilder {
    private final ArrayList<TFileFilter> filters = new ArrayList();
    @Nullable
    private Path startingPath;
    @Nullable
    private Screen parent;

    protected TFileChooserBuilder() {
        this.parent = TCDCommonsClient.MC_CLIENT.screen;
    }

    public final TFileChooserBuilder setParentScreen(@Nullable Screen parent) {
        this.parent = parent;
        return this;
    }

    public final TFileChooserBuilder setStartingPath(@Nullable Path startingPath) {
        this.startingPath = startingPath;
        return this;
    }

    public final TFileChooserBuilder addFileFilter(TFileFilter fileFilter) throws NullPointerException {
        this.filters.add(Objects.requireNonNull(fileFilter));
        return this;
    }

    public final void showOpenFileDialog(Consumer<TFileChooserResult> onComplete) {
        this.showOpenFileDialog(null, onComplete);
    }

    public final void showOpenFileDialog(String targetExtension, Consumer<TFileChooserResult> onComplete) {
        this.showDialog(FileChooserDialogType.OPEN_FILE, targetExtension, onComplete);
    }

    public final void showSaveFileDialog(Consumer<TFileChooserResult> onComplete) {
        this.showSaveFileDialog(null, onComplete);
    }

    public final void showSaveFileDialog(String targetExtension, Consumer<TFileChooserResult> onComplete) {
        this.showDialog(FileChooserDialogType.SAVE_FILE, targetExtension, onComplete);
    }

    public final void showSelectDirectoryDialog(Consumer<TFileChooserResult> onComplete) {
        this.showDialog(FileChooserDialogType.SELECT_DIRECTORY, null, onComplete);
    }

    public final void showDialog(FileChooserDialogType dialogType, @Nullable String targetExtension, Consumer<TFileChooserResult> onComplete) {
        if (this.startingPath == null) {
            this.startingPath = Path.of(System.getProperty("user.home"), new String[0]);
        }
        TFileChooserScreen screen = new TFileChooserScreen(Objects.requireNonNull(dialogType), this.startingPath, targetExtension, Objects.requireNonNull(onComplete));
        screen.parent = this.parent;
        if (this.filters.size() > 0) {
            screen.filters.addAll(this.filters);
        }
        TCDCommonsClient.MC_CLIENT.setScreen(screen.getAsScreen());
    }
}

