/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TFillColorElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.TFileExplorerPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenPlus;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.FEPProxy;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserBuilder;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserResult;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.enumerations.FileChooserDialogType;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import io.github.thecsdev.tcdcommons.api.util.io.TExtensionFileFilter;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public final class TFileChooserScreen
extends TScreenPlus
implements IParentScreenProvider {
    protected final FileChooserDialogType type;
    protected final ArrayList<TFileFilter> filters = new ArrayList();
    @Nullable
    protected final String targetExtension;
    protected final Consumer<TFileChooserResult> onComplete;
    private boolean isDone = false;
    protected Path currentPath;
    @Nullable
    protected TFileFilter currentFileFilter;
    @Nullable
    protected File selectedFile;
    protected boolean fullScreen = false;
    protected boolean explorerPanelDraggable;
    private boolean closedUsingClose = false;
    @Nullable
    protected Screen parent;
    protected final TElement contentPane;
    protected final TFileExplorerPanel explorerPanel;

    protected TFileChooserScreen(FileChooserDialogType type, Path startingPath, @Nullable String targetExtension, Consumer<TFileChooserResult> onComplete) throws NullPointerException {
        super((Component)TCDCT.gui_explorer_title());
        this.type = Objects.requireNonNull(type);
        this.onComplete = Objects.requireNonNull(onComplete);
        if (targetExtension != null) {
            TExtensionFileFilter ff = null;
            ff = new TExtensionFileFilter(targetExtension);
            this.addFileFilter(ff);
            targetExtension = ff.getFileExtension();
        }
        this.targetExtension = targetExtension;
        this.currentPath = Objects.requireNonNull(startingPath);
        this.parent = TCDCommonsClient.MC_CLIENT.screen;
        this.contentPane = new TFillColorElement(this, 0, 0, 100, 100, 0x19FFFFFF){

            @Override
            public boolean isHoverable() {
                return true;
            }

            @Override
            public boolean input(TInputContext inputContext) {
                if (!this.isHovered() || inputContext.getInputType() != TInputContext.InputType.MOUSE_PRESS || inputContext.getMouseButton() != 0) {
                    return false;
                }
                TCDCommonsClient.MC_CLIENT.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.NOTE_BLOCK_PLING, (float)2.0f));
                return true;
            }
        };
        this.contentPane.setZOffset(250.0f);
        this.explorerPanel = new TFileExplorerPanel(0, 0, 100, 100, new FEPProxy(this));
        this.contentPane.addChild(this.explorerPanel, false);
    }

    public static TFileChooserBuilder builder() {
        return new TFileChooserBuilder();
    }

    public static void showOpenFileDialog(Consumer<TFileChooserResult> onComplete) {
        TFileChooserScreen.showOpenFileDialog(null, onComplete);
    }

    public static void showOpenFileDialog(@Nullable String targetExtension, Consumer<TFileChooserResult> onComplete) {
        TFileChooserScreen.showDialog(FileChooserDialogType.OPEN_FILE, targetExtension, onComplete);
    }

    public static void showSaveFileDialog(Consumer<TFileChooserResult> onComplete) {
        TFileChooserScreen.showSaveFileDialog(null, onComplete);
    }

    public static void showSaveFileDialog(@Nullable String targetExtension, Consumer<TFileChooserResult> onComplete) {
        TFileChooserScreen.showDialog(FileChooserDialogType.SAVE_FILE, targetExtension, onComplete);
    }

    public static void showSelectDirectoryDialog(Consumer<TFileChooserResult> onComplete) {
        TFileChooserScreen.showDialog(FileChooserDialogType.SELECT_DIRECTORY, null, onComplete);
    }

    protected static void showDialog(FileChooserDialogType type, @Nullable String targetExtension, Consumer<TFileChooserResult> onComplete) {
        TFileChooserScreen.builder().showDialog(type, targetExtension, onComplete);
    }

    @Override
    public final void close() {
        this.closedUsingClose = true;
        TCDCommonsClient.MC_CLIENT.setScreen(this.parent);
    }

    @Override
    public final boolean shouldPause() {
        return true;
    }

    @Override
    public final boolean shouldCloseOnEsc() {
        return true;
    }

    @Override
    public final boolean shouldRenderInGameHud() {
        return false;
    }

    @Override
    public final void renderBackground(TDrawContext pencil) {
        if (this.parent != null) {
            this.parent.render((GuiGraphics)pencil, pencil.mouseX, pencil.mouseY, pencil.deltaTime);
        } else {
            super.renderBackground(pencil);
        }
    }

    @Override
    protected final void onClosed() {
        if (this.isDone) {
            return;
        }
        this.isDone = true;
        TCDCommonsClient.MC_CLIENT.executeIfPossible(() -> {
            if (this.onComplete == null) {
                return;
            }
            final File sel = this.getSelectedFile();
            final TFileChooserResult.ReturnValue ret = this.closedUsingClose ? (sel == null ? TFileChooserResult.ReturnValue.CANCEL_OPTION : TFileChooserResult.ReturnValue.APPROVE_OPTION) : TFileChooserResult.ReturnValue.ERROR_OPTION;
            this.onComplete.accept(new TFileChooserResult(){

                @Override
                @Nullable
                public final File getSelectedFile() {
                    return sel;
                }

                @Override
                public final TFileChooserResult.ReturnValue getReturnValue() {
                    return ret;
                }
            });
        });
    }

    @Override
    @Nullable
    public final Screen getParentScreen() {
        return this.parent;
    }

    public final void setParentScreen(@Nullable Screen parent) {
        this.parent = parent;
    }

    @ApiStatus.Experimental
    protected final void setFileFilter(TFileFilter fileFilter) throws NullPointerException {
        Objects.requireNonNull(fileFilter);
        this.filters.clear();
        this.filters.trimToSize();
        this.filters.add(fileFilter);
        this.currentFileFilter = fileFilter;
    }

    @ApiStatus.Experimental
    protected final void addFileFilter(TFileFilter fileFilter) throws NullPointerException {
        if (this.filters.size() == 0) {
            this.currentFileFilter = fileFilter;
        }
        this.filters.add(Objects.requireNonNull(fileFilter));
    }

    @ApiStatus.Experimental
    @Nullable
    protected final File getSelectedFile() {
        return this.selectedFile;
    }

    public final void refresh() {
        this.clearChildren();
        this.init();
    }

    @Override
    protected final void init() {
        if (this.isDone) {
            return;
        }
        if (this.filters.size() == 0 && this.currentFileFilter == null) {
            this.addFileFilter(TFileFilter.ALL_FILES);
        }
        this.addChild(this.contentPane, false);
        this.contentPane.setPosition(0, 0, false);
        this.contentPane.setSize(this.getWidth(), this.getHeight());
        if (this.fullScreen) {
            this.explorerPanelDraggable = false;
            this.explorerPanel.setPosition(0, 0, true);
            this.explorerPanel.setSize(this.getWidth(), this.getHeight());
        } else {
            int w8 = this.getWidth() / 8;
            int h8 = this.getHeight() / 8;
            int w = this.getWidth() - w8;
            int h = this.getHeight() - h8;
            this.explorerPanelDraggable = true;
            this.explorerPanel.setPosition(w8 / 2, h8 / 2, true);
            this.explorerPanel.setSize(w, h);
        }
        this.explorerPanel.refresh();
    }
}

