/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import com.google.common.annotations.Beta;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.ColorStack;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TextScaleStack;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TCheckboxWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TClickableWidget;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.client.mixin.hooks.AccessorDrawContext;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public final class TDrawContext
extends GuiGraphics {
    @Beta
    public static final int DEFAULT_TEXT_SIDE_OFFSET = 5;
    @Beta
    public static final int DEFAULT_TEXT_COLOR = -1;
    @Beta
    public static final int DEFAULT_ERROR_COLOR = -65281;
    @Beta
    public static final ResourceLocation TEXTURE_FILL = ResourceLocation.fromNamespaceAndPath((String)TCDCommons.getModID(), (String)"textures/gui/fill.png");
    @Beta
    public static final ResourceLocation TEXTURE_ICONS = ResourceLocation.fromNamespaceAndPath((String)TCDCommons.getModID(), (String)"textures/gui/icons.png");
    protected final ColorStack colorStack = new ColorStack();
    protected final TextScaleStack textScaleStack = new TextScaleStack();
    protected final Minecraft client;
    @Nullable
    protected TParentElement currentTarget;
    public final int mouseX;
    public final int mouseY;
    public final float deltaTime;
    protected float textScale = 1.0f;

    protected TDrawContext(GuiGraphics drawContext, int mouseX, int mouseY, float deltaTime) {
        this((AccessorDrawContext)drawContext, mouseX, mouseY, deltaTime);
    }

    private TDrawContext(AccessorDrawContext drawContext, int mouseX, int mouseY, float deltaTime) {
        super(drawContext.getClient(), drawContext.getState());
        AccessorDrawContext mixin_this = (AccessorDrawContext)((Object)this);
        mixin_this.setClient(drawContext.getClient());
        mixin_this.setMatrices(drawContext.getMatrices());
        mixin_this.setState(drawContext.getState());
        this.client = drawContext.getClient();
        this.currentTarget = null;
        this.mouseX = mouseX;
        this.mouseY = mouseY;
        this.deltaTime = deltaTime;
    }

    public static TDrawContext of(GuiGraphics drawContext, int mouseX, int mouseY, float deltaTime) {
        return new TDrawContext(drawContext, mouseX, mouseY, deltaTime);
    }

    public final void updateContext(TParentElement target) {
        this.currentTarget = target;
    }

    public final void fill(RenderPipeline pipeline, int x1, int y1, int x2, int y2, int color) {
        ColorStack.Entry calc = this.colorStack.calculate();
        float a = (float)ARGB.alpha((int)color) / 255.0f * calc.a;
        float r = (float)ARGB.red((int)color) / 255.0f * calc.r;
        float g = (float)ARGB.green((int)color) / 255.0f * calc.g;
        float b = (float)ARGB.blue((int)color) / 255.0f * calc.b;
        color = (int)(a * 255.0f) << 24 | (int)(r * 255.0f) << 16 | (int)(g * 255.0f) << 8 | (int)(b * 255.0f);
        super.fill(pipeline, x1, y1, x2, y2, color);
    }

    public final void pushTShaderColor(float red, float green, float blue, float alpha) {
        this.colorStack.push(red, green, blue, alpha);
        this.applyTShaderColor();
    }

    public final void pushTShaderColor(float red, float green, float blue, float alpha, ColorStack.BlendMethod blendMethod) {
        this.colorStack.push(red, green, blue, alpha, blendMethod);
        this.applyTShaderColor();
    }

    public final void popTShaderColor() {
        this.colorStack.pop();
        this.applyTShaderColor();
    }

    public final void applyTShaderColor() {
        this.colorStack.apply(this);
    }

    public final void setShaderColor(float red, float green, float blue, float alpha) {
    }

    public final void pushTTextScale(float scale) {
        this.textScaleStack.push(scale);
        this.applyTTextScale();
    }

    public final void popTTextScale() {
        this.textScaleStack.pop();
        this.applyTTextScale();
    }

    public final void applyTTextScale() {
        this.textScaleStack.apply(this);
    }

    public final void drawTElementTextTH(Component text, HorizontalAlignment horizontalAlgnment) {
        this.drawTElementTextTHSC(text, horizontalAlgnment, 5, -1);
    }

    public final void drawTElementTextTHC(Component text, HorizontalAlignment horizontalAlgnment, int color) {
        this.drawTElementTextTHSC(text, horizontalAlgnment, 5, color);
    }

    public final void drawTElementTextTHSC(Component text, HorizontalAlignment horizontalAlgnment, int sideOffset, int color) {
        this.drawTElementTextTHSCS(text, horizontalAlgnment, sideOffset, color, 1.0f);
    }

    public final void drawTElementTextTHSS(Component text, HorizontalAlignment horizontalAlgnment, int sideOffset, float textScale) {
        this.drawTElementTextTHSCS(text, horizontalAlgnment, sideOffset, -1, textScale);
    }

    public final void drawTElementTextTHSCS(Component text, HorizontalAlignment horizontalAlgnment, int sideOffset, int color, float textScale) {
        double textX;
        if (text == null || horizontalAlgnment == null) {
            return;
        }
        textScale *= this.textScale;
        Font txtR = this.client.font;
        int textWidth = txtR.width((FormattedText)text);
        int targetCenter = this.currentTarget.getY() + this.currentTarget.getHeight() / 2;
        float f = targetCenter;
        Objects.requireNonNull(txtR);
        double textY = f - 9.0f * textScale / 2.0f;
        switch (horizontalAlgnment) {
            case LEFT: {
                textX = this.currentTarget.getX() + sideOffset;
                break;
            }
            case RIGHT: {
                textX = (float)this.currentTarget.getEndX() - ((float)textWidth * textScale + (float)sideOffset);
                break;
            }
            case CENTER: {
                textX = this.currentTarget.getX() + this.currentTarget.getWidth() / 2;
                textX -= (double)((float)textWidth * textScale / 2.0f);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected " + HorizontalAlignment.class.getSimpleName() + ".");
            }
        }
        this.pose().pushMatrix();
        this.pose().translate((float)textX, (float)textY);
        this.pose().scale(textScale, textScale);
        this.drawString(txtR, text, 0, 0, color, true);
        this.pose().popMatrix();
    }

    public final void drawTBorder(int color) {
        int x = this.currentTarget.getX();
        int y = this.currentTarget.getY();
        int w = this.currentTarget.getWidth();
        int h = this.currentTarget.getHeight();
        this.fillB(x, y, w, 1, color);
        this.fillB(x, y + 1, 1, h - 2, color);
        this.fillB(x + w - 1, y + 1, 1, h - 2, color);
        this.fillB(x, y + h - 1, w, 1, color);
    }

    private final void fillB(int x, int y, int w, int h, int color) {
        this.fill(x, y, x + w, y + h, color);
    }

    public final void drawTFill(int color) {
        this.fill(this.currentTarget.getX(), this.currentTarget.getY(), this.currentTarget.getEndX(), this.currentTarget.getEndY(), color);
    }

    public final void drawTNineSlicedTexture(ResourceLocation textureId, int u, int v, int regionWidth, int regionHeight, int slicedBorderSize) {
        this.drawTNineSlicedTexture(textureId, u, v, regionWidth, regionHeight, 256, 256, slicedBorderSize);
    }

    public final void drawTNineSlicedTexture(ResourceLocation textureId, int u, int v, int uvW, int uvH, int tW, int tH, int s) {
        this.drawTNineSlicedTexture(textureId, this.currentTarget.getX(), this.currentTarget.getY(), this.currentTarget.getWidth(), this.currentTarget.getHeight(), u, v, uvW, uvH, tW, tH, s);
    }

    public final void drawTNineSlicedTexture(ResourceLocation textureId, int x, int y, int w, int h, int u, int v, int uvW, int uvH, int tW, int tH, int s) {
        int s2 = s * 2;
        if (s2 < w || s2 < h) {
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x, y, s, s, u, v, s, s, tW, tH);
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x + w - s, y, s, s, u + uvW - s, v, s, s, tW, tH);
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x, y + h - s, s, s, u, v + uvH - s, s, s, tW, tH);
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x + w - s, y + h - s, s, s, u + uvW - s, v + uvH - s, s, s, tW, tH);
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x + s, y, w - s2, s, u + s, v, uvW - s2, s, tW, tH);
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x, y + s, s, h - s2, u, v + s, s, uvH - s2, tW, tH);
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x + w - s, y + s, s, h - s2, u + uvW - s, v + s, s, uvH - s2, tW, tH);
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x + s, y + h - s, w - s2, s, u + s, v + uvH - s, uvW - s2, s, tW, tH);
            this.drawTRepeatingTexture(textureId, x + s, y + s, w - s2, h - s2, u + s, v + s, uvW - s2, uvH - s2, tW, tH);
        } else {
            this.blit(RenderPipelines.GUI_TEXTURED, textureId, x, y, w, h, u, v, uvW, uvH, tW, tH);
        }
    }

    public final void drawTRepeatingTexture(ResourceLocation textureId, int x, int y, int width, int height, int u, int v, int uvRegionWidth, int uvRegionHeight, int textureWidth, int textureHeight) {
        int endX = x + width;
        int endY = y + height;
        for (int y1 = y; y1 < endY; y1 += uvRegionHeight) {
            for (int x1 = x; x1 < endX; x1 += uvRegionWidth) {
                int nextW = uvRegionWidth;
                int nextH = uvRegionHeight;
                if (x1 + nextW > endX) {
                    nextW -= x1 + nextW - endX;
                }
                if (y1 + nextH > endY) {
                    nextH -= y1 + nextH - endY;
                }
                if (nextW < 1 || nextH < 1) continue;
                this.blit(RenderPipelines.GUI_TEXTURED, textureId, x1, y1, nextW, nextH, u, v, nextW, nextH, textureWidth, textureHeight);
            }
        }
    }

    public final void drawTButton(boolean enabled, boolean focused) {
        TParentElement curr = this.currentTarget;
        this.blitSprite(RenderPipelines.GUI_TEXTURED, TClickableWidget.BUTTON_TEXTURES.get(enabled, focused), curr.getX(), curr.getY(), curr.getWidth(), curr.getHeight());
    }

    public final void drawTCheckbox(int x, int y, boolean highlighted, boolean checked) {
        this.drawTCheckbox(x, y, 20, 20, highlighted, checked);
    }

    public final void drawTCheckbox(int x, int y, int width, int height, boolean highlighted, boolean checked) {
        ResourceLocation tex = checked ? (highlighted ? TCheckboxWidget.SELECTED_HIGHLIGHTED_TEXTURE : TCheckboxWidget.SELECTED_TEXTURE) : (highlighted ? TCheckboxWidget.HIGHLIGHTED_TEXTURE : TCheckboxWidget.TEXTURE);
        this.blitSprite(RenderPipelines.GUI_TEXTURED, tex, x, y, width, height);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Experimental
    public final void drawTEntity(Entity entity, int size, boolean followCursor) throws NullPointerException {
        if (entity == null) {
            return;
        }
        TParentElement c = this.currentTarget;
        this.drawTEntity(entity, c.getX(), c.getY(), c.getWidth(), c.getHeight(), size, followCursor);
    }

    @Deprecated(forRemoval=true)
    @ApiStatus.Experimental
    public final void drawTEntity(Entity entity, int x, int y, int width, int height, int size, boolean followCursor) {
        LivingEntity livingEntity;
        if (entity == null) {
            return;
        }
        float f = 0.0625f;
        int mouseX = followCursor ? this.mouseX : x + width / 2 + 100;
        int mouseY = followCursor ? this.mouseY : y + height / 2 + 50;
        LivingEntity livingEntity2 = livingEntity = entity instanceof LivingEntity ? (LivingEntity)entity : null;
        if (livingEntity != null && TCDCommonsClient.MC_CLIENT.level != null) {
            InventoryScreen.renderEntityInInventoryFollowsMouse((GuiGraphics)this, (int)x, (int)y, (int)(x + width), (int)(y + height), (int)size, (float)0.0625f, (float)mouseX, (float)mouseY, (LivingEntity)livingEntity);
            return;
        }
    }

    @ApiStatus.Internal
    private final void __drawEntity(float x, float y, int size, Vector3f vector3f, Quaternionf quaternionf, @Nullable Quaternionf quaternionf2, Entity entity) {
    }
}

