/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TClickableWidget;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProviderSetter;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TButtonWidget
extends TClickableWidget
implements ITextProviderSetter {
    @Nullable
    protected Component text;
    @Nullable
    protected Consumer<TButtonWidget> onClick;
    @Nullable
    protected UITexture icon;
    protected final float[] iconColor = new float[]{1.0f, 1.0f, 1.0f, 1.0f};

    public TButtonWidget(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public TButtonWidget(int x, int y, int width, int height, Component text) {
        this(x, y, width, height, text, null);
    }

    public TButtonWidget(int x, int y, int width, int height, Component text, Consumer<TButtonWidget> onClick) {
        super(x, y, Math.max(width, 5), Math.max(height, 5));
        this.text = text;
        this.onClick = onClick;
    }

    @Override
    @Nullable
    public final Component getText() {
        return this.text;
    }

    @Override
    @Virtual
    public void setText(@Nullable Component text) {
        this.text = text;
    }

    @Nullable
    public final Consumer<TButtonWidget> getOnClick() {
        return this.onClick;
    }

    @Virtual
    public void setOnClick(@Nullable Consumer<TButtonWidget> onClick) {
        this.onClick = onClick;
    }

    @Nullable
    public final UITexture getIcon() {
        return this.icon;
    }

    @Virtual
    public void setIcon(@Nullable UITexture icon) {
        this.icon = icon;
    }

    public final float[] getIconColor() {
        return this.iconColor;
    }

    public final void setIconColor(float r, float g, float b) {
        this.setIconColor(r, g, b, this.iconColor[3]);
    }

    @Virtual
    public void setIconColor(float r, float g, float b, float a) {
        this.iconColor[0] = r;
        this.iconColor[1] = g;
        this.iconColor[2] = b;
        this.iconColor[3] = a;
    }

    @Override
    @Virtual
    protected void onClick() {
        if (this.onClick == null) {
            return;
        }
        this.onClick.accept(this);
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        this.renderBackground(pencil);
        pencil.enableScissor(this.getX(), this.getY(), this.getEndX(), this.getEndY());
        pencil.drawTElementTextTH(this.text, HorizontalAlignment.CENTER);
        pencil.disableScissor();
    }

    @Virtual
    protected void renderBackground(TDrawContext pencil) {
        pencil.drawTButton(this.enabled, this.isFocusedOrHovered());
        this.renderIcon(pencil);
    }

    @Virtual
    protected void renderIcon(TDrawContext pencil) {
        if (this.icon != null) {
            pencil.pushTShaderColor(this.iconColor[0], this.iconColor[1], this.iconColor[2], this.iconColor[3]);
            this.icon.drawTexture(pencil, this.getX() + 2, this.getY() + 2, this.getWidth() - 4, this.getHeight() - 4);
            pencil.popTShaderColor();
        }
    }
}

