/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.widget.TSelectWidget;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TSelectFileFilterWidget
extends TSelectWidget<FileFilterEntry> {
    public TSelectFileFilterWidget(int x, int y, int width, int height, Iterable<TFileFilter> fileFilters) {
        super(x, y, width, height, (TSelectWidget.Entry[])new FileFilterEntry[0]);
        for (TFileFilter fileFilter : fileFilters) {
            this.addEntry(new FileFilterEntry(fileFilter));
        }
    }

    public final FileFilterEntry entryOf(TFileFilter fileFilter) {
        return this.entries.find(e -> e.getFileFilter() == fileFilter);
    }

    @Override
    public final void setSelected(TFileFilter fileFilter) throws NoSuchElementException {
        FileFilterEntry e = this.entryOf(fileFilter);
        if (e == null && fileFilter != null) {
            throw new NoSuchElementException();
        }
        this.setSelected(e);
    }

    public static final class FileFilterEntry
    implements TSelectWidget.Entry {
        protected final TFileFilter fileFilter;

        public FileFilterEntry(TFileFilter fileFilter) {
            this.fileFilter = Objects.requireNonNull(fileFilter);
        }

        public final TFileFilter getFileFilter() {
            return this.fileFilter;
        }

        @Override
        public final Component getText() {
            return this.fileFilter.getDescription();
        }

        @Override
        @Nullable
        public final Tooltip getTooltip() {
            return null;
        }

        @Override
        @Nullable
        public final Runnable getOnSelect() {
            return null;
        }

        public final int hashCode() {
            return this.fileFilter.hashCode();
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !Objects.equals(obj.getClass(), this.getClass())) {
                return false;
            }
            return Objects.equals(this.fileFilter, ((FileFilterEntry)obj).fileFilter);
        }
    }
}

