/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.widget;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventFactory;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.collections.IdealList;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProviderSetter;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.Objects;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TSelectWidget<T extends Entry>
extends TButtonWidget
implements Iterable<T> {
    public static final Component DEFAULT_LABEL = TCDCT.gui_wSelect_defLabel();
    public static final UITexture TEX_OPENED = new UITexture(T_WIDGETS_TEXTURE, new Rectangle(20, 0, 20, 20));
    public static final UITexture TEX_CLOSED = new UITexture(T_WIDGETS_TEXTURE, new Rectangle(0, 0, 20, 20));
    protected final Class<T> entryType;
    protected final IdealList<T> entries = new IdealList();
    @Nullable
    protected T selected;
    @Nullable
    protected TContextMenuPanel contextMenu;
    protected final TElement.TElementEvent_ContextMenu ehContextMenu = (self, contextMenu) -> {
        this.contextMenu = contextMenu;
    };
    public final TEvent<TSelectWidgetEvent_SelectionChanged<T>> eSelectionChanged = TEventFactory.createLoop(new TSelectWidgetEvent_SelectionChanged[0]);

    @SafeVarargs
    public TSelectWidget(int x, int y, int width, int height, T ... entryTypeClassGetter) {
        this(x, y, width, height, DEFAULT_LABEL, (Entry[])entryTypeClassGetter);
    }

    @SafeVarargs
    public TSelectWidget(int x, int y, int width, int height, Component text, T ... entryTypeClassGetter) {
        super(x, y, Math.max(width, 30), Math.max(height, 15), text);
        this.entryType = entryTypeClassGetter.getClass().getComponentType();
        this.eContextMenu.register(this.ehContextMenu);
    }

    @Override
    @Virtual
    public void tick() {
        if (!this.eContextMenu.isRegistered(this.ehContextMenu)) {
            this.eContextMenu.register(this.ehContextMenu);
        }
    }

    public final Class<T> getEntryType() {
        return this.entryType;
    }

    @Override
    public final Iterator<T> iterator() {
        return this.entries.iterator();
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        pencil.drawTButton(this.enabled, this.isFocusedOrHovered());
        pencil.enableScissor(this.getX(), this.getY(), this.getEndX(), this.getEndY());
        pencil.drawTElementTextTH(this.text, HorizontalAlignment.LEFT);
        pencil.disableScissor();
        boolean isOpen = this.contextMenu != null && this.contextMenu.isOpen() && this.contextMenu.getTarget() == this;
        (isOpen ? TEX_OPENED : TEX_CLOSED).drawTexture(pencil, this.getEndX() - 22, this.getY() + 2, 16, 16);
    }

    @Override
    @Virtual
    protected void onClick() {
        super.onClick();
        this.createContextMenu().open();
    }

    @Override
    @Virtual
    public TContextMenuPanel createContextMenu() {
        TContextMenuPanel menu = new TContextMenuPanel(this);
        for (Entry entry : this.entries) {
            this.contextMenu.addButton(entry.getText(), __ -> this.setSelected(entry)).setTooltip(this.contextMenu.getTooltip());
        }
        return menu;
    }

    public final boolean addEntry(T entry) {
        if (entry == null || this.entries.contains(entry)) {
            return false;
        }
        return this.entries.add(entry);
    }

    public final boolean removeEntry(T entry) {
        return this.entries.remove(entry);
    }

    @Nullable
    public final T getSelected() {
        return this.selected;
    }

    public final void setSelected(@Nullable T selected) throws IllegalArgumentException {
        this.setSelected(selected, true);
    }

    public final void setSelected(@Nullable T selected, boolean invokeEvent) throws IllegalArgumentException {
        if (selected != null && !this.entries.contains(selected)) {
            throw new IllegalArgumentException("Cannot set a non-added entry as 'selected'.");
        }
        this.selected = selected;
        if (selected != null) {
            this.setText(selected.getText());
            Runnable onSel = selected.getOnSelect();
            if (onSel != null) {
                onSel.run();
            }
        } else {
            this.setText(DEFAULT_LABEL);
        }
        this.onSelectionChanged();
        if (invokeEvent) {
            this.eSelectionChanged.invoker().invoke(this, selected);
        }
    }

    @Virtual
    protected void onSelectionChanged() {
    }

    public static interface Entry
    extends ITextProvider {
        @Nullable
        public Tooltip getTooltip();

        @Nullable
        public Runnable getOnSelect();

        default public String getTextAsString() {
            Component txt = this.getText();
            if (txt == null) {
                return null;
            }
            return txt.getString();
        }
    }

    public static interface TSelectWidgetEvent_SelectionChanged<T extends Entry> {
        public void invoke(TSelectWidget<T> var1, T var2);
    }

    public static final class SimpleEntry
    implements Entry,
    ITextProviderSetter {
        @Nullable
        protected Component text;
        @Nullable
        protected Tooltip tooltip;
        @Nullable
        protected Runnable onSelect;

        public SimpleEntry(Component text) {
            this(text, null);
        }

        public SimpleEntry(Component text, Runnable onSelect) {
            this.text = text;
            this.onSelect = onSelect;
        }

        @Override
        public final Component getText() {
            return this.text;
        }

        @Override
        @Virtual
        public void setText(Component text) {
            this.text = text;
        }

        @Override
        public final Tooltip getTooltip() {
            return this.tooltip;
        }

        public final void setTooltip(Component tooltipText) {
            this.setTooltip(Tooltip.create((Component)tooltipText));
        }

        @Virtual
        public void setTooltip(Tooltip tooltip) {
            this.tooltip = tooltip;
        }

        @Override
        public final Runnable getOnSelect() {
            return this.onSelect;
        }

        @Virtual
        public void setOnSelect(Runnable onSelect) {
            this.onSelect = onSelect;
        }

        public final int hashCode() {
            return Objects.hashCode(this.getTextAsString());
        }

        public final boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || !Objects.equals(obj.getClass(), this.getClass())) {
                return false;
            }
            String otherObjText = ((Entry)obj).getTextAsString();
            return Objects.equals(this.getTextAsString(), otherObjText);
        }
    }
}

