/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.cache;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalNotification;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResource;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceManager;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceSerializer;
import io.github.thecsdev.tcdcommons.api.util.math.Tuple2;
import io.github.thecsdev.tcdcommons.api.util.thread.TaskScheduler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.input.CountingInputStream;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
final class CacheFileUtils {
    private static final String FS = System.getProperty("file.separator");
    private static final String CR = System.getProperty("user.home") + String.format("%1$s.cache%1$sthecsdev%1$smc-tcdcommons", FS);
    private static final String META_KEY_EXPIRATION = "expiration_date";
    private static final Cache<ResourceLocation, ReentrantLock> RESOURCE_LOCKS = CacheBuilder.newBuilder().expireAfterAccess(25L, TimeUnit.MINUTES).build();

    CacheFileUtils() {
    }

    static final void resourceCacheRemovalListener(RemovalNotification<ResourceLocation, CachedResource<?>> notification) {
        ResourceLocation key = (ResourceLocation)notification.getKey();
        if (key == null) {
            return;
        }
        switch (notification.getCause()) {
            case EXPIRED: {
                CacheFileUtils.tryDeleteCacheFile(key);
                break;
            }
            default: {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final ReentrantLock getResourceLock(ResourceLocation resourceId) throws NullPointerException {
        Objects.requireNonNull(resourceId);
        Cache<ResourceLocation, ReentrantLock> cache = RESOURCE_LOCKS;
        synchronized (cache) {
            ReentrantLock lock = (ReentrantLock)RESOURCE_LOCKS.getIfPresent((Object)resourceId);
            if (lock == null) {
                lock = new ReentrantLock();
                RESOURCE_LOCKS.put((Object)resourceId, (Object)lock);
            }
            return lock;
        }
    }

    public static final Tuple2<File, File> getCacheFileForResource(ResourceLocation resourceId) throws NullPointerException {
        String fileName = CR + FS + resourceId.getNamespace() + FS + resourceId.getPath();
        return new Tuple2<File, File>(new File(fileName), new File(fileName + ".meta"));
    }

    public static final boolean cacheFileExistsForResource(ResourceLocation resourceId) throws NullPointerException {
        Tuple2<File, File> files = CacheFileUtils.getCacheFileForResource(resourceId);
        try {
            return ((File)files.Item1).exists() && ((File)files.Item2).exists();
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean tryDeleteCacheFile(ResourceLocation resourceId) throws NullPointerException {
        ReentrantLock lock = CacheFileUtils.getResourceLock(resourceId);
        lock.lock();
        try {
            Tuple2<File, File> files = CacheFileUtils.getCacheFileForResource(resourceId);
            try {
                boolean bl = ((File)files.Item1).delete() | ((File)files.Item2).delete();
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                lock.unlock();
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean trySaveCachedResource(ResourceLocation resourceId, CachedResource<?> resource) throws NullPointerException {
        ReentrantLock lock = CacheFileUtils.getResourceLock(resourceId);
        lock.lock();
        try {
            Tuple2<File, File> files = CacheFileUtils.getCacheFileForResource(resourceId);
            Objects.requireNonNull(resource);
            try {
                ((File)files.Item1).delete();
                ((File)files.Item2).delete();
                ((File)files.Item1).getParentFile().mkdirs();
                ((File)files.Item2).getParentFile().mkdirs();
                JsonObject metaJson = new JsonObject();
                metaJson.addProperty(META_KEY_EXPIRATION, resource.getExpirationDate().toString());
                FileUtils.writeStringToFile((File)((File)files.Item2), (String)new Gson().toJson((JsonElement)metaJson), (Charset)StandardCharsets.UTF_16);
                CachedResourceSerializer<?> serializer = Objects.requireNonNull(CachedResourceManager.getResourceSerializer(resource.getResourceType()));
                try (FileOutputStream fos = new FileOutputStream((File)files.Item1);){
                    serializer.serialize(resource.getResource(), fos);
                }
                boolean bl = true;
                return bl;
            }
            catch (Exception e) {
                boolean bl = false;
                lock.unlock();
                return bl;
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static final <R> CachedResource<R> tryLoadCachedResource(ResourceLocation resourceId, Class<R> resourceType) throws NullPointerException {
        ReentrantLock lock = CacheFileUtils.getResourceLock(resourceId);
        lock.lock();
        try {
            Tuple2<File, File> files = CacheFileUtils.getCacheFileForResource(resourceId);
            Objects.requireNonNull(resourceType);
            try {
                CachedResourceSerializer<R> serializer = Objects.requireNonNull(CachedResourceManager.getResourceSerializer(resourceType));
                String metaStr = FileUtils.readFileToString((File)((File)files.Item2), (Charset)StandardCharsets.UTF_16);
                JsonObject metaJson = (JsonObject)new Gson().fromJson(metaStr, JsonObject.class);
                Instant expirationDate = Instant.parse(metaJson.get(META_KEY_EXPIRATION).getAsString());
                if (Instant.now().isAfter(expirationDate)) {
                    throw new DateTimeException("Resource expired.");
                }
                CountingInputStream iStream = new CountingInputStream((InputStream)new FileInputStream((File)files.Item1));
                Object resource = null;
                long resourceSize = 0L;
                try {
                    resource = Objects.requireNonNull(serializer.deserialize((InputStream)iStream));
                    resourceSize = iStream.getByteCount();
                }
                finally {
                    iStream.close();
                }
                if (!Objects.equals(resourceType, resource.getClass())) {
                    throw new ClassCastException("Deserialization returned an illegal type.");
                }
                CachedResource<Object> cachedResource = new CachedResource<Object>(resource, resourceSize, expirationDate);
                return cachedResource;
            }
            catch (Exception e) {
                CacheFileUtils.tryDeleteCacheFile(resourceId);
                CachedResource<R> cachedResource = null;
                lock.unlock();
                return cachedResource;
            }
        }
        finally {
            lock.unlock();
        }
    }

    static final void cleanUpExpiredFiles(@Nullable File directory) {
        block10: {
            if (directory == null || !directory.isDirectory()) {
                directory = new File(CR);
            }
            if (!directory.exists() || !directory.isDirectory()) break block10;
            try {
                for (File file : directory.listFiles()) {
                    boolean pass;
                    File cacheFile;
                    block12: {
                        block11: {
                            if (file.isDirectory()) {
                                CacheFileUtils.cleanUpExpiredFiles(file);
                                continue;
                            }
                            if (!file.getName().endsWith(".meta")) continue;
                            cacheFile = new File(StringUtils.removeEndIgnoreCase((String)file.getAbsolutePath(), (String)".meta"));
                            pass = false;
                            if (file.exists() && cacheFile.exists()) break block11;
                            pass = true;
                            break block12;
                        }
                        if (file.length() <= 3072L) {
                            try {
                                JsonObject metaJson = (JsonObject)new Gson().fromJson(FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_16), JsonObject.class);
                                Instant exp_date = Instant.parse(metaJson.get(META_KEY_EXPIRATION).getAsString());
                                if (exp_date.isBefore(Instant.now())) {
                                }
                            }
                            catch (Exception e) {}
                            break block12;
                            pass = true;
                        }
                    }
                    if (pass) continue;
                    cacheFile.delete();
                    file.delete();
                }
                if (directory.list().length == 0) {
                    directory.delete();
                }
            }
            catch (Exception e) {
                TCDCommons.LOGGER.warn("Failed to clean up cached files;", (Object)e.getClass().getName(), (Object)e.getMessage());
            }
        }
    }

    static {
        TaskScheduler.schedulePeriodicCacheCleanup(RESOURCE_LOCKS);
    }
}

