/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.repo;

import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.io.HttpUtils;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResource;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceManager;
import io.github.thecsdev.tcdcommons.api.util.io.cache.IResourceFetchTask;
import io.github.thecsdev.tcdcommons.api.util.io.repo.RepositoryHostInfo;
import io.github.thecsdev.tcdcommons.api.util.io.repo.RepositoryInfoProvider;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="v3.12", forRemoval=true)
public abstract class RepositoryUserInfo {
    public abstract RepositoryHostInfo getHost();

    public abstract String getID();

    public abstract String getAccountName();

    public abstract String getDisplayName();

    @Nullable
    public abstract String getBiography();

    @Virtual
    @Nullable
    public URI getAvatarImageURI() {
        return null;
    }

    @Virtual
    @Nullable
    public BigInteger getFollowerCount() {
        return null;
    }

    @Virtual
    @Nullable
    public BigInteger getFollowingCount() {
        return null;
    }

    @Virtual
    @Nullable
    public BigInteger getRepositoryCount() {
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.getHost(), this.getID());
    }

    public boolean equals(Object obj) {
        if (obj == null || !Objects.equals(this.getClass(), obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        RepositoryUserInfo cObj = (RepositoryUserInfo)obj;
        return Objects.equals(this.getHost(), cObj.getHost()) && Objects.equals(this.getID(), cObj.getID());
    }

    public final void getAvatarImageAsync(BlockableEventLoop<?> minecraftClientOrServer, Consumer<byte[]> onReady, Consumer<Exception> onError) throws NullPointerException {
        RepositoryInfoProvider.getInfoAsync(minecraftClientOrServer, onReady, onError, this::fetchAvatarImageSync);
    }

    @Virtual
    public byte[] fetchAvatarImageSync() throws NullPointerException, ResourceLocationException, IOException {
        final URI imgUri = Objects.requireNonNull(this.getAvatarImageURI());
        ResourceLocation imgId = ResourceLocation.fromNamespaceAndPath((String)Objects.requireNonNull(this.getHost().getID()), (String)("tcdcommons-user_avatars/" + Objects.requireNonNull(this.getID()) + ".png"));
        final AtomicReference result = new AtomicReference();
        final AtomicReference error = new AtomicReference();
        CachedResourceManager.getResourceSync(imgId, new IResourceFetchTask<byte[]>(){

            @Override
            public Class<byte[]> getResourceType() {
                return byte[].class;
            }

            @Override
            public BlockableEventLoop<?> getMinecraftClientOrServer() {
                return null;
            }

            @Override
            public void onReady(byte[] resource) {
                result.set(resource);
            }

            @Override
            public void onError(Exception exception) {
                error.set(exception);
            }

            @Override
            public CachedResource<byte[]> fetchResourceSync() throws Exception {
                byte[] bytes = HttpUtils.httpGetSyncB(imgUri, new Header[]{new BasicHeader("Accept", "image/png")});
                return CachedResource.ofBytes(bytes, Instant.now().plus(Duration.ofDays(7L)));
            }
        });
        if (error.get() != null) {
            throw error.get() instanceof IOException ? (IOException)error.get() : new IOException("Failed to fetch user's avatar image.", (Throwable)error.get());
        }
        return Objects.requireNonNull((byte[])result.get());
    }
}

