/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.client.mixin.events;

import com.mojang.blaze3d.platform.Window;
import io.github.thecsdev.tcdcommons.api.client.registry.TClientRegistries;
import io.github.thecsdev.tcdcommons.api.events.client.gui.hud.InGameHudEvent;
import io.github.thecsdev.tcdcommons.client.mixin.TCMInternal;
import java.util.Map;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MouseHandler;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Gui.class}, priority=1001)
public abstract class MixinInGameHud {
    @Shadow
    private Minecraft minecraft;

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="HEAD")}, cancellable=true)
    public void onPreRender(GuiGraphics pencil, DeltaTracker tickCounter, CallbackInfo callback) {
        if (TCMInternal.CURRENT_T_SCREEN != null && !TCMInternal.CURRENT_T_SCREEN.shouldRenderInGameHud()) {
            callback.cancel();
        } else if (InGameHudEvent.RENDER_PRE.invoker().invoke(pencil, tickCounter.getGameTimeDeltaPartialTick(false)).isEventCancelled()) {
            callback.cancel();
        }
    }

    @Inject(method={"render(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/DeltaTracker;)V"}, at={@At(value="RETURN")})
    public void onPostRender(GuiGraphics pencil, DeltaTracker tickCounter, CallbackInfo callback) {
        if (TClientRegistries.HUD_SCREEN.size() > 0) {
            Screen currentScreen = this.minecraft.screen;
            Window clientWindow = this.minecraft.getWindow();
            MouseHandler mouse = this.minecraft.mouseHandler;
            double mX = mouse.isMouseGrabbed() ? (double)(clientWindow.getScreenWidth() / 2) : mouse.xpos();
            double mY = mouse.isMouseGrabbed() ? (double)(clientWindow.getScreenHeight() / 2) : mouse.ypos();
            int i = (int)(mX * (double)clientWindow.getGuiScaledWidth() / (double)clientWindow.getScreenWidth());
            int j = (int)(mY * (double)clientWindow.getGuiScaledHeight() / (double)clientWindow.getScreenHeight());
            for (Map.Entry entry : TClientRegistries.HUD_SCREEN) {
                if (entry.getValue() == currentScreen) continue;
                ((Screen)entry.getValue()).render(pencil, i, j, tickCounter.getGameTimeDeltaPartialTick(false));
            }
        }
        InGameHudEvent.RENDER_POST.invoker().invoke(pencil, tickCounter.getGameTimeDeltaPartialTick(false));
    }
}

