/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.client.mixin.events;

import com.mojang.blaze3d.platform.Window;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenWrapper;
import io.github.thecsdev.tcdcommons.api.client.registry.TClientRegistries;
import io.github.thecsdev.tcdcommons.api.events.client.MinecraftClientEvent;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.client.mixin.TCMInternal;
import io.github.thecsdev.tcdcommons.client.mixin.hooks.AccessorTScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Minecraft.class})
public abstract class MixinMinecraftClient {
    @Shadow
    public Window window;
    @Shadow
    public Screen screen;

    @Inject(method={"<init>(Lnet/minecraft/client/main/GameConfig;)V"}, at={@At(value="RETURN")})
    public void onInit(CallbackInfo callback) {
        TCDCommonsClient.MC_CLIENT = (Minecraft)this;
    }

    @Inject(method={"resizeDisplay()V"}, at={@At(value="RETURN")})
    public void onResolutionChanged(CallbackInfo callback) {
        TClientRegistries.reInitHudScreens();
        int sW = this.window.getGuiScaledWidth();
        int sH = this.window.getGuiScaledHeight();
        MinecraftClientEvent.RESOLUTION_CHANGED.invoker().invoke(sW, sH);
    }

    @Inject(method={"setScreen(Lnet/minecraft/client/gui/screens/Screen;)V"}, at={@At(value="RETURN")})
    public void onSetScreen(Screen screen, CallbackInfo callback) {
        if (this.screen != screen) {
            return;
        }
        try {
            if (TCMInternal.CURRENT_T_SCREEN != null && screen != TCMInternal.CURRENT_T_SCREEN.getAsScreen()) {
                AccessorTScreen i = (AccessorTScreen)((Object)TCMInternal.CURRENT_T_SCREEN);
                TCMInternal.CURRENT_T_SCREEN.setFocusedElement(null);
                TCMInternal.CURRENT_T_SCREEN = null;
                i.tcdcommons_onClosed();
                if (this.screen != screen) {
                    return;
                }
            }
            if (screen instanceof TScreenWrapper) {
                TCMInternal.CURRENT_T_SCREEN = ((TScreenWrapper)screen).getTargetTScreen();
                TCMInternal.CURRENT_T_SCREEN.setFocusedElement(null);
                ((AccessorTScreen)((Object)TCMInternal.CURRENT_T_SCREEN)).tcdcommons_onOpened();
            } else {
                TCMInternal.CURRENT_T_SCREEN = null;
            }
        }
        catch (Exception exc) {
            TCMInternal.CURRENT_T_SCREEN = screen instanceof TScreenWrapper ? ((TScreenWrapper)screen).getTargetTScreen() : null;
            String msg = "An '%s' was raised where it shouldn't have been, and '%s' is unable to continue keeping track of '%s's.";
            throw new Error(String.format("An '%s' was raised where it shouldn't have been, and '%s' is unable to continue keeping track of '%s's.", Exception.class.getSimpleName(), TCDCommons.getModName(), TScreen.class.getSimpleName()), exc);
        }
        MinecraftClientEvent.SET_SCREEN_POST.invoker().invoke(screen);
    }

    @Inject(method={"disconnect(Lnet/minecraft/client/gui/screens/Screen;Z)V"}, at={@At(value="RETURN")})
    public void onDisconnect(Screen disconnectionScreen, boolean transferring, CallbackInfo callback) {
        MinecraftClientEvent.DISCONNECTED.invoker().invoke((Minecraft)this);
    }
}

