/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.client.network;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadge;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.client.badge.ClientPlayerBadge;
import io.github.thecsdev.tcdcommons.api.client.network.PlayerBadgeNetworkListener;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.collections.GenericProperties;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class TcdcClientPlayNetworkHandler {
    private static final ResourceLocation CUSTOM_DATA_ID = ResourceLocation.fromNamespaceAndPath((String)TCDCommons.getModID(), (String)"client_play_network_handler");
    private final LocalPlayer player;

    private TcdcClientPlayNetworkHandler(LocalPlayer player) throws NullPointerException {
        this.player = Objects.requireNonNull(player);
    }

    public final LocalPlayer getPlayer() {
        return this.player;
    }

    public final void onPlayerBadges(CustomPayloadNetworkReceiver.PacketContext context) {
        FriendlyByteBuf payload = context.getPacketBuffer();
        PlayerBadgeHandler statHandler = ClientPlayerBadge.getClientPlayerBadgeHandler(this.player);
        int badgeCount = payload.readInt();
        for (int index = 0; index < badgeCount && payload.readableBytes() >= 2; ++index) {
            ResourceLocation badgeId = payload.readResourceLocation();
            int badgeValue = payload.readVarInt();
            @Nullable PlayerBadge badge = TRegistries.PLAYER_BADGE.getValue(badgeId).orElse(null);
            if (badge == null || badge instanceof ClientPlayerBadge) continue;
            statHandler.setValue(badgeId, badgeValue);
        }
        TCDCommonsClient.MC_CLIENT.executeIfPossible(() -> {
            Screen currentScreen = TCDCommonsClient.MC_CLIENT.screen;
            if (currentScreen instanceof PlayerBadgeNetworkListener) {
                PlayerBadgeNetworkListener listener = (PlayerBadgeNetworkListener)currentScreen;
                listener.onPlayerBadgesReady();
            }
        });
    }

    public final void sendCustomPayloadNetwork(ResourceLocation id, ByteBuf buffer) throws IllegalStateException, NullPointerException {
        Objects.requireNonNull(id);
        Objects.requireNonNull(buffer);
        if (buffer.refCnt() < 1) {
            throw new IllegalStateException("REF_CNT");
        }
        CustomPayloadNetwork.sendC2S(id, buffer);
    }

    public static final TcdcClientPlayNetworkHandler of(LocalPlayer player) throws NullPointerException {
        GenericProperties<ResourceLocation> cd = EntityHooks.getCustomData((Entity)Objects.requireNonNull(player));
        @Nullable TcdcClientPlayNetworkHandler cpnh = (TcdcClientPlayNetworkHandler)cd.getProperty(CUSTOM_DATA_ID);
        if (cpnh == null) {
            cpnh = new TcdcClientPlayNetworkHandler(player);
            cd.setProperty(CUSTOM_DATA_ID, cpnh);
        }
        return cpnh;
    }
}

