/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.mixin.events;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.events.entity.EntityEvent;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerPlayer.class})
public abstract class MixinServerPlayerEntity {
    @Inject(method={"readAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueInput;)V"}, at={@At(value="RETURN")})
    public void onReadCustomData(ValueInput view, CallbackInfo callback) {
        ServerPlayer self = (ServerPlayer)this;
        try {
            EntityEvent.SERVER_PLAYER_READ_NBT.invoker().invoke(self, view);
        }
        catch (Exception throwable) {
            String modId = TCDCommons.getModID();
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)("[" + modId + "] Loading player custom NBT"));
            CrashReportCategory crashReportSection = crashReport.addCategory("Entity being loaded");
            self.fillCrashReportCategory(crashReportSection);
            throw new ReportedException(crashReport);
        }
    }

    @Inject(method={"addAdditionalSaveData(Lnet/minecraft/world/level/storage/ValueOutput;)V"}, at={@At(value="RETURN")})
    public void onWriteCustomDataToNbt(ValueOutput view, CallbackInfo callback) {
        ServerPlayer self = (ServerPlayer)this;
        try {
            EntityEvent.SERVER_PLAYER_WRITE_NBT.invoker().invoke(self, view);
        }
        catch (Exception throwable) {
            String modId = TCDCommons.getModID();
            CrashReport crashReport = CrashReport.forThrowable((Throwable)throwable, (String)("[" + modId + "] Saving player custom NBT"));
            CrashReportCategory crashReportSection = crashReport.addCategory("Entity being saved");
            self.fillCrashReportCategory(crashReportSection);
            throw new ReportedException(crashReport);
        }
    }
}

