/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.neo.api.util.io.mod;

import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfo;
import java.util.NoSuchElementException;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.fml.loading.FMLLoader;
import org.jetbrains.annotations.Nullable;

public final class NeoForgeModInfo
extends ModInfo {
    private final net.neoforged.fml.loading.moddiscovery.ModInfo modContainer = FMLLoader.getCurrent().getLoadingModList().getMods().stream().filter(it -> it.getModId().equals(modId)).findFirst().orElseThrow();
    private final String modVersion = this.modContainer.getVersion().toString();
    private final Component modName = Component.literal((String)this.modContainer.getDisplayName());
    private final Component modDescription = Component.literal((String)this.modContainer.getDescription());
    private final Component[] authors = new Component[0];
    @Nullable
    private final ResourceLocation modIconId;
    @Nullable
    private final String modHomePageUrl;
    @Nullable
    private final String modSourcesUrl;

    public NeoForgeModInfo(String modId) throws NullPointerException, NoSuchElementException {
        super(modId);
        this.modIconId = ResourceLocation.fromNamespaceAndPath((String)modId, (String)this.modContainer.getLogoFile().orElse("assets/icon.png"));
        this.modSourcesUrl = this.modHomePageUrl = this.modContainer.getUpdateURL().map(url -> Objects.toString(url)).orElse("");
    }

    @Override
    public final String getVersion() {
        return this.modVersion;
    }

    @Override
    public final Component getName() {
        return this.modName;
    }

    @Override
    public final Component getDescription() {
        return this.modDescription;
    }

    @Override
    public final Component[] getAuthors() {
        return this.authors;
    }

    @Override
    @Nullable
    public final ResourceLocation getIconId() {
        return this.modIconId;
    }

    @Override
    @Nullable
    public final String getHomePageURL() {
        return this.modHomePageUrl;
    }

    @Override
    @Nullable
    public final String getSourcesURL() {
        return this.modSourcesUrl;
    }
}

