/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.badge;

import io.github.thecsdev.tcdcommons.TCDCommons;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterable;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.resources.ResourceLocation;

public class PlayerBadgeHandler
implements ObjectIterable<Object2IntMap.Entry<ResourceLocation>> {
    public static final ResourceLocation PBH_CUSTOM_DATA_ID = ResourceLocation.fromNamespaceAndPath((String)TCDCommons.getModID(), (String)"player_badges");
    protected final Object2IntMap<ResourceLocation> statMap = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public PlayerBadgeHandler() {
        this.statMap.defaultReturnValue(0);
    }

    public final ObjectIterator<Object2IntMap.Entry<ResourceLocation>> iterator() {
        return this.statMap.object2IntEntrySet().iterator();
    }

    public final int getValue(ResourceLocation badgeId) {
        return this.statMap.getInt((Object)badgeId);
    }

    public void setValue(ResourceLocation badgeId, int value) throws NullPointerException {
        if (value < 1) {
            this.statMap.removeInt((Object)badgeId);
        } else {
            this.statMap.put((Object)Objects.requireNonNull(badgeId), value);
        }
    }

    public final void increaseValue(ResourceLocation badgeId, int by) {
        int i = (int)Math.min((long)this.getValue(badgeId) + (long)by, Integer.MAX_VALUE);
        this.setValue(badgeId, i);
    }

    public final void clearBadges() {
        HashSet keys = new HashSet(this.statMap.keySet());
        for (ResourceLocation key : keys) {
            this.setValue(key, 0);
        }
        this.statMap.clear();
    }

    public static final Map<String, List<ResourceLocation>> toMapByModId(Iterable<ResourceLocation> badgeIDs) {
        return StreamSupport.stream(badgeIDs.spliterator(), false).collect(Collectors.groupingBy(ResourceLocation::getNamespace, HashMap::new, Collectors.toList()));
    }
}

