/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.badge;

import com.google.common.collect.Lists;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.TCDCommonsConfig;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadge;
import io.github.thecsdev.tcdcommons.api.badge.PlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.hooks.entity.EntityHooks;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetwork;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.mixin.hooks.AccessorServerPlayer;
import io.github.thecsdev.tcdcommons.network.TCDCommonsNetwork;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayerBadgeHandler
extends PlayerBadgeHandler {
    private static final TCDCommonsConfig CONFIG = Objects.requireNonNull(TCDCommons.getInstance().getConfig());
    protected final ServerPlayer player;
    protected final Object2IntMap<ResourceLocation> pendingStatMap = Object2IntMaps.synchronize((Object2IntMap)new Object2IntOpenHashMap());

    public ServerPlayerBadgeHandler(ServerPlayer player) {
        this.player = Objects.requireNonNull(player);
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    @Override
    public final void setValue(ResourceLocation badgeId, int value) throws NullPointerException {
        int oldValue = this.statMap.getInt((Object)badgeId);
        super.setValue(badgeId, value);
        this.pendingStatMap.put((Object)badgeId, value);
        if (value > oldValue) {
            ServerPlayerBadgeHandler.announceEarnedBadge(this.player, badgeId);
        }
    }

    protected final Object2IntMap<ResourceLocation> takePendingStats() {
        Object2IntOpenHashMap copy = new Object2IntOpenHashMap(this.pendingStatMap);
        this.pendingStatMap.clear();
        return copy;
    }

    public final void loadFromPlayerNbt(CompoundTag nbt) {
        block5: {
            CompoundTag nbt_modId;
            block4: {
                String[] badgeList;
                String modId = TCDCommons.getModID();
                if (!nbt.contains(modId)) {
                    return;
                }
                nbt_modId = nbt.getCompound(modId).orElse(new CompoundTag());
                if (!nbt_modId.contains("player_badges")) break block4;
                String badgeListStr = nbt_modId.getString("player_badges").orElse("").trim();
                if (StringUtils.isBlank((CharSequence)badgeListStr)) {
                    return;
                }
                for (String badgeItem : badgeList = badgeListStr.split("\\R")) {
                    if (StringUtils.isBlank((CharSequence)badgeItem)) continue;
                    this.increaseValue(ResourceLocation.parse((String)badgeItem), 1);
                }
                break block5;
            }
            if (!nbt_modId.contains("player_badges")) break block5;
            CompoundTag badgeList = nbt_modId.getCompound("player_badges").orElse(new CompoundTag());
            for (String badgeIdStr : badgeList.keySet()) {
                if (!badgeList.contains(badgeIdStr)) continue;
                this.setValue(ResourceLocation.parse((String)badgeIdStr), badgeList.getInt(badgeIdStr).orElse(0));
            }
        }
    }

    public final CompoundTag saveToPlayerNbt(CompoundTag nbt) {
        CompoundTag nbt_modId;
        if (this.statMap.isEmpty()) {
            return nbt;
        }
        String modId = TCDCommons.getModID();
        if (!nbt.contains(modId)) {
            nbt.put(modId, (Tag)new CompoundTag());
        }
        if (!(nbt_modId = nbt.getCompound(modId).orElse(new CompoundTag())).contains("player_badges")) {
            nbt_modId.put("player_badges", (Tag)new CompoundTag());
        }
        CompoundTag badgeList = nbt_modId.getCompound("player_badges").orElse(new CompoundTag());
        ObjectIterator<Object2IntMap.Entry<ResourceLocation>> objectIterator = this.iterator();
        while (objectIterator.hasNext()) {
            Object2IntMap.Entry badgeEntry = (Object2IntMap.Entry)objectIterator.next();
            badgeList.putInt(Objects.toString(badgeEntry.getKey()), badgeEntry.getIntValue());
        }
        return nbt;
    }

    public final boolean sendStats(ServerPlayer player) {
        if (!TCDCommons.getInstance().getConfig().enablePlayerBadges) {
            return false;
        }
        ArrayList badges = Lists.newArrayList((Iterator)this.takePendingStats().object2IntEntrySet().iterator());
        if (badges.size() == 0) {
            return false;
        }
        int chunkSize = 15;
        List badgePartitions = Lists.partition((List)badges, (int)15);
        for (List badgePartition : badgePartitions) {
            ServerPlayerBadgeHandler.sendStats(player, badgePartition);
        }
        return true;
    }

    private static void sendStats(ServerPlayer player, Collection<Object2IntMap.Entry<ResourceLocation>> badgeChunk) {
        FriendlyByteBuf data = new FriendlyByteBuf(Unpooled.buffer());
        data.writeInt(badgeChunk.size());
        for (Object2IntMap.Entry<ResourceLocation> badgeEntry : badgeChunk) {
            if (badgeEntry.getKey() == null) continue;
            data.writeResourceLocation((ResourceLocation)badgeEntry.getKey());
            data.writeVarInt(badgeEntry.getIntValue());
        }
        try {
            CustomPayloadNetwork.sendS2C(player, TCDCommonsNetwork.S2C_PLAYER_BADGES, (ByteBuf)data);
        }
        catch (Exception e) {
            TCDCommons.LOGGER.debug("Failed to send " + String.valueOf(TCDCommonsNetwork.S2C_PLAYER_BADGES) + " packet; " + e.getMessage());
            throw e;
        }
    }

    public static ServerPlayerBadgeHandler getServerBadgeHandler(ServerPlayer player) {
        ServerPlayerBadgeHandler pbh = (ServerPlayerBadgeHandler)EntityHooks.getCustomDataEntryG((Entity)player, PlayerBadgeHandler.PBH_CUSTOM_DATA_ID);
        if (pbh == null) {
            pbh = EntityHooks.setCustomDataEntryG((Entity)player, PlayerBadgeHandler.PBH_CUSTOM_DATA_ID, new ServerPlayerBadgeHandler(player));
        }
        return pbh;
    }

    public static boolean announceEarnedBadge(ServerPlayer player, ResourceLocation badgeId) {
        if (!ServerPlayerBadgeHandler.CONFIG.enablePlayerBadges || !ServerPlayerBadgeHandler.CONFIG.broadcastEarningPlayerBadges) {
            return false;
        }
        PlayerBadge badge = TRegistries.PLAYER_BADGE.getValue(badgeId).orElse(null);
        MutableComponent badgeName = badge != null ? TextUtils.literal("").append(badge.getName()) : TextUtils.literal(Objects.toString(badgeId));
        badgeName = ServerPlayerBadgeHandler.__formatBadgeName(badgeName, badgeId, badge);
        MutableComponent message = TCDCT.cmd_pb_chatGrant(player.getName(), (Component)badgeName);
        ((AccessorServerPlayer)player).getServer().getPlayerList().broadcastSystemMessage((Component)message, false);
        return true;
    }

    private static final MutableComponent __formatBadgeName(MutableComponent badgeName, @Nullable ResourceLocation badgeId, @Nullable PlayerBadge badge) {
        MutableComponent root = TextUtils.literal("");
        root.append((Component)TextUtils.literal("[")).withStyle(ChatFormatting.YELLOW);
        root.append((Component)badgeName).withStyle(ChatFormatting.YELLOW);
        root.append((Component)TextUtils.literal("]")).withStyle(ChatFormatting.YELLOW);
        MutableComponent hover = TextUtils.literal("");
        hover.append((Component)(badge != null ? badge.getName() : TextUtils.literal(Objects.toString(badgeId)).withStyle(ChatFormatting.YELLOW)));
        hover.append("\n");
        hover.append((Component)TextUtils.literal(Objects.toString(badgeId)).withStyle(ChatFormatting.GRAY));
        if (badge != null) {
            hover.append("\n\n");
            hover.append(badge.getDescription());
        }
        HoverEvent.ShowText hoverEvent = new HoverEvent.ShowText((Component)hover);
        root.setStyle(root.getStyle().withHoverEvent((HoverEvent)hoverEvent));
        return root;
    }
}

