/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui;

import io.github.thecsdev.tcdcommons.api.client.gui.TElementList;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.menu.TContextMenuPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.GuiUtils;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.ITooltipProvider;
import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventFactory;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.interfaces.ITextProvider;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public abstract class TElement
implements TParentElement,
ITooltipProvider {
    public static final int SP_RELATIVE = 1;
    public static final int SP_MOVE_CHILDREN = 2;
    public static final int SP_UPDATE_TOPMOST = 4;
    public static final int SP_INVOKE_EVENT = 8;
    public static final int SP_ALL = 15;
    public static final int SS_UPDATE_TOPMOST = 4;
    public static final int SS_INVOKE_EVENT = 8;
    public static final int SS_ALL = 15;
    @ApiStatus.Internal
    @Nullable
    TParentElement __parent;
    @ApiStatus.Internal
    @Nullable
    private TElement __parentElement;
    @ApiStatus.Internal
    @Nullable
    private TScreen __parentScreen;
    private final TElementList children = new TElementList(this);
    protected int x = 0;
    protected int y = 0;
    protected int width = 20;
    protected int height = 20;
    protected float alpha = 1.0f;
    protected float zOffset = 0.0f;
    @Nullable
    protected Tooltip tooltip;
    @Nullable
    protected ClientTooltipPositioner tooltipPositioner;
    public final TEvent<TElementEvent_Moved> eMoved = TEventFactory.createLoop(new TElementEvent_Moved[0]);
    public final TEvent<TElementEvent_Resized> eResized = TEventFactory.createLoop(new TElementEvent_Resized[0]);
    public final TEvent<TElementEvent_ChildAR> eChildAdded = TEventFactory.createLoop(new TElementEvent_ChildAR[0]);
    public final TEvent<TElementEvent_ChildAR> eChildRemoved = TEventFactory.createLoop(new TElementEvent_ChildAR[0]);
    public final TEvent<TElementEvent_ParentChanged> eParentChanged = TEventFactory.createLoop(new TElementEvent_ParentChanged[0]);
    public final TEvent<TElementEvent_ContextMenu> eContextMenu = TEventFactory.createLoop(new TElementEvent_ContextMenu[0]);

    public TElement(int x, int y, int width, int height) {
        this.x = x;
        this.y = y;
        this.width = Math.abs(width);
        this.height = Math.abs(height);
        this.alpha = 1.0f;
        this.zOffset = 0.0f;
        this.tooltip = null;
        this.tooltipPositioner = null;
    }

    @ApiStatus.Internal
    void __updateParent(TParentElement parent) {
        this.__parent = parent;
        if (parent instanceof TElement) {
            TElement parentElement;
            this.__parentElement = parentElement = (TElement)parent;
            this.__parentScreen = parentElement.__parentScreen;
        } else if (parent instanceof TScreen) {
            this.__parentElement = null;
            this.__parentScreen = (TScreen)parent;
        } else {
            this.__parentElement = null;
            this.__parentScreen = null;
        }
    }

    @Override
    public final TElementList getChildren() {
        return this.children;
    }

    @Override
    @Nullable
    public final TParentElement getParent() {
        return this.__parent;
    }

    @Nullable
    public final TElement getParentTElement() {
        return this.__parentElement;
    }

    @Nullable
    public final TScreen getParentTScreen() {
        return this.__parentScreen;
    }

    @Override
    public final int getX() {
        return this.x;
    }

    @Override
    public final int getY() {
        return this.y;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    public final void move(int deltaX, int deltaY) {
        this.setPosition(this.x + deltaX, this.y + deltaY, false);
    }

    public final void moveChildren(int dX, int dY) {
        this.forEachChild(child -> {
            child.x += dX;
            child.y += dY;
        }, true);
    }

    public final void setPosition(int x, int y, boolean relativeToParent) {
        int flags = 15;
        if (!relativeToParent) {
            flags &= 0xFFFFFFFE;
        }
        this.setPosition(x, y, flags);
    }

    @Virtual
    public void setPosition(int x, int y, int flags) {
        if ((flags & 1) == 1 && this.__parent != null) {
            x += this.__parent.getX();
            y += this.__parent.getY();
        }
        if (this.x == x && this.y == y) {
            return;
        }
        int dX = x - this.x;
        int dY = y - this.y;
        this.x = x;
        this.y = y;
        if ((flags & 2) == 2) {
            this.moveChildren(dX, dY);
        }
        if ((flags & 4) == 4 && this.__parent != null) {
            this.__parent.getChildren().updateTopmostChildren();
        }
        if ((flags & 8) == 8) {
            this.eMoved.invoker().invoke(this, dX, dY);
        }
    }

    public final void setSize(int width, int height) {
        this.setSize(width, height, 15);
    }

    @Virtual
    public void setSize(int width, int height, int flags) {
        if (this.width == width && this.height == height) {
            return;
        }
        int oldWidth = this.width;
        int oldHeight = this.height;
        this.width = width;
        this.height = height;
        if ((flags & 4) == 4 && this.__parent != null) {
            this.__parent.getChildren().updateTopmostChildren();
        }
        if ((flags & 8) == 8) {
            this.eResized.invoker().invoke(this, oldWidth, oldHeight);
        }
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(float alpha) {
        this.alpha = Math.max(0.0f, Math.min(1.0f, alpha));
    }

    public final boolean isVisible() {
        return this.alpha > 0.05f && (this.getParentTElement() == null || this.getParentTElement().isVisible());
    }

    public final boolean isEnabledAndVisible() {
        return this.isVisible() && this.isEnabled();
    }

    public final Font getTextRenderer() {
        if (this.__parentScreen != null) {
            return this.__parentScreen.getTextRenderer();
        }
        return TCDCommonsClient.MC_CLIENT.font;
    }

    public final ItemRenderer getItemRenderer() {
        if (this.__parentScreen != null) {
            return this.__parentScreen.getItemRenderer();
        }
        return TCDCommonsClient.MC_CLIENT.getItemRenderer();
    }

    @Override
    public final float getZIndex() {
        return (this.__parent != null ? this.__parent.getZIndex() : 0.0f) + this.getZOffset();
    }

    public final float getZOffset() {
        return this.zOffset;
    }

    @Virtual
    public void setZOffset(float zOffset) {
        this.zOffset = zOffset;
    }

    @Override
    public final boolean isEnabled() {
        return TParentElement.super.isEnabled();
    }

    @Override
    @Virtual
    public boolean getEnabled() {
        return true;
    }

    @Virtual
    public boolean isFocusable() {
        return false;
    }

    @Virtual
    public boolean isHoverable() {
        return true;
    }

    public final boolean isHovered() {
        return this.__parentScreen != null && this.__parentScreen.getHoveredElement() == this;
    }

    public final boolean isFocused() {
        return this.__parentScreen != null && this.__parentScreen.getFocusedElement() == this;
    }

    public final boolean isDragging() {
        return this.__parentScreen != null && this.__parentScreen.getDraggingElement() == this;
    }

    public final boolean isFocusedOrHovered() {
        return this.isFocused() || this.isHovered();
    }

    @Virtual
    @Nullable
    public TContextMenuPanel createContextMenu() {
        TContextMenuPanel menu = new TContextMenuPanel(this);
        return menu.getChildren().size() > 0 ? menu : null;
    }

    @Virtual
    public void tick() {
    }

    @Override
    public abstract void render(TDrawContext var1);

    @Virtual
    public void postRender(TDrawContext pencil) {
    }

    @Override
    @Virtual
    public boolean input(TInputContext inputContext) {
        return false;
    }

    @Override
    @Nullable
    public final Tooltip getTooltip() {
        return this.tooltip;
    }

    @Virtual
    public void setTooltip(@Nullable Tooltip tooltip) {
        this.tooltip = tooltip;
    }

    public final ClientTooltipPositioner getTooltipPositioner() {
        return this.tooltipPositioner != null ? this.tooltipPositioner : (this.tooltipPositioner = GuiUtils.createDefaultTooltipPositioner(this));
    }

    @Nullable
    public final TElement previous() {
        TParentElement start = this.getParentTScreen();
        if (start == null) {
            start = this.getParent();
        }
        if (start == null) {
            return null;
        }
        AtomicReference<Object> flag = new AtomicReference<Object>(null);
        start.findChild(child -> {
            if (child == this) {
                return true;
            }
            flag.set(child);
            return false;
        }, true);
        return flag.get();
    }

    @Nullable
    public final TElement next() {
        if (this.children.size() > 0) {
            return this.children.iterator().next();
        }
        TParentElement start = this.getParentTScreen();
        if (start == null) {
            start = this.getParent();
        }
        if (start == null) {
            return null;
        }
        AtomicBoolean flag = new AtomicBoolean(false);
        return start.findChild(child -> {
            if (child == this) {
                flag.set(true);
                return false;
            }
            return flag.get();
        }, true);
    }

    @Virtual
    public String toString() {
        String base = super.toString() + String.format("[%d, %d, %d, %d", this.x, this.y, this.width, this.height);
        if (this instanceof ITextProvider) {
            ITextProvider itp = (ITextProvider)((Object)this);
            Component txt = itp.getText();
            String textString = txt != null ? txt.getString() : "";
            return base + ", \"" + textString + "\"]";
        }
        return base + "]";
    }

    @Virtual
    public boolean canBeAddedTo(TParentElement futureParent) {
        return futureParent != null;
    }

    public static interface TElementEvent_Moved {
        public void invoke(TElement var1, int var2, int var3);
    }

    public static interface TElementEvent_Resized {
        public void invoke(TElement var1, int var2, int var3);
    }

    public static interface TElementEvent_ChildAR {
        public void invoke(TElement var1, TElement var2, boolean var3);
    }

    public static interface TElementEvent_ParentChanged {
        public void invoke(TElement var1, @Nullable TParentElement var2, @Nullable TParentElement var3);
    }

    public static interface TElementEvent_ContextMenu {
        public void invoke(TElement var1, TContextMenuPanel var2);
    }
}

