/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.config;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TCheckboxWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.collections.HookedMap;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.Rectangle;
import java.util.Map;
import java.util.Objects;
import java.util.WeakHashMap;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

@Virtual
public class TConfigPanelBuilder<T extends TConfigPanelBuilder<T>> {
    public static final Component TEXT_SAVE = TextUtils.translatable("selectWorld.edit.save", new Object[0]);
    public static final Component TEXT_CANCEL = TextUtils.translatable("gui.cancel", new Object[0]);
    protected final Map<TElement, Consumer<?>> applyActions = HookedMap.of(new WeakHashMap(), map -> map.entrySet().removeIf(entry -> {
        TElement key = (TElement)entry.getKey();
        return key == null || key.getParent() != this.getTargetPanel();
    }));
    @Nullable
    protected Runnable onSave;
    protected final TPanelElement targetPanel;
    @Nullable
    protected TElement lastAddedElement;

    protected TConfigPanelBuilder(TPanelElement target) throws NullPointerException {
        this.targetPanel = Objects.requireNonNull(target);
    }

    protected final T self() {
        return (T)this;
    }

    @Virtual
    public static TConfigPanelBuilder<?> builder(TPanelElement target) {
        return new TConfigPanelBuilder(target);
    }

    public final T build(@Nullable Runnable onSave) {
        this.setOnSave(onSave);
        return this.self();
    }

    public final TPanelElement getTargetPanel() {
        return this.targetPanel;
    }

    @Nullable
    public final TElement getLastAddedElement() {
        return this.lastAddedElement;
    }

    public final void setOnSave(@Nullable Runnable onSave) {
        this.onSave = onSave;
    }

    public final void saveChanges() {
        for (Map.Entry<TElement, Consumer<?>> entry : this.applyActions.entrySet()) {
            entry.getValue().accept(entry.getKey());
        }
        if (this.onSave != null) {
            this.onSave.run();
        }
    }

    @Virtual
    protected int vMargin() {
        return this.lastAddedElement != null ? 5 : 0;
    }

    public final T addLabel(Component text) {
        this.addLabelB(text);
        return this.self();
    }

    @Virtual
    public TLabelElement addLabelB(Component text) {
        Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect(this.targetPanel);
        TLabelElement lbl = new TLabelElement(n1.x, n1.y + this.vMargin(), n1.width, n1.height, text);
        this.targetPanel.addChild(lbl, false);
        this.lastAddedElement = lbl;
        return lbl;
    }

    public final T addCheckbox(Component text, boolean value, Consumer<TCheckboxWidget> applyValue) {
        this.addCheckboxB(text, value, applyValue);
        return this.self();
    }

    @Virtual
    public TCheckboxWidget addCheckboxB(Component text, boolean value, Consumer<TCheckboxWidget> applyValue) {
        Rectangle n1 = TConfigPanelBuilder.nextPanelVerticalRect(this.targetPanel);
        TCheckboxWidget box = new TCheckboxWidget(n1.x, n1.y + this.vMargin(), n1.width, n1.height, text, value);
        box.setHorizontalAlignment(HorizontalAlignment.LEFT, HorizontalAlignment.RIGHT);
        this.targetPanel.addChild(box, false);
        this.lastAddedElement = box;
        this.applyActions.put(box, applyValue);
        return box;
    }

    @Deprecated(since="3.9.8")
    public static final int nextPanelBottomY(TPanelElement panel) {
        TElement bottom = (TElement)panel.getChildren().getTopmostElements().Item2;
        return bottom != null ? bottom.getEndY() : panel.getY() + panel.getScrollPadding();
    }

    @Deprecated(since="3.9.8")
    public static final Rectangle nextPanelVerticalRect(TPanelElement panel) {
        int sp = panel.getScrollPadding();
        return new Rectangle(panel.getX() + sp, TConfigPanelBuilder.nextPanelBottomY(panel), panel.getWidth() - sp * 2, 20);
    }
}

