/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.other;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Direction2D;

@Virtual
public class TProgressBarElement
extends TElement {
    protected float progress = 0.0f;
    protected Direction2D direction = Direction2D.LEFT;

    public TProgressBarElement(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public final float getProgress() {
        return this.progress;
    }

    public final void setProgress(float progress) {
        this.progress = progress = Math.max(0.0f, Math.min(1.0f, progress));
    }

    public final Direction2D getDirection() {
        return this.direction;
    }

    public final void setDirection(Direction2D direction) {
        this.direction = direction != null ? direction : Direction2D.RIGHT;
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        pencil.drawTFill(-12303292);
        this.renderProgress(pencil);
    }

    @Override
    @Virtual
    public void postRender(TDrawContext pencil) {
        pencil.drawTBorder(0x50FFFFFF);
    }

    protected final void renderProgress(TDrawContext pencil) {
        switch (this.direction) {
            case LEFT: 
            case RIGHT: {
                int w = (int)((float)this.getWidth() * this.progress);
                int x = this.direction == Direction2D.LEFT ? this.getX() : this.getEndX() - w;
                this.renderProgress(pencil, x, this.getY(), w, this.getHeight());
                break;
            }
            case UP: 
            case DOWN: {
                int h = (int)((float)this.getHeight() * this.progress);
                int y = this.direction == Direction2D.UP ? this.getY() : this.getEndY() - h;
                this.renderProgress(pencil, this.getX(), y, this.getWidth(), h);
                break;
            }
            default: {
                return;
            }
        }
    }

    @Virtual
    protected void renderProgress(TDrawContext pencil, int x, int y, int width, int height) {
        pencil.fill(x, y, x + width, y + height, -10132123);
    }
}

