/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UIListLayout;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TTextureElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TRefreshablePanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.util.input.MouseDragHelper;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TScrollBarWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Axis2D;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.enumerations.VerticalAlignment;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.jetbrains.annotations.Nullable;

public final class TStackTracePanel
extends TRefreshablePanelElement {
    @Nullable
    private String title = null;
    @Nullable
    private String description = null;
    @Nullable
    private Throwable throwable = null;
    @Nullable
    private Runnable closeAction = null;
    private final MouseDragHelper dragHelper = MouseDragHelper.forTElement(this);

    public TStackTracePanel(int x, int y, int width, int height) {
        this(x, y, width, height, null);
    }

    public TStackTracePanel(int x, int y, int width, int height, Throwable throwable) throws NullPointerException {
        super(x, y, Math.max(width, 100), Math.max(height, 100));
        this.setScrollFlags(0);
        this.setScrollPadding(0);
        this.setBackgroundColor(-7697782);
        this.setOutlineColor(-16777216);
        this.throwable = throwable;
        this.closeAction = () -> {
            TParentElement p = this.getParent();
            if (p != null) {
                p.removeChild(this);
            }
        };
    }

    public final void setTitle(@Nullable String title) {
        this.title = title;
        this.refresh();
    }

    public final void setDescription(@Nullable String description) {
        this.description = description;
        this.refresh();
    }

    public final void setThrowable(@Nullable Throwable throwable) {
        this.throwable = throwable;
        this.refresh();
    }

    public final void setCloseAction(@Nullable Runnable closeAction) {
        this.closeAction = closeAction;
    }

    @Nullable
    public final String getTitle() {
        return this.title;
    }

    @Nullable
    public final String getDescription() {
        return this.description;
    }

    @Nullable
    public final Throwable getThrowable() {
        return this.throwable;
    }

    @Nullable
    public final Runnable getCloseAction() {
        return this.closeAction;
    }

    @Override
    public final void render(TDrawContext pencil) {
        for (int i = 10; i > 1; --i) {
            pencil.fill(this.getX() - i, this.getY() - i, this.getEndX() + i, this.getEndY() + i, 0x11000000);
        }
        super.render(pencil);
    }

    @Override
    protected final void init() {
        Throwable throwable = this.throwable != null ? this.throwable : new NullPointerException("No Throwable was provided for this panel.");
        String title = this.title != null ? this.title : TextUtils.translatable("mco.errorMessage.generic", new Object[0]).getString();
        String description = this.description != null ? this.description : throwable.getLocalizedMessage();
        int n = this.getWidth();
        Objects.requireNonNull(this.getTextRenderer());
        TPanelElement panel_title = new TPanelElement(0, 0, n, 9 + 14){

            @Override
            public final boolean input(TInputContext inputContext) {
                switch (inputContext.getInputType()) {
                    case MOUSE_PRESS: {
                        return true;
                    }
                    case MOUSE_DRAG: {
                        return TStackTracePanel.this.dragHelper.onMouseDrag(inputContext.getMouseDelta());
                    }
                    case MOUSE_DRAG_END: {
                        MouseDragHelper.snapToParentBounds(TStackTracePanel.this);
                        return true;
                    }
                }
                return false;
            }
        };
        panel_title.setScrollFlags(0);
        panel_title.setScrollPadding(0);
        panel_title.setBackgroundColor(-11842741);
        panel_title.setOutlineColor(-16777216);
        this.addChild(panel_title);
        TTextureElement ico = new TTextureElement(5, 5, panel_title.getHeight() - 10, panel_title.getHeight() - 10);
        ico.setTexture(new UITexture(ResourceLocation.fromNamespaceAndPath((String)TCDCommons.getModID(), (String)"textures/gui/icons.png"), new Rectangle(192, 0, 64, 64)));
        ico.setTextureColor(1.0f, 1.0f, 0.0f);
        panel_title.addChild(ico);
        TLabelElement lbl = new TLabelElement(panel_title.getHeight() + 5, 0, panel_title.getWidth(), panel_title.getHeight());
        lbl.setTextHorizontalAlignment(HorizontalAlignment.LEFT);
        lbl.setTextColor(-1);
        lbl.setTextScale(0.85f);
        lbl.setText((Component)TextUtils.literal(title).withStyle(ChatFormatting.BOLD));
        panel_title.addChild(lbl);
        TButtonWidget btn_close = new TButtonWidget(this, panel_title.getWidth() - panel_title.getHeight(), 0, panel_title.getHeight(), panel_title.getHeight(), (Component)TextUtils.literal("X")){

            @Override
            protected final void renderBackground(TDrawContext pencil) {
            }

            @Override
            public final void postRender(TDrawContext pencil) {
                pencil.drawTBorder(-16777216);
            }
        };
        btn_close.setOnClick(__ -> {
            if (this.closeAction != null) {
                this.closeAction.run();
            }
        });
        panel_title.addChild(btn_close);
        int sp = 10;
        TPanelElement panel_content = new TPanelElement(0, panel_title.getHeight(), this.getWidth(), this.getHeight() - panel_title.getHeight());
        panel_content.setScrollPadding(10);
        panel_content.setScrollFlags(0);
        panel_content.setBackgroundColor(0);
        panel_content.setOutlineColor(0);
        this.addChild(panel_content);
        TPanelElement panel_d = new TPanelElement(10, 10, panel_content.getWidth() - 20, 50);
        panel_d.setScrollFlags(6);
        panel_d.setScrollPadding(0);
        panel_d.setBackgroundColor(0);
        panel_d.setOutlineColor(0);
        panel_d.setTooltip(Tooltip.create((Component)TCDCT.gui_panel_scrollTip()));
        panel_content.addChild(panel_d);
        Component[] pd_lines = (Component[])Arrays.stream(description.split("\\r?\\n")).map(s -> TextUtils.literal(s)).toArray(Component[]::new);
        UILayout.initLines(panel_d, 0xCFCFCF, pd_lines);
        TPanelElement panel_t = new TPanelElement(10, 10 + panel_d.getHeight() + 5, panel_d.getWidth(), panel_content.getHeight() - 20 - panel_d.getHeight() - 5 - 25);
        panel_t.setScrollFlags(0);
        panel_t.setScrollPadding(0);
        panel_t.setBackgroundColor(-11842741);
        panel_t.setOutlineColor(-16777216);
        panel_content.addChild(panel_t);
        TPanelElement panel_st = new TPanelElement(0, 0, panel_t.getWidth() - 8, panel_t.getHeight() - 8);
        panel_st.setScrollFlags(6);
        panel_st.setScrollPadding(7);
        panel_st.setBackgroundColor(0);
        panel_st.setOutlineColor(-16777216);
        panel_t.addChild(panel_st);
        Arrays.stream(ExceptionUtils.getStackTrace((Throwable)throwable).split("\\r?\\n")).forEach(stackTraceElement -> {
            int color = stackTraceElement.startsWith("\t") ? -5594216 : -4144232;
            stackTraceElement = stackTraceElement.replaceAll("\t", "    ");
            Component[] s_lines = (Component[])Arrays.stream(stackTraceElement.split("\\r?\\n")).map(sLine -> TextUtils.literal(sLine)).toArray(Component[]::new);
            UILayout.initLines(panel_st, color, s_lines);
        });
        StpSbw scroll_h = new StpSbw(panel_st.getX(), panel_st.getEndY(), panel_st.getWidth(), 8, panel_st, false);
        panel_t.addChild(scroll_h, false);
        StpSbw scroll_v = new StpSbw(panel_st.getEndX(), panel_st.getY(), 8, panel_st.getHeight(), panel_st, false);
        panel_t.addChild(scroll_v, false);
        TPanelElement panel_a = new TPanelElement(panel_t.getX(), panel_t.getEndY(), panel_t.getWidth(), 25);
        panel_a.setScrollFlags(0);
        panel_a.setScrollPadding(0);
        panel_a.setBackgroundColor(0);
        panel_a.setOutlineColor(0);
        panel_content.addChild(panel_a, false);
        TButtonWidget btn_copyTrace = new TButtonWidget(0, 0, 20, 20);
        btn_copyTrace.setTooltip(Tooltip.create((Component)TextUtils.translatable("chat.copy", new Object[0])));
        panel_a.addChild(btn_copyTrace, false);
        TTextureElement bct_ico = new TTextureElement(3, 3, 14, 14);
        bct_ico.setTexture(new UITexture(ResourceLocation.fromNamespaceAndPath((String)TCDCommons.getModID(), (String)"textures/gui/icons.png"), new Rectangle(0, 64, 64, 64)));
        bct_ico.setTextureColor(0.8f, 0.8f, 0.8f);
        btn_copyTrace.addChild(bct_ico);
        TButtonWidget btn_okay = new TButtonWidget(0, 0, Math.min(125, panel_a.getWidth() - 25), 20);
        btn_okay.setText((Component)TextUtils.translatable("gui.ok", new Object[0]));
        btn_okay.setOnClick(__ -> {
            if (this.closeAction != null) {
                this.closeAction.run();
            }
        });
        panel_a.addChild(btn_okay, false);
        new UIListLayout(Axis2D.X, VerticalAlignment.BOTTOM, HorizontalAlignment.RIGHT, 5).apply(panel_a);
    }

    private static final class StpSbw
    extends TScrollBarWidget {
        static final int COLOR = -10066330;

        public StpSbw(int x, int y, int width, int height, TPanelElement target) {
            super(x, y, width, height, target);
        }

        public StpSbw(int x, int y, int width, int height, TPanelElement target, boolean autoSetScrollFlags) {
            super(x, y, width, height, target, autoSetScrollFlags);
        }

        @Override
        public final void renderSliderProgressBar(TDrawContext pencil) {
        }

        @Override
        public final void postRender(TDrawContext pencil) {
            pencil.drawTBorder(-10066330);
        }

        @Override
        public final void renderSliderKnob(TDrawContext pencil, int knobX, int knobY, int knobWidth, int knobHeight) {
            pencil.fill(knobX, knobY, knobX + knobWidth, knobY + knobHeight, -10066330);
        }

        @Override
        public final void render(TDrawContext pencil) {
            this.renderSliderProgressBar(pencil);
            this.renderSliderKnob(pencil);
            pencil.drawTElementTextTH(this.text, HorizontalAlignment.CENTER);
        }
    }
}

