/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl;

import io.github.thecsdev.tcdcommons.api.client.gui.panel.TRefreshablePanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.ActionBar;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.FileListPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.NavigationBar;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.SidebarPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.TitleBar;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.ActionBarProxyImpl;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.FileListPanelProxyImpl;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.NavigationBarProxyImpl;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.SidebarPanelProxyImpl;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.impl.TitleBarProxyImpl;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.item.FileListItem;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.explorer.TFileChooserResult;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.util.input.MouseDragHelper;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TScrollBarWidget;
import io.github.thecsdev.tcdcommons.api.util.enumerations.FileChooserDialogType;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import io.github.thecsdev.tcdcommons.api.util.io.TExtensionFileFilter;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;

public final class TFileExplorerPanel
extends TRefreshablePanelElement {
    public static final float TEXT_SCALE = 0.8f;
    public static final Component TXT_ACTION_SAVE = TCDCT.gui_explorer_actionBar_saveFile();
    public static final Component TXT_ACTION_OPEN = TCDCT.gui_explorer_actionBar_openFile();
    protected final FileExplorerPanelProxy proxy;
    protected final FileChooserDialogType type;
    protected final String extension;
    protected boolean userMadeAChoice = false;
    @Nullable
    protected TitleBar titleBar;
    @Nullable
    protected NavigationBar navigationBar;
    @Nullable
    protected ActionBar actionBar;
    @Nullable
    protected SidebarPanel sidebarPanel;
    @Nullable
    protected FileListPanel fileListPanel;
    protected final MouseDragHelper dragHelper;

    public TFileExplorerPanel(int x, int y, int width, int height, FileExplorerPanelProxy proxy) {
        super(x, y, Math.max(width, 150), Math.max(height, 150));
        this.scrollPadding = 0;
        this.scrollFlags = 0;
        this.outlineColor = -8355712;
        this.proxy = Objects.requireNonNull(proxy);
        this.type = proxy.getDialogType();
        this.extension = TExtensionFileFilter.sanitizeExtension(proxy.getTargetFileExtension());
        this.dragHelper = MouseDragHelper.forTElement(this);
    }

    public final FileExplorerPanelProxy getProxy() {
        return this.proxy;
    }

    protected final boolean TRefreshablePanelElement_super_input(TInputContext inputContext) {
        return super.input(inputContext);
    }

    @Override
    public final boolean input(TInputContext inputContext) {
        switch (inputContext.getInputType()) {
            case MOUSE_PRESS: {
                return this.proxy.canDrag();
            }
            case MOUSE_DRAG: {
                if (!this.proxy.canDrag()) break;
                return this.dragHelper.onMouseDrag(inputContext.getMouseDelta());
            }
            case MOUSE_DRAG_END: {
                MouseDragHelper.snapToParentBounds(this);
                return true;
            }
        }
        return false;
    }

    @Override
    public final void render(TDrawContext pencil) {
        pencil.pushTTextScale(0.8f);
        super.render(pencil);
    }

    @Override
    public final void postRender(TDrawContext pencil) {
        super.postRender(pencil);
        pencil.popTTextScale();
    }

    protected final void completeAsError() {
        this.complete(TFileChooserResult.ReturnValue.ERROR_OPTION, null);
    }

    protected final void completeAsCancelled() {
        this.complete(TFileChooserResult.ReturnValue.CANCEL_OPTION, null);
    }

    protected final void completeAsApprove(File selectedFile) {
        this.complete(TFileChooserResult.ReturnValue.APPROVE_OPTION, selectedFile);
    }

    protected final void complete(final TFileChooserResult.ReturnValue returnValue, final File selectedFile) {
        this.complete(new TFileChooserResult(){

            @Override
            public final TFileChooserResult.ReturnValue getReturnValue() {
                return returnValue;
            }

            @Override
            @Nullable
            public final File getSelectedFile() {
                return selectedFile;
            }
        });
    }

    protected final void complete(TFileChooserResult result) {
        if (this.getParent() != null) {
            this.getParent().removeChild(this);
        }
        if (this.userMadeAChoice) {
            return;
        }
        this.userMadeAChoice = true;
        this.proxy.onComplete(result);
    }

    @Override
    public final void init() {
        if (this.userMadeAChoice) {
            return;
        }
        this.titleBar = new TitleBar(this.getX(), this.getY(), this.getWidth(), new TitleBarProxyImpl(this));
        this.navigationBar = new NavigationBar(this.getX(), this.titleBar.getEndY(), this.getWidth(), new NavigationBarProxyImpl(this));
        this.actionBar = new ActionBar(this.getX(), this.getEndY() - 65, this.getWidth(), new ActionBarProxyImpl(this));
        int panelY = this.navigationBar.getEndY();
        int panelH = this.actionBar.getY() - panelY;
        int sidePanelW = this.getWidth() / 3;
        int listPanelW = this.getWidth() - sidePanelW;
        this.sidebarPanel = new SidebarPanel(this.getX(), panelY, sidePanelW - 10, panelH, new SidebarPanelProxyImpl(this));
        this.fileListPanel = new FileListPanel(this.getX() + sidePanelW, panelY, listPanelW - 10, panelH, new FileListPanelProxyImpl(this));
        this.addChild(this.titleBar, false);
        this.addChild(this.navigationBar, false);
        this.addChild(this.actionBar, false);
        this.addChild(this.sidebarPanel, false);
        this.addChild(this.fileListPanel, false);
        this.addChild(new TScrollBarWidget(this.sidebarPanel.getEndX(), this.sidebarPanel.getY(), 10, this.sidebarPanel.getHeight(), this.sidebarPanel), false);
        this.addChild(new TScrollBarWidget(this.fileListPanel.getEndX(), this.fileListPanel.getY(), 10, this.fileListPanel.getHeight(), this.fileListPanel), false);
    }

    public static interface FileExplorerPanelProxy
    extends TitleBar.TitleBarProxy {
        public FileChooserDialogType getDialogType();

        public void onComplete(TFileChooserResult var1);

        public Iterable<TFileFilter> getFileFilters();

        public TFileFilter getSelectedFileFilter();

        public void setSelectedFileFilter(TFileFilter var1);

        public Path getCurrentDirectory();

        public void setCurrentDirectory(Path var1);

        @Nullable
        public String getTargetFileExtension();

        default public boolean canDrag() {
            return false;
        }

        @Override
        default public Component getTitle() {
            return this.getDialogType().getDialogTitle();
        }

        @Override
        default public UITexture getIcon() {
            return FileListItem.TEX_DIR;
        }

        @Override
        default public boolean canClose() {
            return true;
        }

        @Override
        default public boolean canRestore() {
            return true;
        }

        @Override
        default public boolean canMinimize() {
            return false;
        }
    }
}

