/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.item;

import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import java.awt.Rectangle;
import java.io.File;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Virtual
@ApiStatus.Experimental
public class FileListItem
extends TButtonWidget {
    public static final int HEIGHT = 15;
    public static final UITexture TEX_DIR_ALT = new UITexture(T_WIDGETS_TEXTURE, new Rectangle(0, 20, 20, 20));
    public static final UITexture TEX_DIR = new UITexture(T_WIDGETS_TEXTURE, new Rectangle(20, 20, 20, 20));
    public static final UITexture TEX_FILE = new UITexture(T_WIDGETS_TEXTURE, new Rectangle(40, 20, 20, 20));
    public static final UITexture TEX_FILE_TXT = new UITexture(T_WIDGETS_TEXTURE, new Rectangle(60, 20, 20, 20));
    public static final UITexture TEX_FILE_IMG = new UITexture(T_WIDGETS_TEXTURE, new Rectangle(80, 20, 20, 20));
    @Nullable
    protected File file;
    @Nullable
    protected Component fileSizeName;
    protected boolean fileHidden;
    protected final int fileNameSideOffset = this.getHeight() + 5;

    public FileListItem(int x, int y, int width, File file) {
        super(x, y, width, 15);
        this.setFile(file);
    }

    @Nullable
    public final File getFile() {
        return this.file;
    }

    public final void setFile(@Nullable File file) {
        this.setFile(file, file == null ? null : (file.getParent() == null ? file.getAbsolutePath() : file.getName()));
    }

    public final void setFile(@Nullable File file, String fileNameLabel) {
        if (fileNameLabel == null) {
            fileNameLabel = "";
        }
        this.file = file;
        this.text = TextUtils.literal(fileNameLabel);
        MutableComponent fsn = null;
        UITexture icon = null;
        try {
            if (file != null) {
                if (!file.isDirectory()) {
                    fsn = TextUtils.literal(FileUtils.byteCountToDisplaySize((long)file.length()));
                }
                icon = file.isDirectory() ? TEX_DIR : (fileNameLabel.endsWith(".txt") ? TEX_FILE_TXT : (fileNameLabel.endsWith(".png") || fileNameLabel.endsWith(".jpg") ? TEX_FILE_IMG : TEX_FILE));
                this.fileHidden = file.isHidden();
            }
        }
        catch (SecurityException se) {
            this.fileHidden = true;
        }
        this.icon = icon;
        this.fileSizeName = fsn;
    }

    @Override
    public final void setIcon(@Nullable UITexture icon) {
        this.icon = icon;
    }

    @Override
    @Virtual
    public void render(TDrawContext pencil) {
        if (this.icon != null) {
            if (!this.fileHidden) {
                this.renderBackground(pencil);
            } else {
                pencil.pushTShaderColor(0.6f, 0.6f, 0.6f, 1.0f);
                this.renderBackground(pencil);
                pencil.popTShaderColor();
            }
        }
        pencil.drawTElementTextTHSC(this.text, HorizontalAlignment.LEFT, this.fileNameSideOffset, -1);
        pencil.drawTElementTextTH(this.fileSizeName, HorizontalAlignment.RIGHT);
    }

    @Override
    @Virtual
    protected void renderBackground(TDrawContext pencil) {
        if (this.icon != null) {
            this.icon.drawTexture(pencil, this.getX(), this.getY(), 15, 15);
        }
    }

    @Override
    @Virtual
    public void postRender(TDrawContext pencil) {
        if (this.isFocused()) {
            pencil.drawTBorder(-5570561);
        } else if (this.isHovered()) {
            pencil.drawTBorder(0x50FFFFFF);
        }
    }
}

