/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import io.github.thecsdev.tcdcommons.api.client.gui.layout.UILayout;
import io.github.thecsdev.tcdcommons.api.client.gui.layout.UIListLayout;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TBlankElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TFillColorElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.TPanelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TButtonWidget;
import io.github.thecsdev.tcdcommons.api.client.gui.widget.TScrollBarWidget;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.enumerations.Axis2D;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.enumerations.VerticalAlignment;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.awt.Rectangle;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.Nullable;

public final class TDialogBoxScreen
extends TScreen
implements IParentScreenProvider {
    @Nullable
    private Screen parent;
    @Nullable
    private Component message;

    public TDialogBoxScreen(@Nullable Screen parent, Component title, Component message) throws NullPointerException {
        super(Objects.requireNonNull(title));
        this.parent = parent;
        this.message = Objects.requireNonNull(message);
    }

    @Override
    public final Screen getParentScreen() {
        return this.parent;
    }

    @Override
    public final void close() {
        TCDCommonsClient.MC_CLIENT.setScreen(this.parent);
    }

    @Override
    public final void renderBackground(TDrawContext pencil) {
        if (this.parent != null) {
            this.parent.render((GuiGraphics)pencil, pencil.mouseX, pencil.mouseY, pencil.deltaTime);
        } else {
            super.renderBackground(pencil);
        }
    }

    @Nullable
    public final Component getMessage() {
        return this.message;
    }

    @Override
    protected final void init() {
        Component msg = this.message != null ? this.message : TextUtils.literal("null");
        TFillColorElement contentPane = new TFillColorElement(0, 0, this.getWidth(), this.getHeight());
        contentPane.setColor(0x22FFFFFF);
        contentPane.setZOffset(250.0f);
        this.addChild(contentPane, false);
        TPanelElement panel = new TPanelElement(0, 0, this.getWidth() / 2, (int)((float)this.getHeight() / 1.5f));
        panel.setScrollFlags(0);
        panel.setScrollPadding(0);
        panel.setBackgroundColor(-11184811);
        panel.setOutlineColor(-16777216);
        contentPane.addChild(panel, false);
        TPanelElement panel_title = new TPanelElement(0, 0, panel.getWidth(), 30);
        panel_title.setScrollFlags(0);
        panel_title.setScrollPadding(0);
        panel_title.setOutlineColor(-16777216);
        panel.addChild(panel_title);
        TLabelElement lbl_title = new TLabelElement(0, 0, panel_title.getWidth(), panel_title.getHeight());
        lbl_title.setText(this.getTitle());
        lbl_title.setTextSideOffset(10);
        panel_title.addChild(lbl_title);
        TPanelElement panel_footer = new TPanelElement(0, panel.getHeight() - 30, panel.getWidth(), 30);
        panel_footer.setScrollFlags(0);
        panel_footer.setScrollPadding(0);
        panel_footer.setOutlineColor(-16777216);
        panel.addChild(panel_footer);
        TButtonWidget btn_done = new TButtonWidget(panel_footer.getWidth() - 65, 5, 60, 20);
        btn_done.setText((Component)TextUtils.translatable("gui.done", new Object[0]));
        btn_done.setOnClick(__ -> this.close());
        panel_footer.addChild(btn_done);
        TPanelElement panel_message = new TPanelElement(0, panel_title.getHeight(), panel.getWidth() - 8, panel.getHeight() - (panel_title.getHeight() + panel_footer.getHeight()));
        panel_message.setScrollFlags(4);
        panel_message.setScrollPadding(10);
        panel_message.setBackgroundColor(0);
        panel_message.setOutlineColor(0);
        panel.addChild(panel_message);
        final Font tr = this.getTextRenderer();
        Objects.requireNonNull(this.getTextRenderer());
        int fh = 9;
        List msg_lines = tr.split((FormattedText)msg, panel_message.getWidth() - panel_message.getScrollPadding() * 2);
        for (final FormattedCharSequence line : msg_lines) {
            Rectangle n1 = UILayout.nextChildVerticalRect(panel_message);
            TBlankElement lbl = new TBlankElement(this, n1.x, n1.y + 2, n1.width, fh){

                @Override
                public final void render(TDrawContext pencil) {
                    pencil.drawString(tr, line, this.getX(), this.getY(), -855638017, true);
                }
            };
            panel_message.addChild(lbl, false);
        }
        TScrollBarWidget scroll_panelMessage = new TScrollBarWidget(panel_message.getEndX(), panel_message.getY(), 8, panel_message.getHeight(), panel_message, false);
        panel.addChild(scroll_panelMessage, false);
        new UIListLayout(Axis2D.Y, VerticalAlignment.CENTER, HorizontalAlignment.CENTER).apply(contentPane);
    }
}

