/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.screen;

import com.mojang.blaze3d.platform.Window;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TInputContext;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.input.CharacterEvent;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2ic;

@Virtual
public class TScreenWrapper<T extends TScreen>
extends Screen {
    protected final T target;
    @Nullable
    protected Window clientWindow;
    @Nullable
    private PositionedTooltip tooltip;

    public TScreenWrapper(T target) {
        super(((TScreen)target).getTitle());
        this.target = target;
    }

    public final T getTargetTScreen() {
        return this.target;
    }

    public final void Screen_super_close() {
        super.onClose();
    }

    public final Component getTitle() {
        return ((TScreen)this.target).getTitle();
    }

    public final boolean isPauseScreen() {
        return ((TScreen)this.target).shouldPause();
    }

    public final boolean shouldCloseOnEsc() {
        return false;
    }

    public final void onClose() {
        ((TScreen)this.target).close();
    }

    protected final void init() {
        ((TScreen)this.target).getChildren().clear();
        ((TScreen)this.target).client = this.minecraft;
        this.clientWindow = this.minecraft.getWindow();
        ((TScreen)this.target).init();
        super.init();
    }

    protected final void clearWidgets() {
        super.clearWidgets();
        ((TScreen)this.target).getChildren().clear();
    }

    public final void tick() {
        super.tick();
        int i = (int)(this.minecraft.mouseHandler.xpos() * (double)this.clientWindow.getGuiScaledWidth() / (double)this.clientWindow.getScreenWidth());
        int j = (int)(this.minecraft.mouseHandler.ypos() * (double)this.clientWindow.getGuiScaledHeight() / (double)this.clientWindow.getScreenHeight());
        ((TScreen)this.target).setMousePosition(i, j);
        ((TScreen)this.target).__recalculateHoveredChild(i, j);
        ((TScreen)this.target).tick();
        this.target.forEachChild(c -> c.tick(), true);
    }

    public void setTooltip(Tooltip tooltip, ClientTooltipPositioner positioner, boolean focused) {
        this.setTooltip(tooltip.toCharSequence(this.minecraft), positioner, focused);
    }

    public final void setTooltip(Component tooltip) {
        this.setTooltip(Tooltip.splitTooltip((Minecraft)this.minecraft, (Component)tooltip));
    }

    public void setTooltip(List<FormattedCharSequence> tooltip) {
        this.setTooltip(tooltip, DefaultTooltipPositioner.INSTANCE, true);
    }

    public void setTooltip(List<FormattedCharSequence> tooltip, ClientTooltipPositioner positioner, boolean focused) {
        if (this.tooltip == null || focused) {
            this.tooltip = new PositionedTooltip(tooltip, positioner);
        }
    }

    public void clearTooltip() {
        this.tooltip = null;
    }

    public final void Screen_super_renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
        super.renderBackground(context, mouseX, mouseY, delta);
    }

    public final void renderBackground(GuiGraphics context, int mouseX, int mouseY, float delta) {
    }

    public final void renderPanorama(GuiGraphics context, float delta) {
        super.renderPanorama(context, delta);
    }

    public final void renderBlurredBackground(GuiGraphics context) {
        super.renderBlurredBackground(context);
    }

    public final void renderMenuBackground(GuiGraphics context) {
        super.renderMenuBackground(context);
    }

    public final void render(GuiGraphics drawContext, int mouseX, int mouseY, float deltaTime) {
        T t = this.target;
        if (((TScreen)t).__dragging != null && ((TScreen)t).__dragging.getParentTScreen() != t) {
            ((TScreen)t).__dragging = null;
        } else if (((TScreen)t).__focused != null && ((TScreen)t).__focused.getParentTScreen() != t) {
            ((TScreen)t).__focused = null;
        } else if (((TScreen)t).__hovered != null && ((TScreen)t).__hovered.getParentTScreen() != t) {
            ((TScreen)t).__hovered = null;
        }
        TDrawContext pencil = TDrawContext.of(drawContext, mouseX, mouseY, deltaTime);
        pencil.updateContext((TParentElement)this.getTargetTScreen());
        ((TScreen)t).render(pencil);
        this.renderTooltip(pencil);
        this.clearTooltip();
        super.render((GuiGraphics)pencil, mouseX, mouseY, deltaTime);
    }

    private final void renderTooltip(TDrawContext pencil) {
        if (this.tooltip == null) {
            return;
        }
        PositionedTooltip tooltip = this.tooltip;
        Objects.requireNonNull(this.font);
        int lineH = 9 + 1;
        int width = tooltip.getWidth(this.font);
        int height = tooltip.text.size() * lineH + 8 - 1;
        Vector2ic pos = tooltip.positioner.positionTooltip(this.width, this.height, pencil.mouseX, pencil.mouseY, width, height);
        pencil.fill(pos.x(), pos.y(), pos.x() + width, pos.y() + height, -13759899);
        pencil.fill(pos.x() + 1, pos.y() + 1, pos.x() + width - 1, pos.y() + height - 1, -16777216);
        int txtX = pos.x() + 4;
        int txtY = pos.y() + 4;
        for (FormattedCharSequence line : tooltip.text) {
            pencil.drawString(this.font, line, txtX, txtY, -1, true);
            txtY += lineH;
        }
    }

    public final boolean keyPressed(KeyEvent keyEvent) {
        return this.__onTKeyPR(keyEvent, true);
    }

    public final boolean keyReleased(KeyEvent keyEvent) {
        return this.__onTKeyPR(keyEvent, false);
    }

    private final boolean __onTKeyPR(KeyEvent e, boolean isDown) {
        if (isDown ? super.keyPressed(e) : super.keyReleased(e)) {
            return true;
        }
        if (this.input(TInputContext.ofKeyboardPR(new TInputContext.InputKeyboardKey(e.key(), e.scancode(), e.modifiers()), isDown))) {
            return true;
        }
        if (e.key() == 256 && isDown && ((TScreen)this.target).shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        return false;
    }

    public final boolean charTyped(CharacterEvent e) {
        if (super.charTyped(e)) {
            return true;
        }
        return this.input(TInputContext.ofCharType((char)e.codepoint(), e.modifiers()));
    }

    public final boolean mouseClicked(MouseButtonEvent e, boolean doubled) {
        return this.__onTMouseCR(e, true);
    }

    public final boolean mouseReleased(MouseButtonEvent e) {
        return this.__onTMouseCR(e, false);
    }

    private final boolean __onTMouseCR(MouseButtonEvent e, boolean isDown) {
        if (isDown ? super.mouseClicked(e, false) : super.mouseReleased(e)) {
            return true;
        }
        return this.input(TInputContext.ofMouseCR(e.button(), isDown));
    }

    public final void mouseMoved(double mouseX, double mouseY) {
        ((TScreen)this.target).setMousePosition((int)mouseX, (int)mouseY);
        this.input(TInputContext.ofMouseMove(mouseX, mouseY));
        super.mouseMoved(mouseX, mouseY);
    }

    public final boolean mouseDragged(MouseButtonEvent e, double deltaX, double deltaY) {
        if (super.mouseDragged(e, deltaX, deltaY)) {
            return true;
        }
        return this.input(TInputContext.ofMouseDrag(e.x(), e.y(), deltaX, deltaY, ((TScreen)this.target).__draggingButton));
    }

    public final boolean mouseScrolled(double mouseX, double mouseY, double hAmount, double vAmount) {
        if (super.mouseScrolled(mouseX, mouseY, hAmount, vAmount)) {
            return true;
        }
        return this.input(TInputContext.ofMouseScroll(mouseX, mouseY, hAmount, vAmount));
    }

    protected final boolean input(TInputContext inputContext) {
        this.target.input(inputContext, TInputContext.InputDiscoveryPhase.BROADCAST);
        this.target.forEachChild(c -> c.input(inputContext, TInputContext.InputDiscoveryPhase.BROADCAST), true);
        if (this.target.input(inputContext, TInputContext.InputDiscoveryPhase.PREEMPT) || this.target.findChild(c -> c.input(inputContext, TInputContext.InputDiscoveryPhase.PREEMPT), true) != null) {
            return true;
        }
        switch (inputContext.getInputType()) {
            case MOUSE_MOVE: {
                return this.inputMainPhaseBubble(((TScreen)this.target).__hovered, inputContext) != null;
            }
            case MOUSE_DRAG: {
                return ((TScreen)this.target).__dragging != null && this.inputMainPhase(((TScreen)this.target).__dragging, inputContext);
            }
            case MOUSE_PRESS: {
                TElement resultEl;
                TElement initialFocused = ((TScreen)this.target).__focused;
                TParentElement result = this.inputMainPhaseBubble(((TScreen)this.target).__hovered, inputContext);
                TElement tElement = resultEl = result instanceof TElement ? (TElement)result : null;
                if (((TScreen)this.target).__dragging == null && resultEl != null) {
                    ((TScreen)this.target).__dragging = resultEl;
                    ((TScreen)this.target).__draggingButton = inputContext.getMouseButton();
                }
                if (((TScreen)this.target).__focused == initialFocused) {
                    ((TScreen)this.target).__focused = resultEl == null || !resultEl.isFocusable() ? null : resultEl;
                }
                return result != null;
            }
            case MOUSE_RELEASE: {
                TParentElement result = this.inputMainPhaseBubble(((TScreen)this.target).__hovered, inputContext);
                if (inputContext.getMouseButton() == ((TScreen)this.target).__draggingButton) {
                    if (((TScreen)this.target).__dragging != null) {
                        this.inputMainPhase(((TScreen)this.target).__dragging, TInputContext.ofMouseDragEnd(((TScreen)this.target).__draggingButton));
                    }
                    ((TScreen)this.target).__dragging = null;
                    ((TScreen)this.target).__draggingButton = -1;
                }
                return result != null;
            }
            case MOUSE_SCROLL: {
                return this.inputMainPhaseBubble(((TScreen)this.target).__hovered, inputContext) != null;
            }
            case KEY_PRESS: {
                boolean isTab;
                boolean bl = isTab = inputContext.getKeyboardKey().keyCode == 258;
                if (this.inputMainPhaseBubble(((TScreen)this.target).__focused, inputContext) != null) {
                    return true;
                }
                if (isTab) {
                    return ((TScreen)this.target).inputTabNavigation(TScreen.hasShiftDown());
                }
                return false;
            }
            case KEY_RELEASE: 
            case CHAR_TYPE: {
                return this.inputMainPhaseBubble(((TScreen)this.target).__focused, inputContext) != null;
            }
        }
        return false;
    }

    @ApiStatus.Internal
    @Nullable
    protected final TParentElement inputMainPhaseBubble(TParentElement targetElement, TInputContext inputContext) {
        Objects.requireNonNull(inputContext);
        if (targetElement == null) {
            return this.inputMainPhase((TParentElement)this.target, inputContext) ? (TParentElement)this.target : null;
        }
        if (this.inputMainPhase(targetElement, inputContext)) {
            return targetElement;
        }
        return targetElement.findParent(p -> this.inputMainPhase((TParentElement)p, inputContext));
    }

    @ApiStatus.Internal
    protected final boolean inputMainPhase(TParentElement targetElement, TInputContext inputContext) {
        Objects.requireNonNull(inputContext);
        if (targetElement == null) {
            return false;
        }
        if (targetElement.input(inputContext, TInputContext.InputDiscoveryPhase.MAIN)) {
            return true;
        }
        return targetElement.input(inputContext);
    }

    public final void onFilesDrop(List<Path> paths) {
        if (((TScreen)this.target).filesDragged(paths)) {
            return;
        }
        super.onFilesDrop(paths);
    }

    public final void resize(Minecraft client, int width, int height) {
        ((TScreen)this.target).setMousePosition(0, 0);
        ((TScreen)this.target).__hovered = null;
        ((TScreen)this.target).__focused = null;
        super.resize(client, width, height);
    }

    static class PositionedTooltip {
        final List<FormattedCharSequence> text;
        final ClientTooltipPositioner positioner;
        @Nullable
        private Font __tr = null;
        private int __trW = 0;

        PositionedTooltip(List<FormattedCharSequence> text, ClientTooltipPositioner positioner) {
            this.text = Optional.ofNullable(text).orElse(List.of(Component.literal((String)"").getVisualOrderText()));
            this.positioner = Optional.ofNullable(positioner).orElse(DefaultTooltipPositioner.INSTANCE);
        }

        public int getWidth(Font textRenderer) {
            if (textRenderer != this.__tr) {
                this.__tr = textRenderer;
                this.__trW = 0;
                for (FormattedCharSequence line : this.text) {
                    int w = textRenderer.width(line);
                    if (w <= this.__trW) continue;
                    this.__trW = w;
                }
                this.__trW += 8;
            }
            return this.__trW;
        }
    }
}

