/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import com.mojang.blaze3d.platform.Window;
import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreen;
import io.github.thecsdev.tcdcommons.api.client.gui.screen.TScreenWrapper;
import io.github.thecsdev.tcdcommons.api.client.util.interfaces.IParentScreenProvider;
import io.github.thecsdev.tcdcommons.api.hooks.client.gui.widget.GridWidgetHooks;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import java.awt.Point;
import java.util.List;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipPositioner;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public final class GuiUtils {
    private GuiUtils() {
    }

    public static void playClickSound() {
        TCDCommonsClient.MC_CLIENT.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((Holder)SoundEvents.UI_BUTTON_CLICK, (float)1.0f));
    }

    public static Screen showUrlPrompt(String url, boolean trusted) {
        return GuiUtils.showUrlPrompt(TCDCommonsClient.MC_CLIENT.screen, url, trusted);
    }

    public static Screen showUrlPrompt(Screen parent, String url, boolean trusted) {
        ConfirmLinkScreen screen = new ConfirmLinkScreen(accepted -> {
            if (accepted) {
                Util.getPlatform().openUri(url);
            }
            TCDCommonsClient.MC_CLIENT.setScreen(parent);
        }, url, trusted);
        TCDCommonsClient.MC_CLIENT.setScreen((Screen)screen);
        return screen;
    }

    public static Screen initScreen(Screen screen) throws NullPointerException {
        Objects.requireNonNull(screen);
        Minecraft client = TCDCommonsClient.MC_CLIENT;
        Window window = client.getWindow();
        int w = window.getGuiScaledWidth();
        int h = window.getGuiScaledHeight();
        screen.init(client, w, h);
        return screen;
    }

    public static Screen getCurrentScreenParent() {
        return GuiUtils.getParentScreen(TCDCommonsClient.MC_CLIENT.screen);
    }

    public static Screen getParentScreen(@Nullable Screen of) {
        Object tOf;
        if (of == null) {
            return null;
        }
        if (of instanceof IParentScreenProvider) {
            return ((IParentScreenProvider)of).getParentScreen();
        }
        if (of instanceof TScreenWrapper && (tOf = ((TScreenWrapper)of).getTargetTScreen()) instanceof IParentScreenProvider) {
            return ((IParentScreenProvider)tOf).getParentScreen();
        }
        return null;
    }

    public static ClientTooltipPositioner createDefaultTooltipPositioner(TElement target) {
        return (screenW, screenH, tX, tY, tW, tH) -> {
            TScreen parentScreen = target.getParentTScreen();
            if (parentScreen == null) {
                return new Vector2i(0, 0);
            }
            if (target.isFocused()) {
                int newX = target.getX() + 2;
                int newY = target.getEndY() + 4;
                if (newX + tW > screenW) {
                    newX -= tW - target.getWidth() + 4;
                }
                if (newY + tH > screenH) {
                    newY -= tH + target.getHeight() + 8;
                }
                return new Vector2i(newX, newY);
            }
            Point mousePos = parentScreen.getMousePosition();
            int newX = mousePos.x + 10;
            int newY = mousePos.y + 10;
            if (newX + tW > screenW) {
                newX -= tW + 15;
            }
            if (newY + tH > screenH) {
                newY -= tH + 15;
            }
            return new Vector2i(newX, newY);
        };
    }

    @Nullable
    public static Button findButtonWidgetOnScreen(Screen screen, Component buttonText) throws NullPointerException {
        Objects.requireNonNull(screen);
        Objects.requireNonNull(buttonText);
        return GuiUtils.__findButtonWidgetOnScreen(buttonText, screen.children().stream().map(e -> e).toList());
    }

    @ApiStatus.Internal
    @Nullable
    private static Button __findButtonWidgetOnScreen(Component buttonText, List<GuiEventListener> elements) {
        String btnTxtStr = buttonText.getString();
        Button foundBtn = null;
        for (GuiEventListener selectable : elements) {
            Button btn;
            if (selectable instanceof GridLayout) {
                GridLayout grid = (GridLayout)selectable;
                List<GuiEventListener> gridCh = GridWidgetHooks.getChildren(grid).stream().map(i -> (GuiEventListener)i).toList();
                return GuiUtils.__findButtonWidgetOnScreen(buttonText, gridCh);
            }
            if (!(selectable instanceof Button) || !btnTxtStr.equals((btn = (Button)selectable).getMessage().getString())) continue;
            foundBtn = btn;
        }
        return foundBtn;
    }
}

