/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.client.gui.util.UITexture;
import io.github.thecsdev.tcdcommons.api.util.io.HttpUtils;
import io.github.thecsdev.tcdcommons.api.util.thread.TaskScheduler;
import io.github.thecsdev.tcdcommons.client.TCDCommonsClient;
import io.github.thecsdev.tcdcommons.client.mixin.hooks.AccessorNativeImage;
import java.awt.Rectangle;
import java.io.Closeable;
import java.net.URI;
import java.net.URL;
import java.util.Locale;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.jetbrains.annotations.ApiStatus;

public final class UIExternalTexture
extends UITexture
implements Closeable {
    static final String THREAD_NAME = TCDCommons.getModID() + ":" + UIExternalTexture.class.getSimpleName().toLowerCase();
    @ApiStatus.Internal
    static final ExecutorService SCHEDULER = Executors.newCachedThreadPool(runnable -> {
        Thread thread = new Thread(runnable, THREAD_NAME);
        thread.setDaemon(true);
        return thread;
    });
    public static final UITexture FALLBACK_TEXTURE = new UITexture(TDrawContext.TEXTURE_ICONS, new Rectangle(0, 0, 64, 64));
    @Deprecated(since="3.7", forRemoval=true)
    public static final Cache<Object, UIExternalTexture> TEXTURE_CACHE = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).expireAfterAccess(10L, TimeUnit.MINUTES).maximumSize(32L).build();
    private boolean isClosed = false;
    private final TextureManager textureManager;
    private final NativeImage nativeImage;
    private final DynamicTexture nativeImageBackedTexture;
    private static long nextTexId;

    public UIExternalTexture(NativeImage image) throws NullPointerException, IllegalStateException {
        super(UIExternalTexture.generateTextureIdentifier());
        this.nativeImage = Objects.requireNonNull(image);
        this.nativeImageBackedTexture = new DynamicTexture(() -> this.getTextureID().toString(), this.nativeImage);
        this.textureManager = TCDCommonsClient.MC_CLIENT.getTextureManager();
        this.textureManager.register(this.getTextureID(), (AbstractTexture)this.nativeImageBackedTexture);
    }

    @Override
    public final void close() {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.textureManager.release(this.getTextureID());
        this.nativeImage.close();
    }

    protected final void finalize() throws Throwable {
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
    }

    public final boolean isClosed() {
        return this.isClosed;
    }

    public final int getNativeWidth() {
        return this.nativeImage.getWidth();
    }

    public final int getNativeHeight() {
        return this.nativeImage.getHeight();
    }

    public final int getNativeColor(int x, int y) throws IllegalArgumentException {
        return ((AccessorNativeImage)this.nativeImage).tcdcommons_getColor(x, y);
    }

    private static final ResourceLocation generateTextureIdentifier() {
        UUID uuid = UUID.randomUUID();
        String uid = String.format("%s_%s_%s_%s", Long.toString(System.currentTimeMillis()), Long.toString(++nextTexId), Long.toString(uuid.getMostSignificantBits()), Long.toString(uuid.getLeastSignificantBits()));
        return ResourceLocation.fromNamespaceAndPath((String)TCDCommons.getModID(), (String)(UIExternalTexture.class.getSimpleName().toLowerCase(Locale.ENGLISH) + "/" + uid));
    }

    @ApiStatus.Experimental
    public static final void loadTextureAsync(byte[] pngBytes, Consumer<UIExternalTexture> onReady, Consumer<Exception> onError) throws NullPointerException {
        Objects.requireNonNull(pngBytes);
        Objects.requireNonNull(onReady);
        Objects.requireNonNull(onError);
        SCHEDULER.submit(() -> {
            UIExternalTexture existing = (UIExternalTexture)TEXTURE_CACHE.getIfPresent((Object)pngBytes);
            if (existing != null) {
                TCDCommonsClient.MC_CLIENT.executeIfPossible(() -> onReady.accept(existing));
                return;
            }
            try {
                NativeImage nImage = NativeImage.read((byte[])pngBytes);
                TCDCommonsClient.MC_CLIENT.executeIfPossible(() -> {
                    UIExternalTexture eTex = new UIExternalTexture(nImage);
                    TEXTURE_CACHE.put((Object)pngBytes, (Object)eTex);
                    onReady.accept(eTex);
                });
            }
            catch (Exception e) {
                TCDCommonsClient.MC_CLIENT.executeIfPossible(() -> onError.accept(e));
            }
        });
    }

    @Deprecated(since="3.7", forRemoval=true)
    public static final void loadTextureAsync(URL textureUrl, ReentrantBlockableEventLoop<?> minecraftClientOrServer, Consumer<UIExternalTexture> onReady, Consumer<Exception> onError) throws NullPointerException {
        Objects.requireNonNull(textureUrl);
        Objects.requireNonNull(minecraftClientOrServer);
        Objects.requireNonNull(onReady);
        Objects.requireNonNull(onError);
        String cacheKey = textureUrl.toString().toLowerCase();
        UIExternalTexture cached = (UIExternalTexture)TEXTURE_CACHE.getIfPresent((Object)cacheKey);
        if (cached != null && !cached.isClosed()) {
            minecraftClientOrServer.executeIfPossible(() -> onReady.accept(cached));
            return;
        }
        Callable<NativeImage> nis = () -> {
            byte[] pngEntity = HttpUtils.httpGetSyncB(new URI(textureUrl.toString()), new Header[]{new BasicHeader("Accept", "image/png")});
            return NativeImage.read((byte[])pngEntity);
        };
        UIExternalTexture.loadTextureAsync(nis, minecraftClientOrServer, (UIExternalTexture tex) -> {
            TEXTURE_CACHE.put((Object)cacheKey, tex);
            onReady.accept((UIExternalTexture)tex);
        }, onError);
    }

    @Deprecated(since="3.7", forRemoval=true)
    public static final void loadTextureAsync(Callable<NativeImage> nativeImageSupplier, ReentrantBlockableEventLoop<?> minecraftClientOrServer, Consumer<UIExternalTexture> onReady, Consumer<Exception> onError) throws NullPointerException {
        Objects.requireNonNull(nativeImageSupplier);
        Objects.requireNonNull(minecraftClientOrServer);
        Objects.requireNonNull(onReady);
        Objects.requireNonNull(onError);
        AtomicReference<Object> result = new AtomicReference<Object>(null);
        AtomicReference<Object> raisedException = new AtomicReference<Object>(null);
        SCHEDULER.submit(() -> {
            NativeImage nativeImage = null;
            try {
                nativeImage = (NativeImage)nativeImageSupplier.call();
            }
            catch (Exception exc) {
                raisedException.set(exc);
            }
            NativeImage finalImage = nativeImage;
            minecraftClientOrServer.executeIfPossible(() -> {
                if (finalImage != null) {
                    result.set(new UIExternalTexture(finalImage));
                }
                if (result.get() == null && raisedException.get() == null) {
                    raisedException.set(new UnsupportedOperationException());
                }
                if (raisedException.get() != null) {
                    onError.accept((Exception)raisedException.get());
                } else {
                    onReady.accept((UIExternalTexture)result.get());
                }
            });
        });
    }

    static {
        TaskScheduler.schedulePeriodicCacheCleanup(TEXTURE_CACHE);
        nextTexId = 0L;
    }
}

