/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.util;

import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.client.gui.TParentElement;
import io.github.thecsdev.tcdcommons.api.client.gui.util.TDrawContext;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Objects;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

@Virtual
public class UITexture {
    public static final ResourceLocation TEXTURE_UV_DEBUG = ResourceLocation.fromNamespaceAndPath((String)TCDCommons.getModID(), (String)"textures/gui/uv_debug.png");
    @Nullable
    private final ResourceLocation textureId;
    private final Dimension textureSize;
    private final Rectangle textureUVs;

    public UITexture() {
        this(TEXTURE_UV_DEBUG);
    }

    public UITexture(ResourceLocation textureId) {
        this(textureId, 1, 1);
    }

    public UITexture(ResourceLocation textureId, int textureWidth, int textureHeight) {
        this(textureId, new Dimension(textureWidth, textureHeight));
    }

    public UITexture(ResourceLocation textureId, Dimension textureSize) {
        this(textureId, textureSize, 0, 0, 1, 1);
    }

    public UITexture(ResourceLocation textureId, Dimension textureSize, int u, int v, int uvW, int uvH) {
        this(textureId, textureSize, new Rectangle(u, v, uvW, uvH));
    }

    public UITexture(ResourceLocation textureId, int textureWidth, int textureHeight, int u, int v, int uvW, int uvH) {
        this(textureId, new Dimension(textureWidth, textureHeight), new Rectangle(u, v, uvW, uvH));
    }

    public UITexture(ResourceLocation textureId, Rectangle textureUVs) {
        this(textureId, new Dimension(256, 256), textureUVs);
    }

    public UITexture(ResourceLocation textureId, Dimension textureSize, Rectangle textureUVs) {
        this.textureId = textureId;
        this.textureSize = textureSize.getSize();
        this.textureUVs = textureUVs.getBounds();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UITexture other = (UITexture)obj;
        return Objects.equals(this.textureId, other.textureId) && this.textureUVs.equals(other.textureUVs) && this.textureSize.equals(other.textureSize);
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.textureId != null ? this.textureId.hashCode() : 0);
        result = 31 * result + this.textureUVs.hashCode();
        result = 31 * result + this.textureSize.hashCode();
        return result;
    }

    @Deprecated(since="3.6", forRemoval=true)
    public final ResourceLocation getTexture() {
        return this.textureId;
    }

    public final ResourceLocation getTextureID() {
        return this.textureId;
    }

    public final Dimension getTextureSize() {
        return this.textureSize.getSize();
    }

    public final Rectangle getTextureUVs() {
        return this.textureUVs.getBounds();
    }

    public final void drawTexture(TDrawContext pencil) {
        TParentElement curr = pencil.currentTarget;
        this.drawTexture(pencil, curr.getX(), curr.getY(), curr.getWidth(), curr.getHeight());
    }

    public final void drawTexture(GuiGraphics pencil, int x, int y, int width, int height) {
        if (this.textureId == null) {
            return;
        }
        pencil.blit(RenderPipelines.GUI_TEXTURED, this.textureId, x, y, (float)this.textureUVs.x, (float)this.textureUVs.y, width, height, this.textureUVs.width, this.textureUVs.height, this.textureSize.width, this.textureSize.height);
    }
}

