/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.network;

import dev.architectury.networking.NetworkManager;
import io.github.thecsdev.tcdcommons.api.network.CustomPayloadNetworkReceiver;
import io.netty.buffer.ByteBuf;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.ApiStatus;

public final class CustomPayloadNetwork {
    private CustomPayloadNetwork() {
    }

    @ApiStatus.Internal
    private static final NetworkManager.Side flow2side(PacketFlow packetFlow) {
        return switch (packetFlow) {
            case PacketFlow.SERVERBOUND -> NetworkManager.Side.C2S;
            case PacketFlow.CLIENTBOUND -> NetworkManager.Side.S2C;
            default -> throw new IllegalArgumentException("Invalid packet flow - " + String.valueOf(packetFlow));
        };
    }

    public static final CustomPayloadNetworkReceiver registerReciever(PacketFlow side, ResourceLocation id, CustomPayloadNetworkReceiver receiver) {
        NetworkManager.Side archSide = CustomPayloadNetwork.flow2side(Objects.requireNonNull(side));
        Objects.requireNonNull(id);
        Objects.requireNonNull(receiver);
        NetworkManager.registerReceiver((NetworkManager.Side)archSide, (ResourceLocation)id, (buffer, ctx) -> {
            ClientPacketListener connection = switch (archSide) {
                default -> throw new MatchException(null, null);
                case NetworkManager.Side.S2C -> ((LocalPlayer)ctx.getPlayer()).connection;
                case NetworkManager.Side.C2S -> ((ServerPlayer)ctx.getPlayer()).connection;
            };
            receiver.receiveCustomPayload(new CustomPayloadNetworkReceiver.PacketContext(){
                final /* synthetic */ PacketListener val$connection;
                final /* synthetic */ PacketFlow val$side;
                final /* synthetic */ ResourceLocation val$id;
                final /* synthetic */ RegistryFriendlyByteBuf val$buffer;
                final /* synthetic */ NetworkManager.PacketContext val$ctx;
                {
                    this.val$connection = packetListener;
                    this.val$side = packetFlow;
                    this.val$id = resourceLocation;
                    this.val$buffer = registryFriendlyByteBuf;
                    this.val$ctx = packetContext;
                }

                @Override
                public PacketListener getPacketListener() {
                    return this.val$connection;
                }

                @Override
                public PacketFlow getNetworkSide() {
                    return this.val$side;
                }

                @Override
                public ResourceLocation getPacketId() {
                    return this.val$id;
                }

                @Override
                public FriendlyByteBuf getPacketBuffer() {
                    return this.val$buffer;
                }

                @Override
                public Player getPlayer() {
                    return this.val$ctx.getPlayer();
                }
            });
        });
        return receiver;
    }

    public static final void sendC2S(ResourceLocation id, ByteBuf buffer) {
        Objects.requireNonNull(id);
        Objects.requireNonNull(buffer);
        try {
            NetworkManager.sendToServer((ResourceLocation)id, (RegistryFriendlyByteBuf)new RegistryFriendlyByteBuf(buffer, (RegistryAccess)Minecraft.getInstance().getConnection().registryAccess()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static final void sendS2C(ServerPlayer player, ResourceLocation id, ByteBuf buffer) {
        Objects.requireNonNull(player);
        Objects.requireNonNull(id);
        Objects.requireNonNull(buffer);
        try {
            NetworkManager.sendToPlayer((ServerPlayer)player, (ResourceLocation)id, (RegistryFriendlyByteBuf)new RegistryFriendlyByteBuf(buffer, player.registryAccess()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

