/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.registry;

import io.github.thecsdev.tcdcommons.api.event.TEvent;
import io.github.thecsdev.tcdcommons.api.event.TEventFactory;
import io.github.thecsdev.tcdcommons.api.registry.TRegistry;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterator;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;

public abstract class TAbstractMappedRegistry<T>
implements TRegistry<T> {
    static final String ERR_CANNOT_ADD = "This registry does not support registering new entries.";
    static final String ERR_CANNOT_REMOVE = "This registry does not support unregistering existing entries.";
    protected final Map<ResourceLocation, T> map = Collections.synchronizedMap(new LinkedHashMap());
    public final TEvent<MappedRegistryEvent<T>> eRegistered = TEventFactory.createLoop(new MappedRegistryEvent[0]);
    public final TEvent<MappedRegistryEvent<T>> eUnRegistered = TEventFactory.createLoop(new MappedRegistryEvent[0]);

    @Override
    public final Iterator<Map.Entry<ResourceLocation, T>> iterator() {
        return this.map.entrySet().iterator();
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    @Virtual
    public T register(ResourceLocation id, T entry) throws UnsupportedOperationException, NullPointerException, IllegalStateException {
        if (this.map.containsKey(Objects.requireNonNull(id))) {
            throw new IllegalStateException("An entry with the ID '" + String.valueOf(id) + "' is already registered.");
        }
        this.map.put(id, Objects.requireNonNull(entry));
        this.eRegistered.invoker().invoke(id, entry);
        return entry;
    }

    @Override
    @Virtual
    public T unregister(ResourceLocation id) throws UnsupportedOperationException, NullPointerException {
        Object entry = this.map.getOrDefault(Objects.requireNonNull(id), null);
        this.map.remove(id);
        if (id != null) {
            this.eUnRegistered.invoker().invoke(id, entry);
        }
        return entry;
    }

    @Override
    public final Optional<ResourceLocation> getKey(T entry) {
        for (Map.Entry<ResourceLocation, T> mapEntry : this) {
            if (!Objects.equals(entry, mapEntry.getValue())) continue;
            return Optional.of(mapEntry.getKey());
        }
        return Optional.empty();
    }

    @Override
    public final Optional<T> getValue(ResourceLocation id) {
        return Optional.ofNullable(this.map.getOrDefault(id, null));
    }

    @Override
    public final boolean containsKey(ResourceLocation id) {
        return this.map.containsKey(id);
    }

    @Override
    public final boolean containsValue(T entry) {
        return this.map.containsValue(entry);
    }

    @Override
    public final void forEach(Consumer<? super Map.Entry<ResourceLocation, T>> action) {
        TRegistry.super.forEach(action);
    }

    @Override
    public final Spliterator<Map.Entry<ResourceLocation, T>> spliterator() {
        return TRegistry.super.spliterator();
    }

    public static interface MappedRegistryEvent<T> {
        public void invoke(ResourceLocation var1, T var2);
    }
}

