/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util;

import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfo;
import io.github.thecsdev.tcdcommons.api.util.io.mod.ModInfoProvider;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.core.UUIDUtil;
import org.apache.commons.lang3.StringUtils;

public final class TUtils {
    private TUtils() {
    }

    public static void throwCrash(String message, Throwable cause) throws ReportedException {
        ReportedException exc = new ReportedException(new CrashReport(message, cause));
        throw exc;
    }

    public static UUID getOfflinePlayerUuid(String nickname) {
        return UUIDUtil.createOfflinePlayerUUID((String)nickname);
    }

    public static String getModName(String modId) {
        if (StringUtils.isAllBlank((CharSequence[])new CharSequence[]{modId})) {
            return "*";
        }
        ModInfo mi = ModInfoProvider.getInstance().getModInfo(modId);
        if (mi != null) {
            return mi.getName().getString();
        }
        return modId;
    }

    public static <T> List<T> safeSubList(List<T> list, int fromIndex, int toIndex) {
        int size = list.size();
        if (fromIndex >= size || toIndex <= 0 || fromIndex >= toIndex) {
            return Collections.emptyList();
        }
        fromIndex = Math.max(0, fromIndex);
        toIndex = Math.min(size, toIndex);
        try {
            return list.subList(fromIndex, toIndex);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }
}

