/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util;

import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.apache.commons.lang3.StringUtils;

public final class TextUtils {
    private TextUtils() {
    }

    public static MutableComponent literal(String text) {
        return Component.literal((String)text);
    }

    public static MutableComponent translatable(String translationKey, Object ... params) {
        return Component.translatable((String)translationKey, (Object[])params);
    }

    public static MutableComponent fLiteral(String text) {
        return TextUtils.formatted(text);
    }

    public static MutableComponent fTranslatable(String translationKey, Object ... params) {
        return TextUtils.formatted((Component)TextUtils.translatable(translationKey, params));
    }

    public static MutableComponent formatted(Component text) {
        return TextUtils.formatted(text.getString());
    }

    public static MutableComponent formatted(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return TextUtils.literal("");
        }
        MutableComponent result = TextUtils.literal("");
        if (((String)text).charAt(0) != '\u00a7') {
            text = "r" + (String)text;
        }
        for (String slice : ((String)text).split(Pattern.quote("\u00a7"))) {
            if (slice.length() == 0) {
                result.append(Character.toString('\u00a7'));
                continue;
            }
            ChatFormatting sliceFormat = ChatFormatting.getByCode((char)slice.charAt(0));
            if (sliceFormat == null) {
                result.append((Component)TextUtils.literal("\u00a7" + slice));
                continue;
            }
            slice = slice.substring(1);
            result.append((Component)TextUtils.literal(slice).withStyle(sliceFormat));
        }
        return result;
    }
}

