/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.io.repo.github;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import io.github.thecsdev.tcdcommons.api.util.io.HttpUtils;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResource;
import io.github.thecsdev.tcdcommons.api.util.io.cache.CachedResourceManager;
import io.github.thecsdev.tcdcommons.api.util.io.cache.IResourceFetchTask;
import io.github.thecsdev.tcdcommons.api.util.io.repo.RepositoryHostInfo;
import io.github.thecsdev.tcdcommons.api.util.io.repo.github.GitHubUserInfo;
import io.github.thecsdev.tcdcommons.api.util.io.repo.github.ugc.GitHubRepositoryInfo;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.thread.BlockableEventLoop;
import org.apache.http.Header;

@Deprecated(since="v3.12", forRemoval=true)
public final class GitHubHostInfo
extends RepositoryHostInfo {
    private static final GitHubHostInfo INSTANCE = new GitHubHostInfo();
    private static final String ID;
    private static final URL HTML_URL;
    private static final URL API_URL;
    private static final String DISPLAY_NAME;
    private static final String CACHE_ID_BASE = "api.github.com:";
    private static final int CACHE_USER_DURATION = 7;
    private static final int CACHE_REPO_DURATION = 5;

    private GitHubHostInfo() {
    }

    public static final GitHubHostInfo getInstance() {
        return INSTANCE;
    }

    @Override
    public final String getID() {
        return ID;
    }

    @Override
    public final URL getURL() {
        return HTML_URL;
    }

    @Override
    public final URL getApiURL() {
        return API_URL;
    }

    @Override
    public final String getDisplayName() {
        return DISPLAY_NAME;
    }

    @Override
    public final GitHubUserInfo fetchUserInfoByIdSync(final String userId) throws NullPointerException, IOException {
        Objects.requireNonNull(userId);
        final AtomicReference jsonStr = new AtomicReference();
        final AtomicReference fetchErr = new AtomicReference();
        CachedResourceManager.getResourceSync(ResourceLocation.parse((String)("api.github.com:user/" + userId + ".json")), new IResourceFetchTask<String>(){

            @Override
            public Class<String> getResourceType() {
                return String.class;
            }

            @Override
            public BlockableEventLoop<?> getMinecraftClientOrServer() {
                return null;
            }

            @Override
            public void onReady(String resource) {
                jsonStr.set(resource);
            }

            @Override
            public void onError(Exception exception) {
                fetchErr.set(exception);
            }

            @Override
            public CachedResource<String> fetchResourceSync() throws Exception {
                return CachedResource.ofString(HttpUtils.httpGetSyncS(new URI("https://api.github.com/user/" + userId), new Header[0]), Instant.now().plus(Duration.ofDays(7L)));
            }
        });
        if (fetchErr.get() != null) {
            throw new IOException(String.format("Failed to fetch user data for '%s'.", userId), (Throwable)fetchErr.get());
        }
        try {
            return new GitHubUserInfo((JsonObject)new Gson().fromJson(Objects.requireNonNull((String)jsonStr.get()), JsonObject.class));
        }
        catch (Exception exc) {
            String msg = String.format("Failed to parse user data JSON for '%s'.", userId);
            throw new IOException(msg, exc);
        }
    }

    public final GitHubUserInfo fetchUserInfoByNameSync(final String accountName) throws NullPointerException, IOException {
        Objects.requireNonNull(accountName);
        final AtomicReference jsonStr = new AtomicReference();
        final AtomicReference fetchErr = new AtomicReference();
        CachedResourceManager.getResourceSync(ResourceLocation.parse((String)("api.github.com:users/" + accountName.toLowerCase() + ".json")), new IResourceFetchTask<String>(){

            @Override
            public Class<String> getResourceType() {
                return String.class;
            }

            @Override
            public BlockableEventLoop<?> getMinecraftClientOrServer() {
                return null;
            }

            @Override
            public void onReady(String resource) {
                jsonStr.set(resource);
            }

            @Override
            public void onError(Exception exception) {
                fetchErr.set(exception);
            }

            @Override
            public CachedResource<String> fetchResourceSync() throws Exception {
                return CachedResource.ofString(HttpUtils.httpGetSyncS(new URI("https://api.github.com/users/" + accountName), new Header[0]), Instant.now().plus(Duration.ofDays(7L)));
            }
        });
        if (fetchErr.get() != null) {
            throw new IOException(String.format("Failed to fetch user data for '%s'.", accountName), (Throwable)fetchErr.get());
        }
        try {
            return new GitHubUserInfo((JsonObject)new Gson().fromJson(Objects.requireNonNull((String)jsonStr.get()), JsonObject.class));
        }
        catch (Exception exc) {
            String msg = String.format("Failed to parse user data JSON for '%s'.", accountName);
            throw new IOException(msg, exc);
        }
    }

    @Override
    public final GitHubRepositoryInfo fetchRepoInfoByIdSync(final String repoId) throws NullPointerException, IOException {
        Objects.requireNonNull(repoId);
        final AtomicReference jsonStr = new AtomicReference();
        final AtomicReference fetchErr = new AtomicReference();
        CachedResourceManager.getResourceSync(ResourceLocation.parse((String)("api.github.com:repositories/" + repoId + ".json")), new IResourceFetchTask<String>(){

            @Override
            public Class<String> getResourceType() {
                return String.class;
            }

            @Override
            public BlockableEventLoop<?> getMinecraftClientOrServer() {
                return null;
            }

            @Override
            public void onReady(String resource) {
                jsonStr.set(resource);
            }

            @Override
            public void onError(Exception exception) {
                fetchErr.set(exception);
            }

            @Override
            public CachedResource<String> fetchResourceSync() throws Exception {
                return CachedResource.ofString(HttpUtils.httpGetSyncS(new URI("https://api.github.com/repositories/" + repoId), new Header[0]), Instant.now().plus(Duration.ofDays(5L)));
            }
        });
        if (fetchErr.get() != null) {
            throw new IOException(String.format("Failed to fetch repository data for '%s'.", repoId), (Throwable)fetchErr.get());
        }
        try {
            return new GitHubRepositoryInfo((JsonObject)new Gson().fromJson(Objects.requireNonNull((String)jsonStr.get()), JsonObject.class));
        }
        catch (Exception exc) {
            String msg = String.format("Failed to parse repository data JSON for '%s'.", repoId);
            throw new IOException(msg, exc);
        }
    }

    public final GitHubRepositoryInfo fetchRepoInfoByNameSync(String authorAccountName, String repoName) throws NullPointerException, IOException {
        Objects.requireNonNull(authorAccountName);
        Objects.requireNonNull(repoName);
        final String fullName = authorAccountName.toLowerCase() + "/" + repoName.toLowerCase();
        final AtomicReference jsonStr = new AtomicReference();
        final AtomicReference fetchErr = new AtomicReference();
        CachedResourceManager.getResourceSync(ResourceLocation.parse((String)("api.github.com:repos/" + fullName + ".json")), new IResourceFetchTask<String>(){

            @Override
            public Class<String> getResourceType() {
                return String.class;
            }

            @Override
            public BlockableEventLoop<?> getMinecraftClientOrServer() {
                return null;
            }

            @Override
            public void onReady(String resource) {
                jsonStr.set(resource);
            }

            @Override
            public void onError(Exception exception) {
                fetchErr.set(exception);
            }

            @Override
            public CachedResource<String> fetchResourceSync() throws Exception {
                return CachedResource.ofString(HttpUtils.httpGetSyncS(new URI("https://api.github.com/repos/" + fullName), new Header[0]), Instant.now().plus(Duration.ofDays(5L)));
            }
        });
        if (fetchErr.get() != null) {
            throw new IOException(String.format("Failed to fetch repository data for '%s'.", fullName), (Throwable)fetchErr.get());
        }
        try {
            return new GitHubRepositoryInfo((JsonObject)new Gson().fromJson(Objects.requireNonNull((String)jsonStr.get()), JsonObject.class));
        }
        catch (Exception exc) {
            String msg = String.format("Failed to parse repository data JSON for '%s'.", fullName);
            throw new IOException(msg, exc);
        }
    }

    static {
        try {
            ID = "github.com";
            HTML_URL = URI.create("https://github.com/").toURL();
            API_URL = URI.create("https://api.github.com/").toURL();
            DISPLAY_NAME = "GitHub";
        }
        catch (MalformedURLException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

