/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.util.thread;

import com.google.common.cache.Cache;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.api.util.collections.IdealList;
import io.github.thecsdev.tcdcommons.api.util.thread.ProgressiveTask;
import java.lang.ref.WeakReference;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import net.minecraft.util.thread.ReentrantBlockableEventLoop;
import org.jetbrains.annotations.ApiStatus;

public final class TaskScheduler {
    private static final String THREAD_NAME = TCDCommons.getModID() + ":task_scheduler";
    private static final ScheduledExecutorService SCHEDULER = Executors.newScheduledThreadPool(1, runnable -> {
        Thread thread = new Thread(runnable, THREAD_NAME);
        thread.setDaemon(true);
        return thread;
    });
    private static final Queue<Map.Entry<Runnable, BooleanSupplier>> CONDITIONAL_TASK_QUEUE = Queues.newConcurrentLinkedQueue();
    private static final Set<WeakReference<Cache<?, ?>>> CACHE_CLEANUP = Sets.newConcurrentHashSet();

    private TaskScheduler() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, V> Cache<K, V> schedulePeriodicCacheCleanup(Cache<K, V> cache) throws NullPointerException {
        Objects.requireNonNull(cache);
        Set<WeakReference<Cache<?, ?>>> set = CACHE_CLEANUP;
        synchronized (set) {
            CACHE_CLEANUP.removeIf(entry -> entry.refersTo(cache));
            CACHE_CLEANUP.add(new WeakReference<Cache<K, V>>(cache));
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelPeriodicCacheCleanup(Cache<?, ?> cache) {
        Set<WeakReference<Cache<?, ?>>> set = CACHE_CLEANUP;
        synchronized (set) {
            CACHE_CLEANUP.removeIf(entry -> entry.refersTo(cache));
        }
    }

    public static void scheduleTask(ReentrantBlockableEventLoop<?> minecraftClientOrServer, long delay, TimeUnit unit, Runnable command) throws NullPointerException {
        Objects.requireNonNull(minecraftClientOrServer);
        Objects.requireNonNull(unit);
        Objects.requireNonNull(command);
        SCHEDULER.schedule(() -> minecraftClientOrServer.executeIfPossible(command), delay, unit);
    }

    @ApiStatus.Experimental
    public static void executeOnce(ReentrantBlockableEventLoop<?> minecraftClientOrServer, BooleanSupplier condition, Runnable command) throws NullPointerException {
        Objects.requireNonNull(minecraftClientOrServer);
        Objects.requireNonNull(condition);
        Objects.requireNonNull(command);
        CONDITIONAL_TASK_QUEUE.add(new AbstractMap.SimpleEntry<Runnable, BooleanSupplier>(() -> minecraftClientOrServer.executeIfPossible(command), condition));
    }

    public static void executeProgressiveTask(ProgressiveTask<?> task) throws IllegalStateException {
        if (task.isRunning()) {
            throw new IllegalStateException("Task already running.");
        }
        SCHEDULER.schedule(() -> task.executeSync(), 0L, TimeUnit.MILLISECONDS);
    }

    static {
        IdealList conditionalEntries = new IdealList();
        Runnable conditionalTaskExecutor = () -> {
            Queue<Map.Entry<Runnable, BooleanSupplier>> queue = CONDITIONAL_TASK_QUEUE;
            synchronized (queue) {
                while (!CONDITIONAL_TASK_QUEUE.isEmpty()) {
                    Map.Entry<Runnable, BooleanSupplier> next = CONDITIONAL_TASK_QUEUE.poll();
                    if (next == null) continue;
                    conditionalEntries.add(next);
                }
            }
            for (Map.Entry entry : conditionalEntries) {
                block8: {
                    try {
                        if (!((BooleanSupplier)entry.getValue()).getAsBoolean()) {
                        }
                        break block8;
                    }
                    catch (Exception e) {
                        new RuntimeException("Failed to execute scheduled task.", e).printStackTrace();
                        conditionalEntries.remove(entry);
                    }
                    continue;
                }
                conditionalEntries.remove(entry);
                ((Runnable)entry.getKey()).run();
            }
        };
        SCHEDULER.scheduleAtFixedRate(conditionalTaskExecutor, 1L, 1L, TimeUnit.SECONDS);
        Runnable cacheCleaningTask = () -> {
            Set<WeakReference<Cache<?, ?>>> set = CACHE_CLEANUP;
            synchronized (set) {
                List<Cache> caches = CACHE_CLEANUP.stream().map(entry -> (Cache)entry.get()).filter(entry -> entry != null).collect(Collectors.toList());
                CACHE_CLEANUP.removeIf(entry -> entry.refersTo(null));
                caches.forEach(cache -> {
                    Cache cache2 = cache;
                    synchronized (cache2) {
                        cache.cleanUp();
                    }
                });
            }
        };
        SCHEDULER.scheduleAtFixedRate(cacheCleaningTask, 5L, 10L, TimeUnit.MINUTES);
    }
}

