/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import io.github.thecsdev.tcdcommons.TCDCommons;
import io.github.thecsdev.tcdcommons.TCDCommonsConfig;
import io.github.thecsdev.tcdcommons.api.badge.ServerPlayerBadgeHandler;
import io.github.thecsdev.tcdcommons.api.client.badge.ClientPlayerBadge;
import io.github.thecsdev.tcdcommons.api.registry.TRegistries;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.StreamSupport;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.ApiStatus;

public final class PlayerBadgeCommand {
    public static final String TEXT_EDIT_OUTPUT = "commands.badges.edit.output";
    public static final String TEXT_CLEAR_OUTPUT = "commands.badges.clear.output";
    public static final String TEXT_QUERY_OUTPUT = "commands.badges.query.output";
    private static SuggestionProvider<CommandSourceStack> SUGGEST_PB = (context, builder) -> SharedSuggestionProvider.suggest(StreamSupport.stream(TRegistries.PLAYER_BADGE.spliterator(), false).filter(entry -> !(entry.getValue() instanceof ClientPlayerBadge)).map(entry -> Objects.toString(entry.getKey())), (SuggestionsBuilder)builder);

    private PlayerBadgeCommand() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        TCDCommonsConfig config = TCDCommons.getInstance().getConfig();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.literal((String)"badges").requires(scs -> config.enablePlayerBadges && scs.hasPermission(2));
        command.then(PlayerBadgeCommand.badges_edit());
        command.then(PlayerBadgeCommand.badges_clear());
        command.then(PlayerBadgeCommand.badges_query());
        dispatcher.register(command);
    }

    private static ArgumentBuilder<CommandSourceStack, ?> badges_edit() {
        return Commands.literal((String)"edit").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).then(((RequiredArgumentBuilder)Commands.argument((String)"badge", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_PB).then(Commands.literal((String)"set").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(ctx -> PlayerBadgeCommand.execute_edit((CommandContext<CommandSourceStack>)ctx, true))))).then(Commands.literal((String)"increase").then(Commands.argument((String)"value", (ArgumentType)IntegerArgumentType.integer()).executes(ctx -> PlayerBadgeCommand.execute_edit((CommandContext<CommandSourceStack>)ctx, false))))));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> badges_clear() {
        return Commands.literal((String)"clear").then(Commands.argument((String)"targets", (ArgumentType)EntityArgument.players()).executes(ctx -> PlayerBadgeCommand.execute_clear((CommandContext<CommandSourceStack>)ctx)));
    }

    private static ArgumentBuilder<CommandSourceStack, ?> badges_query() {
        return Commands.literal((String)"query").then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"badge", (ArgumentType)ResourceLocationArgument.id()).suggests(SUGGEST_PB).executes(ctx -> PlayerBadgeCommand.execute_query((CommandContext<CommandSourceStack>)ctx))));
    }

    private static int execute_edit(CommandContext<CommandSourceStack> context, boolean setOrIncrease) {
        try {
            Collection arg_targets = EntityArgument.getPlayers(context, (String)"targets");
            ResourceLocation arg_badge = ResourceLocationArgument.getId(context, (String)"badge");
            int arg_value = IntegerArgumentType.getInteger(context, (String)"value");
            AtomicInteger affected = new AtomicInteger();
            for (ServerPlayer target : arg_targets) {
                if (target == null) continue;
                ServerPlayerBadgeHandler statHandler = ServerPlayerBadgeHandler.getServerBadgeHandler(target);
                if (setOrIncrease) {
                    statHandler.setValue(arg_badge, arg_value);
                } else {
                    statHandler.increaseValue(arg_badge, arg_value);
                }
                affected.incrementAndGet();
                statHandler.sendStats(target);
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TCDCT.cmd_pb_edit_out((Component)TextUtils.literal(Objects.toString(arg_badge)), (Component)TextUtils.literal(Integer.toString(affected.get()))), false);
            return affected.get();
        }
        catch (CommandSyntaxException | IllegalStateException | NullPointerException e) {
            PlayerBadgeCommand.handleError(context, e);
            return -1;
        }
    }

    private static int execute_clear(CommandContext<CommandSourceStack> context) {
        try {
            Collection targets = EntityArgument.getPlayers(context, (String)"targets");
            AtomicInteger affected = new AtomicInteger();
            for (ServerPlayer target : targets) {
                if (target == null) continue;
                ServerPlayerBadgeHandler.getServerBadgeHandler(target).clearBadges();
                affected.incrementAndGet();
            }
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TCDCT.cmd_pb_clear_out((Component)TextUtils.literal(Integer.toString(affected.get()))), false);
            return affected.get();
        }
        catch (CommandSyntaxException e) {
            PlayerBadgeCommand.handleError(context, e);
            return -1;
        }
    }

    private static int execute_query(CommandContext<CommandSourceStack> context) {
        try {
            ServerPlayer arg_target = EntityArgument.getPlayer(context, (String)"target");
            ResourceLocation arg_badge = ResourceLocationArgument.getId(context, (String)"badge");
            ServerPlayerBadgeHandler spbh = ServerPlayerBadgeHandler.getServerBadgeHandler(arg_target);
            int value = spbh.getValue(arg_badge);
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> TCDCT.cmd_pb_query_out(arg_target.getDisplayName(), (Component)TextUtils.literal(Objects.toString(arg_badge)), (Component)TextUtils.literal(Integer.toString(value))), false);
            return value;
        }
        catch (CommandSyntaxException e) {
            PlayerBadgeCommand.handleError(context, e);
            return -1;
        }
    }

    @ApiStatus.Internal
    public static void handleError(CommandContext<CommandSourceStack> context, Throwable e) {
        if (e instanceof Error) {
            throw new Error("Unable to handle errors.", e);
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)TextUtils.translatable("command.failed", new Object[0]).append(":\n    " + e.getMessage()));
    }
}

