/*
 * Decompiled with CFR 0.152.
 */
package io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer;

import io.github.thecsdev.tcdcommons.api.client.gui.TElement;
import io.github.thecsdev.tcdcommons.api.client.gui.other.TLabelElement;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.AbstractFileListPanel;
import io.github.thecsdev.tcdcommons.api.client.gui.panel.explorer.item.FileListItem;
import io.github.thecsdev.tcdcommons.api.util.TextUtils;
import io.github.thecsdev.tcdcommons.api.util.annotations.Virtual;
import io.github.thecsdev.tcdcommons.api.util.enumerations.HorizontalAlignment;
import io.github.thecsdev.tcdcommons.api.util.interfaces.TFileFilter;
import io.github.thecsdev.tcdcommons.util.TCDCT;
import java.io.File;
import java.io.FileFilter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import net.minecraft.class_2561;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Virtual
@ApiStatus.Experimental
public class FileListPanel
extends AbstractFileListPanel<AbstractFileListPanel.FileListPanelProxy> {
    @ApiStatus.Internal
    protected static final FileFilter FF_HIDDEN_ROOT_FILES = new FileFilter(){

        @Override
        public final boolean accept(File pathname) {
            if (pathname == null) {
                return false;
            }
            try {
                File parent = pathname.getParentFile();
                if (parent != null && parent.getParent() == null && pathname.isHidden()) {
                    return false;
                }
            }
            catch (SecurityException se) {
                return false;
            }
            return true;
        }
    };
    @Nullable
    protected TFileFilter fileFilter;

    public FileListPanel(int x, int y, int width, int height, AbstractFileListPanel.FileListPanelProxy proxy) {
        super(x, y, width, height, proxy);
    }

    @Override
    @Virtual
    protected void init() throws NullPointerException {
        Path currPath = this.proxy.getCurrentPath();
        if (currPath == null) {
            return;
        }
        Path currentPathParent = currPath.getParent();
        this.fileFilter = this.proxy.getCurrentFileFilter();
        try {
            if (!Files.exists(currPath, new LinkOption[0])) {
                if (currentPathParent != null) {
                    this.addGoBackFileListItem(currentPathParent.toFile());
                }
                this.addCenteredLabel((class_2561)TCDCT.gui_explorer_fileList_errNoSuchDir());
                return;
            }
            File currFile = Files.isDirectory(currPath, new LinkOption[0]) ? currPath.toFile() : currPath.getParent().toFile();
            File[] childDirectories = currFile.listFiles(File::isDirectory);
            File[] childFiles = currFile.listFiles(File::isFile);
            if (childDirectories == null || childFiles == null) {
                throw new SecurityException("Access denied.");
            }
            File currFileParent = currFile.getParentFile();
            if (currFileParent != null) {
                this.addGoBackFileListItem(currFileParent);
            }
            for (File childDir : childDirectories) {
                this.addFileListItem(childDir);
            }
            for (File childFile : childFiles) {
                this.addFileListItem(childFile);
            }
        }
        catch (SecurityException se) {
            if (currentPathParent != null) {
                this.addGoBackFileListItem(currentPathParent.toFile());
            }
            this.addCenteredLabel((class_2561)TCDCT.gui_explorer_fileList_errNoAccess());
            return;
        }
    }

    public final boolean testFileFilter(@Nullable File file) {
        return FF_HIDDEN_ROOT_FILES.accept(file) && (this.fileFilter == null || this.fileFilter.accept(file));
    }

    @Override
    @Nullable
    protected FileListItem addFileListItem(@Nullable File file) {
        if (!this.testFileFilter(file)) {
            return null;
        }
        return super.addFileListItem(file);
    }

    @Virtual
    protected FileListItem addGoBackFileListItem(File parentDir) throws NullPointerException {
        FileListItem goBack = this.addFileListItem(Objects.requireNonNull(parentDir));
        goBack.setIcon(FileListItem.TEX_DIR_ALT);
        goBack.setText((class_2561)TextUtils.literal("..."));
        return goBack;
    }

    @Virtual
    @ApiStatus.Experimental
    protected TElement addCenteredLabel(@Nullable class_2561 text) {
        TLabelElement lbl = new TLabelElement(this.scrollPadding, this.getHeight() / 2 - 10, this.getWidth() - this.scrollPadding * 2, 20, text);
        lbl.setTextHorizontalAlignment(HorizontalAlignment.CENTER);
        this.addChild(lbl, true);
        return lbl;
    }
}

