/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.block.entity;

import com.google.common.collect.Sets;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_11565;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2621;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3708;
import net.minecraft.class_4844;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5561;
import net.minecraft.class_7225;
import noobanidus.mods.lootr.common.api.ILootrBlockEntityConverter;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.advancement.IContainerTrigger;
import noobanidus.mods.lootr.common.api.data.ILootrInfo;
import noobanidus.mods.lootr.common.api.data.LootrBlockType;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public abstract class LootrBarrelBlockEntity
extends class_2621
implements ILootrBlockEntity {
    private static Logger LOGGER = LogUtils.getLogger();
    private final class_2371<class_1799> items = class_2371.method_10213((int)27, (Object)class_1799.field_8037);
    private final Set<UUID> clientOpeners = new ObjectLinkedOpenHashSet();
    protected UUID infoId = null;
    protected boolean hasBeenOpened = false;
    private String cachedId;
    private final class_5561 openersCounter = new class_5561(){

        protected void method_31681(class_1937 level, class_2338 pos, class_2680 state) {
            if (!LootrBarrelBlockEntity.this.hasBeenOpened) {
                LootrBarrelBlockEntity.this.hasBeenOpened = true;
                LootrBarrelBlockEntity.this.markChanged();
            }
            LootrBarrelBlockEntity.this.playSound(state, class_3417.field_17604);
            LootrBarrelBlockEntity.this.updateBlockState(state, true);
        }

        protected void method_31683(class_1937 level, class_2338 pos, class_2680 state) {
            LootrBarrelBlockEntity.this.playSound(state, class_3417.field_17603);
            LootrBarrelBlockEntity.this.updateBlockState(state, false);
        }

        protected void method_31682(class_1937 level, class_2338 pos, class_2680 state, int p_155069_, int p_155070_) {
        }

        public boolean method_31679(class_1657 player) {
            class_1707 chestMenu;
            class_1703 class_17032 = player.field_7512;
            if (class_17032 instanceof class_1707 && (class_17032 = (chestMenu = (class_1707)class_17032).method_7629()) instanceof ILootrInventory) {
                ILootrInventory data = (ILootrInventory)class_17032;
                return data.getInfo().getInfoUUID().equals(LootrBarrelBlockEntity.this.getInfoUUID());
            }
            return false;
        }
    };
    protected boolean clientOpened = false;

    public LootrBarrelBlockEntity(class_2338 pWorldPosition, class_2680 pBlockState) {
        super(LootrRegistry.getBarrelBlockEntity(), pWorldPosition, pBlockState);
    }

    @Override
    public LootrBlockType getInfoBlockType() {
        return LootrBlockType.BARREL;
    }

    @Override
    @NotNull
    public UUID getInfoUUID() {
        if (this.infoId == null) {
            this.infoId = UUID.randomUUID();
        }
        return this.infoId;
    }

    @Override
    public boolean isPhysicallyOpen() {
        return this.method_11010().method_28498((class_2769)class_3708.field_18006) && (Boolean)this.method_11010().method_11654((class_2769)class_3708.field_18006) != false;
    }

    protected class_2371<class_1799> method_11282() {
        return this.items;
    }

    protected void method_11281(class_2371<class_1799> pItems) {
    }

    public void method_54873(@Nullable class_1657 player) {
    }

    public void method_11014(class_11368 input) {
        super.method_11014(input);
        this.method_54871(input);
        input.method_71426("LootrId", class_4844.field_25122).ifPresent(uuid -> {
            this.infoId = uuid;
        });
        this.hasBeenOpened = input.method_71433("LootrHasBeenOpened", false);
        if (this.infoId == null) {
            this.getInfoUUID();
        }
        this.clientOpeners.clear();
        input.method_71426("LootrOpeners", class_4844.field_47491).ifPresent(this.clientOpeners::addAll);
    }

    public void method_57569(class_11372 output) {
        super.method_57569(output);
        output.method_71478("LootrId");
    }

    protected void method_11007(class_11372 compound) {
        super.method_11007(compound);
        this.method_54872(compound);
        if (!LootrAPI.shouldDiscard()) {
            compound.method_71468("LootrId", class_4844.field_25122, (Object)this.getInfoUUID());
        }
        compound.method_71472("LootrHasBeenOpened", this.hasBeenOpened);
        if (this.field_11863 != null && this.field_11863.method_8608() && this.clientOpeners != null && !this.clientOpeners.isEmpty()) {
            compound.method_71468("LootrOpeners", class_4844.field_47491, this.clientOpeners);
        }
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.barrel");
    }

    protected class_1703 method_5465(int pContainerId, class_1661 pInventory) {
        return null;
    }

    public int method_5439() {
        return 27;
    }

    public void method_5435(class_11565 user) {
        if (user instanceof class_1657) {
            class_1657 pPlayer = (class_1657)user;
            if (!this.field_11865 && !pPlayer.method_7325()) {
                this.openersCounter.method_31684((class_1309)pPlayer, this.method_10997(), this.method_11016(), this.method_11010(), user.method_72381());
            }
        }
    }

    public void method_5432(class_11565 user) {
        if (user instanceof class_1657) {
            class_1657 pPlayer = (class_1657)user;
            if (!this.field_11865 && !pPlayer.method_7325()) {
                this.openersCounter.method_31685((class_1309)pPlayer, this.method_10997(), this.method_11016(), this.method_11010());
            }
        }
    }

    public void recheckOpen() {
        if (!this.field_11865) {
            this.openersCounter.method_31686(this.method_10997(), this.method_11016(), this.method_11010());
        }
    }

    protected void updateBlockState(class_2680 pState, boolean pOpen) {
        this.field_11863.method_8652(this.method_11016(), (class_2680)pState.method_11657((class_2769)class_3708.field_18006, (Comparable)Boolean.valueOf(pOpen)), 3);
    }

    protected void playSound(class_2680 pState, class_3414 pSound) {
        class_2382 vec3i = ((class_2350)pState.method_11654((class_2769)class_3708.field_16320)).method_62675();
        double d0 = (double)this.field_11867.method_10263() + 0.5 + (double)vec3i.method_10263() / 2.0;
        double d1 = (double)this.field_11867.method_10264() + 0.5 + (double)vec3i.method_10264() / 2.0;
        double d2 = (double)this.field_11867.method_10260() + 0.5 + (double)vec3i.method_10260() / 2.0;
        this.field_11863.method_43128(null, d0, d1, d2, pSound, class_3419.field_15245, 0.5f, this.field_11863.field_9229.method_43057() * 0.1f + 0.9f);
    }

    @Override
    public void markChanged() {
        this.method_5431();
        this.markDataChanged();
    }

    @Override
    public boolean hasBeenOpened() {
        return this.hasBeenOpened;
    }

    @Override
    @Nullable
    public Set<UUID> getClientOpeners() {
        return this.clientOpeners;
    }

    @Override
    public boolean isClientOpened() {
        return this.clientOpened;
    }

    @Override
    public void setClientOpened(boolean opened) {
        this.clientOpened = opened;
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        class_2487 result = super.method_16887(provider);
        Set currentOpeners = this.getVisualOpeners();
        if (currentOpeners != null) {
            result.method_67494("LootrOpeners", class_4844.field_47491, (Object)Sets.intersection((Set)currentOpeners, LootrAPI.getPlayerIds()));
        }
        return result;
    }

    @Nullable
    public class_2622 getUpdatePacket() {
        return class_2622.method_39026((class_2586)this, class_2586::method_16887);
    }

    @Override
    @NotNull
    public class_2338 getInfoPos() {
        return this.method_11016();
    }

    @Override
    public class_5321<class_52> getInfoLootTable() {
        return this.method_54869();
    }

    @Override
    @Nullable
    public class_2561 getInfoDisplayName() {
        return this.method_5476();
    }

    @Override
    @NotNull
    public class_5321<class_1937> getInfoDimension() {
        return this.method_10997().method_27983();
    }

    @Override
    public int getInfoContainerSize() {
        return this.method_5439();
    }

    @Override
    public long getInfoLootSeed() {
        return this.method_54870();
    }

    @Override
    @Nullable
    public class_2371<class_1799> getInfoReferenceInventory() {
        return null;
    }

    @Override
    public boolean isInfoReferenceInventory() {
        return false;
    }

    @Override
    public class_1937 getInfoLevel() {
        return this.method_10997();
    }

    @Override
    @Nullable
    public IContainerTrigger getTrigger() {
        return LootrRegistry.getBarrelTrigger();
    }

    @Override
    public String getInfoKey() {
        if (this.cachedId == null) {
            this.cachedId = ILootrInfo.generateInfoKey(this.getInfoUUID());
        }
        return this.cachedId;
    }

    @Override
    public int getPhysicalOpenerCount() {
        return this.openersCounter.method_31678();
    }

    public static class DefaultBlockEntityConverter
    implements ILootrBlockEntityConverter<LootrBarrelBlockEntity> {
        @Override
        public ILootrBlockEntity apply(LootrBarrelBlockEntity blockEntity) {
            return blockEntity;
        }

        @Override
        public class_2591<?> getBlockEntityType() {
            return LootrRegistry.getBarrelBlockEntity();
        }
    }
}

