/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.command;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.yggdrasil.response.NameAndId;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2248;
import net.minecraft.class_2262;
import net.minecraft.class_2277;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2383;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_2586;
import net.minecraft.class_2621;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3341;
import net.minecraft.class_39;
import net.minecraft.class_3908;
import net.minecraft.class_52;
import net.minecraft.class_5251;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import noobanidus.mods.lootr.common.api.LootrAPI;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.block.LootrBarrelBlock;
import noobanidus.mods.lootr.common.block.LootrChestBlock;
import noobanidus.mods.lootr.common.block.LootrShulkerBlock;
import noobanidus.mods.lootr.common.block.entity.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.common.data.DataStorage;
import noobanidus.mods.lootr.common.data.LootrInventory;
import noobanidus.mods.lootr.common.data.LootrSavedData;
import noobanidus.mods.lootr.common.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.common.mixins.AccessorMixinBaseContainerBlockEntity;
import org.jetbrains.annotations.Nullable;

public class CommandLootr {
    private static List<class_5321<class_52>> tables = null;
    private static List<String> tableNames = null;
    private CommandDispatcher<class_2168> dispatcher;

    public CommandLootr(CommandDispatcher<class_2168> dispatcher) {
        this.dispatcher = dispatcher;
    }

    private static List<class_5321<class_52>> getTables() {
        if (tables == null) {
            tables = new ArrayList<class_5321<class_52>>(class_39.method_270());
            tableNames = tables.stream().map(o -> o.method_29177().toString()).toList();
        }
        return tables;
    }

    private static List<String> getTableNames() {
        CommandLootr.getTables();
        return tableNames;
    }

    public static void createBlock(class_2168 c, @Nullable class_2248 block, @Nullable class_5321<class_52> incomingTable) {
        class_3218 world = c.method_9225();
        class_243 incomingPos = c.method_9222();
        class_2338 pos = new class_2338((int)incomingPos.field_1352, (int)incomingPos.field_1351, (int)incomingPos.field_1350);
        class_5321<class_52> table = incomingTable == null ? CommandLootr.getTables().get(world.method_8409().method_43048(CommandLootr.getTables().size())) : incomingTable;
        if (block == null) {
            LootrChestMinecartEntity cart = new LootrChestMinecartEntity(LootrRegistry.getMinecart(), (class_1937)world);
            cart.method_5814((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5);
            class_1297 e = c.method_9228();
            if (e != null) {
                cart.method_36456(e.method_36454());
            }
            cart.method_7562(table, world.method_8409().method_43055());
            world.method_8649((class_1297)cart);
            c.method_9226(() -> class_2561.method_43469((String)"lootr.commands.summon", (Object[])new Object[]{class_2564.method_10885((class_2561)class_2561.method_43469((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1060)).method_10982(Boolean.valueOf(true)))), table.toString()}), false);
        } else {
            class_2680 placementState = block.method_9564();
            class_1297 e = c.method_9228();
            if (e != null) {
                class_2754 prop = null;
                class_2350 dir = class_2350.method_10159((class_1297)e)[0].method_10153();
                if (placementState.method_28498((class_2769)LootrBarrelBlock.field_16320)) {
                    prop = LootrBarrelBlock.field_16320;
                } else if (placementState.method_28498((class_2769)LootrChestBlock.field_10768)) {
                    prop = LootrChestBlock.field_10768;
                    dir = e.method_5735().method_10153();
                } else if (placementState.method_28498((class_2769)LootrShulkerBlock.field_11496)) {
                    prop = LootrShulkerBlock.field_11496;
                }
                if (prop != null) {
                    placementState = (class_2680)placementState.method_11657((class_2769)prop, (Comparable)dir);
                }
            }
            world.method_8652(pos, placementState, 2);
            class_2586 class_25862 = world.method_8321(pos);
            if (class_25862 instanceof class_2621) {
                class_2621 randomizableBe = (class_2621)class_25862;
                randomizableBe.method_54867(table, world.method_8409().method_43055());
            }
            c.method_9226(() -> class_2561.method_43469((String)"lootr.commands.create", (Object[])new Object[]{class_2561.method_43471((String)block.method_63499()), class_2564.method_10885((class_2561)class_2561.method_43469((String)"lootr.commands.blockpos", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}).method_10862(class_2583.field_24360.method_27703(class_5251.method_27718((class_124)class_124.field_1060)).method_10982(Boolean.valueOf(true)))), table.toString()}), false);
        }
    }

    private static class_2371<class_1799> copyItemList(class_2371<class_1799> reference) {
        class_2371 contents = class_2371.method_10213((int)reference.size(), (Object)class_1799.field_8037);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((class_1799)reference.get(i)).method_7972());
        }
        return contents;
    }

    public CommandLootr register() {
        this.dispatcher.register(this.builder((LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"lootr").requires(p -> p.method_9259(2)))));
        this.dispatcher = null;
        return this;
    }

    private RequiredArgumentBuilder<class_2168, class_2960> suggestTables() {
        return class_2170.method_9244((String)"table", (ArgumentType)class_2232.method_9441()).suggests((c, build) -> class_2172.method_9265(CommandLootr.getTableNames(), (SuggestionsBuilder)build));
    }

    public LiteralArgumentBuilder<class_2168> builder(LiteralArgumentBuilder<class_2168> builder) {
        builder.executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43471((String)"lootr.commands.usage"), false);
            return 1;
        });
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"barrel").executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), LootrRegistry.getBarrelBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), LootrRegistry.getBarrelBlock(), (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2232.method_9443((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"trapped_chest").executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), LootrRegistry.getTrappedChestBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), LootrRegistry.getTrappedChestBlock(), (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2232.method_9443((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"chest").executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), LootrRegistry.getChestBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), LootrRegistry.getChestBlock(), (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2232.method_9443((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"shulker").executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), LootrRegistry.getShulkerBlock(), null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), LootrRegistry.getShulkerBlock(), (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2232.method_9443((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Must provide player name."), true);
            return 1;
        })).executes(c -> {
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((class_2168)c.getSource()).method_9211().method_73550().comp_839().findProfileByName(playerName);
            if (!opt_profile.isPresent()) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            NameAndId profile = (NameAndId)opt_profile.get();
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)(LootrAPI.clearPlayerLoot(profile.id()) ? "Cleared stored inventories for " + playerName : "No stored inventories for " + playerName + " to clear")), true);
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"cart").executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), null, null);
            return 1;
        })).then(this.suggestTables().executes(c -> {
            CommandLootr.createBlock((class_2168)c.getSource(), null, (class_5321<class_52>)class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2232.method_9443((CommandContext)c, (String)"table")));
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"custom").executes(c -> {
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2680 state = level.method_8320(pos);
            if (!state.method_26164(LootrTags.Blocks.CUSTOM_ELIGIBLE)) {
                pos = pos.method_10074();
                state = level.method_8320(pos);
            }
            if (!state.method_26164(LootrTags.Blocks.CUSTOM_ELIGIBLE)) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on the container you wish to convert."), false);
            } else {
                class_2586 blockEntity = level.method_8321(pos);
                if (blockEntity instanceof class_2624) {
                    class_2624 container = (class_2624)blockEntity;
                } else {
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on the container you wish to convert."), false);
                }
                class_2371<class_1799> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
                class_2680 newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().method_9564());
                class_2371<class_1799> custom = CommandLootr.copyItemList(reference);
                level.method_8544(pos);
                level.method_8501(pos, newState);
                class_2586 te = level.method_8321(pos);
                if (!(te instanceof LootrInventoryBlockEntity)) {
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                } else {
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.method_5431();
                }
            }
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open_as").executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Must provide player name."), true);
            return 1;
        })).executes(c -> {
            ILootrBlockEntity ibe;
            String playerName = StringArgumentType.getString((CommandContext)c, (String)"profile");
            Optional opt_profile = ((class_2168)c.getSource()).method_9211().method_73550().comp_839().findProfileByName(playerName);
            if (!opt_profile.isPresent()) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid player name: " + playerName + ", profile not found in the cache.")));
                return 0;
            }
            NameAndId profile = (NameAndId)opt_profile.get();
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 te = level.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                te = level.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
                return 0;
            }
            LootrSavedData data = DataStorage.getData(ibe);
            if (data == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"No Lootr data found for this container."), false);
                return 0;
            }
            LootrInventory inventory = data.getInventory(profile.id());
            if (inventory == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("No stored inventory for " + playerName + " found.")), true);
                return 0;
            }
            class_3222 player = ((class_2168)c.getSource()).method_44023();
            if (player == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Command can only be executed by a player"), false);
                return 0;
            }
            player.method_17355((class_3908)inventory);
            return 1;
        }));
        builder.then(((LiteralArgumentBuilder)class_2170.method_9247((String)"open_as_uuid").executes(c -> {
            ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Must provide player UUID."), true);
            return 1;
        })).then(class_2170.method_9244((String)"uuid", (ArgumentType)StringArgumentType.string()).executes(c -> {
            ILootrBlockEntity ibe;
            UUID id;
            String uuid = StringArgumentType.getString((CommandContext)c, (String)"uuid");
            try {
                id = UUID.fromString(uuid);
            }
            catch (IllegalArgumentException exception) {
                ((class_2168)c.getSource()).method_9213((class_2561)class_2561.method_43470((String)("Invalid UUID: " + uuid)));
                return 0;
            }
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 te = level.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                te = level.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
                return 0;
            }
            LootrSavedData data = DataStorage.getData(ibe);
            LootrInventory inventory = data.getInventory(id);
            if (inventory == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("No stored inventory for " + String.valueOf(id) + " found.")), true);
                return 0;
            }
            class_3222 player = ((class_2168)c.getSource()).method_44023();
            if (player == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Command can only be executed by a player"), false);
                return 0;
            }
            player.method_17355((class_3908)inventory);
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"id").executes(c -> {
            ILootrBlockEntity ibe;
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 world = ((class_2168)c.getSource()).method_9225();
            class_2586 te = world.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(te) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                te = world.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(te)) == null) {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"The ID of this inventory is: ").method_10852((class_2561)class_2564.method_47523((String)ibe.getInfoUUID().toString())), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"refresh").executes(c -> {
            ILootrBlockEntity ibe;
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 be = level.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(be) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                be = level.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(be)) != null) {
                LootrAPI.setRefreshing(ibe);
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Container with ID " + String.valueOf(ibe.getInfoUUID()) + " has been set to refresh with a delay of " + LootrAPI.getRefreshValue())), false);
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"decay").executes(c -> {
            ILootrBlockEntity ibe;
            class_2338 pos = class_2338.method_49638((class_2374)((class_2168)c.getSource()).method_9222());
            class_3218 level = ((class_2168)c.getSource()).method_9225();
            class_2586 be = level.method_8321(pos);
            if (!(LootrAPI.resolveBlockEntity(be) instanceof ILootrBlockEntity)) {
                pos = pos.method_10074();
                be = level.method_8321(pos);
            }
            if ((ibe = LootrAPI.resolveBlockEntity(be)) != null) {
                LootrAPI.setDecaying(ibe);
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("Container with ID " + String.valueOf(ibe.getInfoUUID()) + " has been set to decay with a delay of " + LootrAPI.getDecayValue())), false);
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)"Please stand on a valid Lootr container."), false);
            }
            return 1;
        }));
        builder.then(class_2170.method_9247((String)"openers").then(class_2170.method_9244((String)"location", (ArgumentType)class_2277.method_9737()).executes(c -> {
            class_2338 position = class_2277.method_9734((CommandContext)c, (String)"location").method_9704((class_2168)c.getSource());
            class_3218 world = ((class_2168)c.getSource()).method_9225();
            class_2586 blockEntity = world.method_8321(position);
            ILootrBlockEntity ibe = LootrAPI.resolveBlockEntity(blockEntity);
            if (ibe != null) {
                Set<UUID> openers = ibe.getActualOpeners();
                if (openers != null) {
                    ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("BlockEntity at location " + String.valueOf(position) + " has " + openers.size() + " openers. UUIDs as follows:")), true);
                    for (UUID uuid : openers) {
                        Optional prof = ((class_2168)c.getSource()).method_9211().method_73550().comp_4624().method_73290(uuid);
                        ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("UUID: " + String.valueOf(uuid) + ", user profile: " + (prof.isPresent() ? ((GameProfile)prof.get()).name() : "null"))), true);
                    }
                }
            } else {
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)("No Lootr block entity exists at location: " + String.valueOf(position))), false);
            }
            return 1;
        })));
        builder.then(class_2170.method_9247((String)"convert").then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(context -> {
            class_3341 bounds = class_3341.method_34390((class_2382)class_2262.method_9696((CommandContext)context, (String)"from"), (class_2382)class_2262.method_9696((CommandContext)context, (String)"to"));
            class_1923 start = new class_1923(new class_2338(bounds.method_35415(), bounds.method_35416(), bounds.method_35417()));
            class_1923 stop = new class_1923(new class_2338(bounds.method_35418(), bounds.method_35419(), bounds.method_35420()));
            ArrayList<class_1923> positions = new ArrayList<class_1923>();
            for (int x = start.field_9181; x <= stop.field_9181; ++x) {
                for (int z = start.field_9180; z <= stop.field_9180; ++z) {
                    positions.add(new class_1923(x, z));
                }
            }
            class_3218 level = ((class_2168)context.getSource()).method_9225();
            for (class_1923 chunkPos : positions) {
                class_2818 chunk = level.method_8497(chunkPos.field_9181, chunkPos.field_9180);
                ArrayList<class_2338> convertableBlocks = new ArrayList<class_2338>();
                for (class_2338 pos : chunk.method_12021()) {
                    if (!bounds.method_14662((class_2382)pos)) continue;
                    convertableBlocks.add(pos);
                }
                if (convertableBlocks.isEmpty()) continue;
                for (class_2338 pos : convertableBlocks) {
                    class_2680 state;
                    class_2621 lootContainer;
                    class_2586 blockEntity = chunk.method_12201(pos, class_2818.class_2819.field_12860);
                    if (!(blockEntity instanceof class_2624) || blockEntity instanceof class_2621 && (lootContainer = (class_2621)blockEntity).method_54869() != null || (state = blockEntity.method_11010()).method_26164(LootrTags.Blocks.CUSTOM_ELIGIBLE) || blockEntity.method_11017().method_53254().method_40220(LootrTags.BlockEntity.CUSTOM_INELIGIBLE)) continue;
                    class_2371<class_1799> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
                    class_2680 newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().method_9564());
                    class_2371<class_1799> custom = CommandLootr.copyItemList(reference);
                    level.method_8544(pos);
                    level.method_8501(pos, newState);
                    class_2586 te = level.method_8321(pos);
                    if (!(te instanceof LootrInventoryBlockEntity)) {
                        ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Unable to convert chest, BlockState is not a Lootr Inventory block."), false);
                        continue;
                    }
                    LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
                    inventory.setCustomInventory(custom);
                    inventory.method_5431();
                }
            }
            return 1;
        }))));
        builder.then(class_2170.method_9247((String)"cclear").then(class_2170.method_9244((String)"entities", (ArgumentType)class_2186.method_9306()).executes(c -> {
            Collection entities = class_2186.method_9317((CommandContext)c, (String)"entities");
            for (class_1297 entity : entities) {
                if (!(entity instanceof class_1657)) continue;
                class_1657 player = (class_1657)entity;
                String name = player.method_5820();
                ((class_2168)c.getSource()).method_9226(() -> class_2561.method_43470((String)(DataStorage.clearInventories(player.method_5667()) ? "Cleared stored inventories for " + name : "No stored inventories for " + name + " to clear")), true);
            }
            return 1;
        })));
        return builder;
    }

    private static class_2680 updateBlockState(class_2680 oldState, class_2680 newState) {
        if (oldState.method_28498((class_2769)class_2741.field_12525) && newState.method_28498((class_2769)class_2741.field_12525)) {
            newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12525, (Comparable)((class_2350)oldState.method_11654((class_2769)class_2741.field_12525)));
        }
        if (oldState.method_28498((class_2769)class_2383.field_11177) && newState.method_28498((class_2769)class_2383.field_11177)) {
            newState = (class_2680)newState.method_11657((class_2769)class_2383.field_11177, (Comparable)((class_2350)oldState.method_11654((class_2769)class_2383.field_11177)));
        }
        if (oldState.method_28498((class_2769)class_2741.field_12508) && newState.method_28498((class_2769)class_2741.field_12508)) {
            newState = (class_2680)newState.method_11657((class_2769)class_2741.field_12508, (Comparable)((Boolean)oldState.method_11654((class_2769)class_2741.field_12508)));
        }
        return newState;
    }
}

