/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.api;

import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.storage.loot.LootTable;
import noobanidus.mods.lootr.common.api.MenuBuilder;
import noobanidus.mods.lootr.common.api.client.ClientTextureType;
import noobanidus.mods.lootr.common.api.data.ILootrInfoProvider;
import noobanidus.mods.lootr.common.api.data.ILootrSavedData;
import noobanidus.mods.lootr.common.api.data.LootFiller;
import noobanidus.mods.lootr.common.api.data.blockentity.ILootrBlockEntity;
import noobanidus.mods.lootr.common.api.data.entity.ILootrCart;
import noobanidus.mods.lootr.common.api.data.inventory.ILootrInventory;
import noobanidus.mods.lootr.common.api.filter.ILootrFilter;
import org.jetbrains.annotations.Nullable;

public interface ILootrAPI {
    public Set<UUID> getPlayerIds();

    public MinecraftServer getServer();

    default public int getCurrentTicks() {
        MinecraftServer server = this.getServer();
        if (server == null) {
            return -1;
        }
        return server.getTickCount();
    }

    public boolean isFakePlayer(Player var1);

    default public boolean clearPlayerLoot(ServerPlayer entity) {
        return this.clearPlayerLoot(entity.getUUID());
    }

    public boolean clearPlayerLoot(UUID var1);

    @Nullable
    public ILootrInventory getInventory(ILootrInfoProvider var1, ServerPlayer var2, LootFiller var3);

    @Nullable
    public ILootrInventory getInventory(ILootrInfoProvider var1, ServerPlayer var2, LootFiller var3, MenuBuilder var4);

    @Nullable
    public ILootrSavedData getData(ILootrInfoProvider var1);

    public long getLootSeed(long var1);

    public boolean shouldDiscard();

    public float getExplosionResistance(Block var1, float var2);

    public boolean isBlastResistant();

    public boolean isBlastImmune();

    public float getDestroyProgress(BlockState var1, Player var2, BlockGetter var3, BlockPos var4, float var5);

    public int getAnalogOutputSignal(BlockState var1, Level var2, BlockPos var3, int var4, @Nullable Direction var5);

    public boolean shouldPowerComparators();

    public boolean shouldNotify(int var1);

    public int getNotificationDelay();

    public boolean isNotificationsEnabled();

    public boolean isMessageStylesEnabled();

    public ClientTextureType getTextureType();

    default public boolean isNewTextures() {
        return this.getTextureType() == ClientTextureType.NEW;
    }

    default public boolean isOldTextures() {
        return this.getTextureType() == ClientTextureType.OLD;
    }

    default public boolean isVanillaTextures() {
        return this.getTextureType() == ClientTextureType.VANILLA;
    }

    default public boolean isDefaultTextures() {
        return this.getTextureType() == ClientTextureType.NEW;
    }

    public boolean isDisabled();

    public boolean isLootTableBlacklisted(ResourceKey<LootTable> var1);

    public boolean isDimensionBlocked(ResourceKey<Level> var1);

    public boolean isDimensionDecaying(ResourceKey<Level> var1);

    public boolean isDimensionRefreshing(ResourceKey<Level> var1);

    public Set<ResourceKey<Level>> getDimensionBlacklist();

    public Set<ResourceKey<Level>> getDimensionWhitelist();

    public Set<ResourceKey<LootTable>> getLootTableBlacklist();

    public Set<String> getLootModidBlacklist();

    public Set<String> getModidDimensionWhitelist();

    public Set<String> getModidDimensionBlacklist();

    public boolean isDecaying(ILootrInfoProvider var1);

    public boolean isRefreshing(ILootrInfoProvider var1);

    public Set<String> getModidDecayWhitelist();

    public Set<ResourceKey<LootTable>> getDecayWhitelist();

    public Set<ResourceKey<Level>> getDecayDimensions();

    public Set<String> getRefreshModids();

    public Set<ResourceKey<LootTable>> getRefreshWhitelist();

    public Set<ResourceKey<Level>> getRefreshDimensions();

    public boolean reportUnresolvedTables();

    public boolean isCustomTrapped();

    public boolean isWorldBorderSafe(Level var1, BlockPos var2);

    public boolean isWorldBorderSafe(Level var1, ChunkPos var2);

    public boolean shouldCheckWorldBorder();

    public int getMaximumAge();

    public boolean hasExpired(long var1);

    public boolean shouldConvertMineshafts();

    public boolean shouldConvertElytras();

    public int getDecayValue();

    public boolean shouldDecayAll();

    public int getRefreshValue();

    public boolean shouldRefreshAll();

    public Style getInvalidStyle();

    public Style getDecayStyle();

    public Style getRefreshStyle();

    public Style getChatStyle();

    public Component getInvalidTableComponent(ResourceKey<LootTable> var1);

    public boolean canDestroyOrBreak(Player var1);

    public boolean isBreakDisabled();

    public boolean isBreakEnabled();

    public boolean isFakePlayerBreakEnabled();

    public boolean shouldDropPlayerLoot();

    public boolean shouldPerformDecayWhileTicking();

    public boolean shouldPerformRefreshWhileTicking();

    public boolean shouldStartDecayWhileTicking();

    public boolean shouldStartRefreshWhileTicking();

    public boolean performPiecewiseCheck();

    default public boolean isAwarded(ILootrInfoProvider provider, ServerPlayer player) {
        return this.isAwarded(provider.getInfoUUID(), player);
    }

    public boolean isAwarded(UUID var1, ServerPlayer var2);

    default public void award(ILootrInfoProvider provider, ServerPlayer player) {
        this.award(provider.getInfoUUID(), player);
    }

    public void award(UUID var1, ServerPlayer var2);

    public int getRemainingDecayValue(ILootrInfoProvider var1);

    public boolean isDecayed(ILootrInfoProvider var1);

    public void setDecaying(ILootrInfoProvider var1);

    public void removeDecayed(ILootrInfoProvider var1);

    public int getRemainingRefreshValue(ILootrInfoProvider var1);

    public boolean isRefreshed(ILootrInfoProvider var1);

    public void setRefreshing(ILootrInfoProvider var1);

    public void removeRefreshed(ILootrInfoProvider var1);

    @Nullable
    public BlockState replacementBlockState(BlockState var1);

    public void handleProviderSneak(@Nullable ILootrInfoProvider var1, ServerPlayer var2);

    public void handleProviderOpen(@Nullable ILootrInfoProvider var1, ServerPlayer var2);

    public void handleProviderTick(@Nullable ILootrInfoProvider var1);

    public boolean anyUnloadedChunks(ResourceKey<Level> var1, Set<ChunkPos> var2);

    public <T extends BlockEntity> ILootrBlockEntity resolveBlockEntity(T var1);

    public <T extends Entity> ILootrCart resolveEntity(T var1);

    public boolean isTaggedStructurePresent(ServerLevel var1, ChunkPos var2, TagKey<Structure> var3, BlockPos var4);

    public void playerDestroyed(Level var1, Player var2, BlockPos var3, @Nullable BlockEntity var4);

    public void refreshSections();

    public List<ILootrFilter> getFilters();
}

