/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.neoforge.event;

import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.server.ServerAboutToStartEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;

@EventBusSubscriber(modid="lootr")
public class HandleChunk {
    public static final Map<ResourceKey<Level>, Set<ChunkPos>> LOADED_CHUNKS = Collections.synchronizedMap(new Object2ObjectLinkedOpenHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load event) {
        ChunkAccess chunk;
        if (!event.getLevel().isClientSide() && (chunk = event.getChunk()).getPersistedStatus().isOrAfter(ChunkStatus.FULL) && chunk instanceof LevelChunk) {
            LevelChunk lChunk = (LevelChunk)chunk;
            Map<ResourceKey<Level>, Set<ChunkPos>> map = LOADED_CHUNKS;
            synchronized (map) {
                Set chunkSet = LOADED_CHUNKS.computeIfAbsent((ResourceKey<Level>)lChunk.getLevel().dimension(), k -> Collections.synchronizedSet(new ObjectLinkedOpenHashSet()));
                chunkSet.add(chunk.getPos());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerStarted(ServerAboutToStartEvent event) {
        Map<ResourceKey<Level>, Set<ChunkPos>> map = LOADED_CHUNKS;
        synchronized (map) {
            LOADED_CHUNKS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        Map<ResourceKey<Level>, Set<ChunkPos>> map = LOADED_CHUNKS;
        synchronized (map) {
            LOADED_CHUNKS.clear();
        }
    }
}

